/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.Map;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public interface BlockStateWrapper
extends Comparable<BlockStateWrapper> {
    public Object literalObject();

    public int registryId();

    public Key ownerId();

    public <T> T getProperty(String var1);

    public boolean hasProperty(String var1);

    public BlockStateWrapper withProperty(String var1, String var2);

    public String getAsString();

    @Override
    default public int compareTo(@NotNull BlockStateWrapper o) {
        return Integer.compare(this.registryId(), o.registryId());
    }

    default public BlockStateWrapper withProperties(CompoundTag properties) {
        BlockStateWrapper result = this;
        for (Map.Entry<String, Tag> entry : properties.entrySet()) {
            Tag value = entry.getValue();
            if (value instanceof StringTag) {
                StringTag stringTag = (StringTag)value;
                result = result.withProperty(entry.getKey(), stringTag.getAsString());
                continue;
            }
            if (value instanceof IntTag) {
                IntTag intTag = (IntTag)value;
                result = result.withProperty(entry.getKey(), String.valueOf(intTag.getAsInt()));
                continue;
            }
            if (!(value instanceof ByteTag)) continue;
            ByteTag byteTag = (ByteTag)value;
            result = result.withProperty(entry.getKey(), String.valueOf(byteTag.booleanValue()));
        }
        return result;
    }
}

