/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.EmptyBlock;
import net.momirealms.craftengine.core.block.behavior.EntityBlockBehavior;
import net.momirealms.craftengine.core.block.entity.BlockEntity;
import net.momirealms.craftengine.core.block.entity.BlockEntityType;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElement;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfig;
import net.momirealms.craftengine.core.block.entity.tick.BlockEntityTicker;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableBlockState {
    private final Holder.Reference<CustomBlock> owner;
    private final Reference2ObjectArrayMap<Property<?>, Comparable<?>> propertyMap;
    private Map<Property<?>, ImmutableBlockState[]> withMap;
    private CompoundTag tag;
    private BlockStateWrapper customBlockState;
    private BlockStateWrapper vanillaBlockState;
    private BlockBehavior behavior;
    private BlockSettings settings;
    private BlockEntityType<? extends BlockEntity> blockEntityType;
    @Nullable
    private BlockEntityElementConfig<? extends BlockEntityElement>[] renderers;

    ImmutableBlockState(Holder.Reference<CustomBlock> owner, Reference2ObjectArrayMap<Property<?>, Comparable<?>> propertyMap) {
        this.owner = owner;
        this.propertyMap = new Reference2ObjectArrayMap(propertyMap);
    }

    public BlockBehavior behavior() {
        return this.behavior;
    }

    public void setBehavior(BlockBehavior behavior) {
        this.behavior = behavior;
    }

    public BlockSettings settings() {
        return this.settings;
    }

    public void setSettings(BlockSettings settings) {
        this.settings = settings;
    }

    public BlockEntityType<? extends BlockEntity> blockEntityType() {
        return this.blockEntityType;
    }

    public void setBlockEntityType(BlockEntityType<? extends BlockEntity> blockEntityType) {
        this.blockEntityType = blockEntityType;
    }

    public boolean isEmpty() {
        return this == EmptyBlock.STATE;
    }

    public BlockEntityElementConfig<? extends BlockEntityElement>[] constantRenderers() {
        return this.renderers;
    }

    public void setConstantRenderers(BlockEntityElementConfig<? extends BlockEntityElement>[] renderers) {
        this.renderers = renderers;
    }

    public boolean hasBlockEntity() {
        return this.blockEntityType != null;
    }

    public boolean hasConstantBlockEntityRenderer() {
        return this.renderers != null;
    }

    public BlockStateWrapper customBlockState() {
        return this.customBlockState;
    }

    public BlockStateWrapper vanillaBlockState() {
        return this.vanillaBlockState;
    }

    public void setCustomBlockState(@NotNull BlockStateWrapper customBlockState) {
        this.customBlockState = customBlockState;
    }

    public void setVanillaBlockState(@NotNull BlockStateWrapper vanillaBlockState) {
        this.vanillaBlockState = vanillaBlockState;
    }

    public CompoundTag getNbtToSave() {
        if (this.tag == null) {
            this.tag = this.toNbtToSave(this.propertiesNbt());
        }
        return this.tag;
    }

    public CompoundTag toNbtToSave(CompoundTag properties) {
        CompoundTag tag = new CompoundTag();
        tag.put("properties", properties);
        tag.put("id", NBT.createString(this.owner.key().location().asString()));
        return tag;
    }

    public void setNbtToSave(CompoundTag tag) {
        this.tag = tag;
    }

    public List<Item<Object>> getDrops(@NotNull ContextHolder.Builder builder, @NotNull World world, @Nullable Player player) {
        CustomBlock block = this.owner.value();
        if (block == null) {
            return List.of();
        }
        LootTable<?> lootTable = block.lootTable();
        if (lootTable == null) {
            return List.of();
        }
        return lootTable.getRandomItems(builder.withParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, this).build(), world, player);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> createSyncBlockEntityTicker(CEWorld world, BlockEntityType<? extends BlockEntity> type) {
        EntityBlockBehavior blockBehavior = this.behavior.getEntityBehavior();
        if (blockBehavior == null) {
            return null;
        }
        return blockBehavior.createSyncBlockEntityTicker(world, this, type);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> createAsyncBlockEntityTicker(CEWorld world, BlockEntityType<? extends BlockEntity> type) {
        EntityBlockBehavior blockBehavior = this.behavior.getEntityBehavior();
        if (blockBehavior == null) {
            return null;
        }
        return blockBehavior.createAsyncBlockEntityTicker(world, this, type);
    }

    public Holder<CustomBlock> owner() {
        return this.owner;
    }

    public <T extends Comparable<T>> ImmutableBlockState cycle(Property<T> property) {
        T currentValue = this.get(property);
        List<T> values = property.possibleValues();
        return this.with(property, (Comparable)ImmutableBlockState.getNextValue(values, currentValue));
    }

    private static <T> T getNextValue(List<T> values, T currentValue) {
        int index = values.indexOf(currentValue);
        if (index == -1) {
            throw new IllegalArgumentException("Current value not found in possible values");
        }
        return values.get((index + 1) % values.size());
    }

    public String toString() {
        if (this.propertyMap.isEmpty()) {
            return this.owner.key().location().toString();
        }
        return String.valueOf(this.owner.key().location()) + "[" + this.getPropertiesAsString() + "]";
    }

    public String getPropertiesAsString() {
        return this.propertyMap.entrySet().stream().map(entry -> {
            Property property = (Property)entry.getKey();
            return property.name() + "=" + Property.formatValue(property, (Comparable)entry.getValue());
        }).collect(Collectors.joining(","));
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableSet(this.propertyMap.keySet());
    }

    public <T extends Comparable<T>> boolean contains(Property<T> property) {
        return this.propertyMap.containsKey(property);
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        T value = this.getNullable(property);
        if (value == null) {
            throw new IllegalArgumentException("Property " + String.valueOf(property) + " not found in " + String.valueOf(this.owner.value().id()));
        }
        return value;
    }

    public <T extends Comparable<T>> T get(Property<T> property, T fallback) {
        return (T)((Comparable)Objects.requireNonNullElse(this.getNullable(property), fallback));
    }

    @Nullable
    public <T extends Comparable<T>> T getNullable(Property<T> property) {
        Comparable value = (Comparable)this.propertyMap.get(property);
        return (T)(value != null ? (Comparable)property.valueClass().cast(value) : null);
    }

    public CompoundTag propertiesNbt() {
        CompoundTag properties = new CompoundTag();
        for (Map.Entry entry : this.propertyMap.entrySet()) {
            Property property = (Property)entry.getKey();
            properties.put(property.name(), ImmutableBlockState.pack(property, entry.getValue()));
        }
        return properties;
    }

    private static <T extends Comparable<T>> Tag pack(Property<T> property, Object value) {
        return property.pack((Comparable)value);
    }

    public static <T extends Comparable<T>> ImmutableBlockState with(ImmutableBlockState state, Property<T> property, Object value) {
        return state.with(property, (Comparable)value);
    }

    public ImmutableBlockState with(CompoundTag propertiesNBT) {
        CustomBlock owner = this.owner.value();
        ImmutableBlockState finalState = this;
        for (Map.Entry<String, Tag> entry : propertiesNBT.entrySet()) {
            Property<?> property = owner.getProperty(entry.getKey());
            if (property == null) continue;
            finalState = ImmutableBlockState.with(finalState, property, property.unpack(entry.getValue()));
        }
        return finalState;
    }

    public <T extends Comparable<T>, V extends T> ImmutableBlockState with(Property<T> property, V value) {
        if (!this.propertyMap.containsKey(property)) {
            throw new IllegalArgumentException("Property " + String.valueOf(property) + " not found in " + String.valueOf(this.owner.value().id()));
        }
        return this.withInternal(property, value);
    }

    private <T extends Comparable<T>, V extends T> ImmutableBlockState withInternal(Property<T> property, V newValue) {
        if (newValue.equals(this.propertyMap.get(property))) {
            return this;
        }
        int index = property.indexOf(newValue);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid value " + String.valueOf(newValue) + " for property " + String.valueOf(property));
        }
        return this.withMap.get(property)[index];
    }

    public void createWithMap(Map<Map<Property<?>, Comparable<?>>, ImmutableBlockState> states) {
        if (this.withMap != null) {
            throw new IllegalStateException("WithMap already initialized");
        }
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(this.propertyMap.size());
        for (Property property : this.propertyMap.keySet()) {
            ImmutableBlockState[] statesArray = (ImmutableBlockState[])property.possibleValues().stream().map(value -> {
                Reference2ObjectArrayMap testMap = new Reference2ObjectArrayMap(this.propertyMap);
                testMap.put(property, value);
                ImmutableBlockState state = (ImmutableBlockState)states.get(testMap);
                if (state == null) {
                    throw new IllegalStateException("Missing state for " + String.valueOf(testMap));
                }
                return state;
            }).toArray(ImmutableBlockState[]::new);
            map.put((Object)property, (Object)statesArray);
        }
        this.withMap = Map.copyOf(map);
    }

    public Map<Property<?>, Comparable<?>> propertyEntries() {
        return Collections.unmodifiableMap(this.propertyMap);
    }
}

