/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.block.AbstractCustomBlock;
import net.momirealms.craftengine.core.block.BlockStateVariantProvider;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.EmptyBlockBehavior;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;

public final class InactiveCustomBlock
extends AbstractCustomBlock {
    private final Map<CompoundTag, ImmutableBlockState> cachedData = new HashMap<CompoundTag, ImmutableBlockState>();

    public InactiveCustomBlock(Holder.Reference<CustomBlock> holder) {
        super(holder, new BlockStateVariantProvider(holder, ImmutableBlockState::new, Map.of()), Map.of(), null);
    }

    @Override
    public ImmutableBlockState getBlockState(CompoundTag nbt) {
        return this.cachedData.computeIfAbsent(nbt, k -> {
            ImmutableBlockState state = new ImmutableBlockState(this.holder, new Reference2ObjectArrayMap());
            state.setBehavior(EmptyBlockBehavior.INSTANCE);
            state.setNbtToSave(state.toNbtToSave(nbt));
            return state;
        });
    }
}

