/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnsafeBlockStateMatcher {
    private final List<Pair<String, String>> matchers;
    private final Key id;

    public UnsafeBlockStateMatcher(Key id, List<Pair<String, String>> matchers) {
        this.id = id;
        this.matchers = matchers;
    }

    public boolean matches(ImmutableBlockState state) {
        if (!state.owner().value().id().equals(this.id)) {
            return false;
        }
        CustomBlock customBlock = state.owner().value();
        for (Pair<String, String> matcher : this.matchers) {
            Property<?> property = customBlock.getProperty(matcher.left());
            if (property == null) {
                return false;
            }
            Object value = state.get(property);
            String valueStr = Property.formatValue(property, value);
            if (matcher.right().equals(valueStr)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.matchers.isEmpty()) {
            return this.id.toString();
        }
        return String.valueOf(this.id) + "[" + this.matchers.stream().map(entry -> (String)entry.left() + "=" + (String)entry.right()).collect(Collectors.joining(",")) + "]";
    }

    @Nullable
    public static UnsafeBlockStateMatcher deserialize(@NotNull String data) {
        Optional<Holder.Reference<CustomBlock>> optional;
        StringReader reader = StringReader.simple(data);
        Object blockIdString = reader.readUnquotedString();
        if (reader.canRead() && reader.peek() == ':') {
            reader.skip();
            blockIdString = (String)blockIdString + ":" + reader.readUnquotedString();
        }
        if ((optional = BuiltInRegistries.BLOCK.get(Key.from((String)blockIdString))).isEmpty()) {
            return null;
        }
        Holder holder = optional.get();
        ArrayList<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead()) {
                reader.skipWhitespace();
                if (reader.peek() == ']') break;
                String propertyName = reader.readUnquotedString();
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != '=') {
                    return null;
                }
                reader.skip();
                reader.skipWhitespace();
                String propertyValue = reader.readUnquotedString();
                properties.add(new Pair<String, String>(propertyName, propertyValue));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') continue;
                reader.skip();
            }
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() == ']') {
                reader.skip();
            } else {
                return null;
            }
        }
        return new UnsafeBlockStateMatcher(((CustomBlock)holder.value()).id(), properties);
    }
}

