/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.parser;

import java.util.function.Function;
import net.momirealms.craftengine.core.block.BlockStateVariantProvider;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.util.StringReader;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockNbtParser {
    private BlockNbtParser() {
    }

    @Nullable
    public static CompoundTag deserialize(@NotNull Function<String, Property<?>> propertyProvider, @NotNull String data) {
        StringReader reader = StringReader.simple(data);
        CompoundTag properties = new CompoundTag();
        while (reader.canRead()) {
            String propertyName = reader.readUnquotedString();
            if (propertyName.isEmpty() || !reader.canRead() || reader.peek() != '=') {
                return null;
            }
            reader.skip();
            String propertyValue = reader.readUnquotedString();
            if (propertyValue.isEmpty()) {
                return null;
            }
            Property<?> property = propertyProvider.apply(propertyName);
            if (property != null) {
                property.createOptionalTag(propertyValue).ifPresent(tag -> properties.put(propertyName, (Tag)tag));
            }
            if (!reader.canRead() || reader.peek() != ',') break;
            reader.skip();
        }
        return properties;
    }

    @Nullable
    public static CompoundTag deserialize(@NotNull CustomBlock block, @NotNull String data) {
        return BlockNbtParser.deserialize(block::getProperty, data);
    }

    @Nullable
    public static CompoundTag deserialize(@NotNull BlockStateVariantProvider variantProvider, @NotNull String data) {
        return BlockNbtParser.deserialize(variantProvider::getProperty, data);
    }
}

