/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.properties;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.properties.PropertyFactory;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class BooleanProperty
extends Property<Boolean> {
    public static final Factory FACTORY = new Factory();
    private static final List<Boolean> VALUES = List.of(Boolean.valueOf(true), Boolean.valueOf(false));
    private static final Boolean[] BY_ID = new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    private static final ByteTag TRUE = new ByteTag(1);
    private static final ByteTag FALSE = new ByteTag(0);

    private BooleanProperty(String name, boolean defaultValue) {
        super(name, Boolean.class, defaultValue);
        this.setById(BY_ID);
    }

    @Override
    public List<Boolean> possibleValues() {
        return VALUES;
    }

    @Override
    public Optional<Boolean> optional(String valueName) {
        return switch (valueName) {
            case "true" -> Optional.of(true);
            case "false" -> Optional.of(false);
            default -> Optional.empty();
        };
    }

    @Override
    public Optional<Tag> createOptionalTag(String valueName) {
        return this.optional(valueName).map(ByteTag::new);
    }

    @Override
    public Tag pack(Boolean value) {
        return value != false ? TRUE : FALSE;
    }

    @Override
    public final int idFor(Boolean value) {
        return value != false ? 1 : 0;
    }

    @Override
    public String valueName(Boolean bool) {
        return bool.toString();
    }

    @Override
    public Boolean valueByName(String name) {
        if (name.equals("true")) {
            return true;
        }
        if (name.equals("false")) {
            return false;
        }
        return null;
    }

    @Override
    public int indexOf(Boolean bool) {
        return bool != false ? 0 : 1;
    }

    @Override
    public Boolean unpack(Tag tag) {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.booleanValue();
        }
        throw new IllegalArgumentException("Invalid boolean tag: " + String.valueOf(tag));
    }

    public static BooleanProperty create(String name, boolean defaultValue) {
        return new BooleanProperty(name, defaultValue);
    }

    public static class Factory
    implements PropertyFactory {
        @Override
        public Property<?> create(String name, Map<String, Object> arguments) {
            boolean bool = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("default", false), "default");
            return BooleanProperty.create(name, bool);
        }
    }
}

