/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.properties;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.properties.PropertyFactory;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class StringProperty
extends Property<String> {
    public static final Factory FACTORY = new Factory();
    private final List<String> values;
    private final ImmutableMap<String, String> names;

    public StringProperty(String name, List<String> values, String defaultValue) {
        super(name, String.class, defaultValue);
        this.values = List.copyOf(values);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String value : values) {
            builder.put((Object)value, (Object)value);
        }
        this.names = builder.build();
        this.setById((Comparable[])values.toArray(new String[0]));
    }

    @Override
    public List<String> possibleValues() {
        return this.values;
    }

    @Override
    public Optional<String> optional(String valueName) {
        return Optional.ofNullable((String)this.names.get((Object)valueName));
    }

    @Override
    public Optional<Tag> createOptionalTag(String valueName) {
        return this.optional(valueName).map(StringTag::new);
    }

    @Override
    public Tag pack(String value) {
        return new StringTag(this.valueName(value));
    }

    @Override
    public String unpack(Tag tag) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return (String)this.names.get((Object)stringTag.getAsString());
        }
        throw new IllegalArgumentException("Invalid string tag: " + String.valueOf(tag));
    }

    @Override
    public final int idFor(String value) {
        int index = this.indexOf(value);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid value: " + value);
        }
        return index;
    }

    @Override
    public String valueName(String value) {
        return value;
    }

    @Override
    public String valueByName(String name) {
        return (String)this.names.get((Object)name);
    }

    @Override
    public int indexOf(String value) {
        return this.values.indexOf(value);
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        return 31 * i + this.values.hashCode();
    }

    public static StringProperty create(String name, List<String> values, String defaultValue) {
        return new StringProperty(name, values, defaultValue);
    }

    public static class Factory
    implements PropertyFactory {
        @Override
        public Property<?> create(String name, Map<String, Object> arguments) {
            List<String> values = MiscUtils.getAsStringList(arguments.get("values")).stream().toList();
            String defaultValueName = arguments.getOrDefault("default", "").toString();
            String defaultValue = values.stream().filter(e -> e.equals(defaultValueName)).findFirst().orElseGet(values::getFirst);
            return StringProperty.create(name, values, defaultValue);
        }
    }
}

