/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.player;

import net.momirealms.craftengine.core.advancement.AdvancementType;
import net.momirealms.craftengine.core.entity.AbstractEntity;
import net.momirealms.craftengine.core.entity.player.GameMode;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.context.CooldownData;
import net.momirealms.craftengine.core.plugin.network.NetWorkUser;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.Position;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.WorldPosition;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public abstract class Player
extends AbstractEntity
implements NetWorkUser {
    private static final Key TYPE = Key.of("minecraft:player");

    public abstract boolean isSecondaryUseActive();

    @NotNull
    public abstract Item<?> getItemInHand(InteractionHand var1);

    @Override
    public abstract Object platformPlayer();

    @Override
    public abstract Object serverPlayer();

    public abstract float getDestroyProgress(Object var1, BlockPos var2);

    public abstract void setClientSideCanBreakBlock(boolean var1);

    public abstract void stopMiningBlock();

    public abstract void preventMiningBlock();

    public abstract void abortMiningBlock();

    public abstract void breakBlock(int var1, int var2, int var3);

    public abstract double getCachedInteractionRange();

    public abstract void onSwingHand();

    public abstract boolean isMiningBlock();

    public abstract boolean shouldSyncAttribute();

    public abstract boolean isSneaking();

    public abstract boolean isSwimming();

    public abstract boolean isClimbing();

    public abstract boolean isGliding();

    public abstract boolean isFlying();

    public abstract GameMode gameMode();

    public abstract void setGameMode(GameMode var1);

    public abstract boolean canBreak(BlockPos var1, Object var2);

    public abstract boolean canPlace(BlockPos var1, Object var2);

    public abstract void sendToast(Component var1, Item<?> var2, AdvancementType var3);

    public abstract void sendActionBar(Component var1);

    public abstract void sendMessage(Component var1, boolean var2);

    public abstract void sendTitle(Component var1, Component var2, int var3, int var4, int var5);

    public abstract boolean updateLastSuccessfulInteractionTick(int var1);

    public abstract int lastSuccessfulInteractionTick();

    public abstract void updateLastInteractEntityTick(@NotNull InteractionHand var1);

    public abstract boolean lastInteractEntityCheck(@NotNull InteractionHand var1);

    public abstract int gameTicks();

    public abstract void swingHand(InteractionHand var1);

    public abstract boolean hasPermission(String var1);

    public abstract boolean canInstabuild();

    @Override
    public abstract String name();

    public void playSound(Key sound) {
        this.playSound(sound, 1.0f, 1.0f);
    }

    public void playSound(Key sound, float volume, float pitch) {
        this.playSound(sound, SoundSource.MASTER, volume, pitch);
    }

    public abstract void playSound(Key var1, SoundSource var2, float var3, float var4);

    public abstract void playSound(Position var1, Key var2, SoundSource var3, float var4, float var5);

    public void playSound(BlockPos pos, Key sound, SoundSource source, float volume, float pitch) {
        this.playSound(Vec3d.atCenterOf(pos), sound, source, volume, pitch);
    }

    public void playSound(BlockPos pos, SoundData data, SoundSource source) {
        this.playSound(pos, data.id(), source, ((Float)data.volume().get()).floatValue(), ((Float)data.pitch().get()).floatValue());
    }

    public void playSound(Position pos, SoundData data, SoundSource source) {
        this.playSound(pos, data.id(), source, ((Float)data.volume().get()).floatValue(), ((Float)data.pitch().get()).floatValue());
    }

    public abstract void giveItem(Item<?> var1);

    public abstract void closeInventory();

    public abstract void clearView();

    public abstract void unloadCurrentResourcePack();

    public abstract void performCommand(String var1, boolean var2);

    public abstract void performCommandAsEvent(String var1);

    public abstract double luck();

    @Override
    public Key type() {
        return TYPE;
    }

    public boolean isCreativeMode() {
        return this.gameMode() == GameMode.CREATIVE;
    }

    public boolean isSpectatorMode() {
        return this.gameMode() == GameMode.SPECTATOR;
    }

    public boolean isSurvivalMode() {
        return this.gameMode() == GameMode.SURVIVAL;
    }

    public boolean isAdventureMode() {
        return this.gameMode() == GameMode.ADVENTURE;
    }

    public abstract int foodLevel();

    public abstract void setFoodLevel(int var1);

    public abstract float saturation();

    public abstract void setSaturation(float var1);

    public abstract void addPotionEffect(Key var1, int var2, int var3, boolean var4, boolean var5);

    public abstract void removePotionEffect(Key var1);

    public abstract void clearPotionEffects();

    public abstract CooldownData cooldown();

    public abstract void teleport(WorldPosition var1);

    public abstract void damage(double var1, Key var3);
}

