/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.font;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.font.Emoji;
import net.momirealms.craftengine.core.font.EmojiComponentProcessResult;
import net.momirealms.craftengine.core.font.EmojiParameters;
import net.momirealms.craftengine.core.font.EmojiTextProcessResult;
import net.momirealms.craftengine.core.font.Font;
import net.momirealms.craftengine.core.font.FontManager;
import net.momirealms.craftengine.core.font.FontTagFormatter;
import net.momirealms.craftengine.core.font.IllegalCharacterProcessResult;
import net.momirealms.craftengine.core.font.OffsetFont;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.allocator.IdAllocator;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.IdSectionConfigParser;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.text.component.ComponentProvider;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.CompletableFutures;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.ahocorasick.trie.Token;
import net.momirealms.craftengine.libraries.ahocorasick.trie.Trie;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFontManager
implements FontManager {
    private final CraftEngine plugin;
    private final Map<Key, Font> fonts = new HashMap<Key, Font>();
    private final Map<Key, Emoji> emojis = new HashMap<Key, Emoji>();
    private final Map<Key, BitmapImage> images = new HashMap<Key, BitmapImage>();
    private final Set<Integer> illegalChars = new HashSet<Integer>();
    private final ImageParser imageParser;
    private final EmojiParser emojiParser;
    private OffsetFont offsetFont;
    protected Trie networkTagTrie;
    protected Trie emojiKeywordTrie;
    protected Map<String, ComponentProvider> networkTagMapper;
    protected Map<String, Emoji> emojiMapper;
    protected List<Emoji> emojiList;
    protected List<String> allEmojiSuggestions;

    public AbstractFontManager(CraftEngine plugin) {
        this.plugin = plugin;
        this.imageParser = new ImageParser();
        this.emojiParser = new EmojiParser();
    }

    public ImageParser imageParser() {
        return this.imageParser;
    }

    public EmojiParser emojiParser() {
        return this.emojiParser;
    }

    @Override
    public void load() {
        this.offsetFont = Optional.ofNullable(this.plugin.config().settings().getSection("image.offset-characters")).map(OffsetFont::new).orElse(null);
        this.networkTagMapper = new HashMap<String, ComponentProvider>(1024);
    }

    @Override
    public OffsetFont offsetFont() {
        return this.offsetFont;
    }

    @Override
    public Map<Key, BitmapImage> loadedImages() {
        return Collections.unmodifiableMap(this.images);
    }

    @Override
    public Map<Key, Emoji> emojis() {
        return Collections.unmodifiableMap(this.emojis);
    }

    @Override
    public void unload() {
        this.fonts.clear();
        this.images.clear();
        this.illegalChars.clear();
        this.emojis.clear();
        this.networkTagTrie = null;
        this.emojiKeywordTrie = null;
        if (this.networkTagMapper != null) {
            this.networkTagMapper.clear();
        }
        if (this.emojiMapper != null) {
            this.emojiMapper.clear();
        }
    }

    @Override
    public void disable() {
        this.unload();
    }

    @Override
    public ConfigParser[] parsers() {
        return new ConfigParser[]{this.imageParser, this.emojiParser};
    }

    @Override
    public void delayedLoad() {
        Optional.ofNullable(this.fonts.get(DEFAULT_FONT)).ifPresent(font -> this.illegalChars.addAll(font.codepointsInUse()));
        this.registerImageTags();
        this.registerShiftTags();
        this.registerGlobalTags();
        this.buildNetworkTagTrie();
        this.buildEmojiKeywordsTrie();
        this.emojiList = new ArrayList<Emoji>(this.emojis.values());
        this.allEmojiSuggestions = this.emojis.values().stream().flatMap(emoji -> emoji.keywords().stream()).collect(Collectors.toList());
    }

    private void registerGlobalTags() {
        for (Map.Entry<String, String> entry : this.plugin.globalVariableManager().globalVariables().entrySet()) {
            String globalTag = AbstractFontManager.globalTag(entry.getKey());
            this.networkTagMapper.put(globalTag, ComponentProvider.miniMessageOrConstant(entry.getValue()));
            this.networkTagMapper.put("\\" + globalTag, ComponentProvider.constant((Component)Component.text((String)entry.getValue())));
        }
    }

    private void registerShiftTags() {
        for (int i = -256; i <= 256; ++i) {
            String shiftTag = "<shift:" + i + ">";
            this.networkTagMapper.put(shiftTag, ComponentProvider.constant(this.offsetFont.createOffset(i)));
            this.networkTagMapper.put("\\" + shiftTag, ComponentProvider.constant((Component)Component.text((String)shiftTag)));
        }
    }

    private void registerImageTags() {
        for (BitmapImage image : this.images.values()) {
            String id = image.id().toString();
            String simpleImageTag = AbstractFontManager.imageTag(id);
            this.networkTagMapper.put(simpleImageTag, ComponentProvider.constant(image.componentAt(0, 0)));
            this.networkTagMapper.put("\\" + simpleImageTag, ComponentProvider.constant((Component)Component.text((String)simpleImageTag)));
            for (int i = 0; i < image.rows(); ++i) {
                for (int j = 0; j < image.columns(); ++j) {
                    String imageArgs = id + ":" + i + ":" + j;
                    String imageTag = AbstractFontManager.imageTag(imageArgs);
                    this.networkTagMapper.put(imageTag, ComponentProvider.constant(image.componentAt(i, j)));
                    this.networkTagMapper.put("\\" + imageTag, ComponentProvider.constant((Component)Component.text((String)imageTag)));
                }
            }
        }
    }

    @Override
    public Map<String, ComponentProvider> matchTags(String json) {
        if (this.networkTagTrie == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ComponentProvider> tags = new HashMap<String, ComponentProvider>();
        for (Token token : this.networkTagTrie.tokenize(json)) {
            if (!token.isMatch()) continue;
            tags.put(token.getFragment(), this.networkTagMapper.get(token.getFragment()));
        }
        return tags;
    }

    @Override
    public EmojiTextProcessResult replaceMiniMessageEmoji(@NotNull String miniMessage, Player player, int maxTimes) {
        if (this.emojiKeywordTrie == null || maxTimes <= 0) {
            return EmojiTextProcessResult.notReplaced(miniMessage);
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Token token : this.emojiKeywordTrie.tokenize(miniMessage)) {
            Emoji emoji;
            String fragment;
            if (!token.isMatch() || replacements.containsKey(fragment = token.getFragment()) || (emoji = this.emojiMapper.get(fragment)) == null || player != null && emoji.permission() != null && !player.hasPermission(emoji.permission())) continue;
            Component content = AdventureHelper.miniMessage().deserialize(emoji.content(), PlayerOptionalContext.of(player, ContextHolder.builder().withOptionalParameter(EmojiParameters.EMOJI, emoji.emojiImage()).withParameter(EmojiParameters.KEYWORD, emoji.keywords().get(0))).tagResolvers());
            replacements.put(fragment, AdventureHelper.componentToMiniMessage(content));
        }
        if (replacements.isEmpty()) {
            return EmojiTextProcessResult.notReplaced(miniMessage);
        }
        String regex = replacements.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(miniMessage);
        StringBuilder sb = new StringBuilder();
        int count = 0;
        while (matcher.find() && count < maxTimes) {
            String key = matcher.group();
            String replacement = (String)replacements.get(key);
            if (replacement != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
                ++count;
                continue;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group()));
        }
        matcher.appendTail(sb);
        return EmojiTextProcessResult.replaced(sb.toString());
    }

    @Override
    public EmojiTextProcessResult replaceJsonEmoji(@NotNull String jsonText, Player player, int maxTimes) {
        if (this.emojiKeywordTrie == null) {
            return EmojiTextProcessResult.notReplaced(jsonText);
        }
        HashMap<String, Component> emojis = new HashMap<String, Component>();
        for (Token token : this.emojiKeywordTrie.tokenize(jsonText)) {
            Emoji emoji;
            String fragment;
            if (!token.isMatch() || emojis.containsKey(fragment = token.getFragment()) || (emoji = this.emojiMapper.get(fragment)) == null || player != null && emoji.permission() != null && !player.hasPermission(emoji.permission())) continue;
            emojis.put(fragment, AdventureHelper.miniMessage().deserialize(emoji.content(), PlayerOptionalContext.of(player, ContextHolder.builder().withOptionalParameter(EmojiParameters.EMOJI, emoji.emojiImage()).withParameter(EmojiParameters.KEYWORD, emoji.keywords().getFirst())).tagResolvers()));
            if (emojis.size() < maxTimes) continue;
            break;
        }
        if (emojis.isEmpty()) {
            return EmojiTextProcessResult.notReplaced(jsonText);
        }
        Component component = AdventureHelper.jsonToComponent(jsonText);
        String patternString = emojis.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        component = component.replaceText(builder -> builder.times(maxTimes).match(Pattern.compile(patternString)).replacement((result, b) -> (ComponentLike)emojis.get(result.group())));
        return EmojiTextProcessResult.replaced(AdventureHelper.componentToJson(component));
    }

    @Override
    public EmojiComponentProcessResult replaceComponentEmoji(@NotNull Component text, Player player, @NotNull String raw, int maxTimes) {
        HashMap<String, Component> emojis = new HashMap<String, Component>();
        for (Token token : this.emojiKeywordTrie.tokenize(raw)) {
            Emoji emoji;
            String fragment;
            if (!token.isMatch() || emojis.containsKey(fragment = token.getFragment()) || (emoji = this.emojiMapper.get(token.getFragment())) == null || player != null && emoji.permission() != null && !player.hasPermission(Objects.requireNonNull(emoji.permission()))) continue;
            emojis.put(fragment, AdventureHelper.miniMessage().deserialize(emoji.content(), PlayerOptionalContext.of(player, ContextHolder.builder().withOptionalParameter(EmojiParameters.EMOJI, emoji.emojiImage()).withParameter(EmojiParameters.KEYWORD, emoji.keywords().get(0))).tagResolvers()));
            if (emojis.size() < maxTimes) continue;
            break;
        }
        if (emojis.isEmpty()) {
            return EmojiComponentProcessResult.failed();
        }
        String patternString = emojis.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        text = text.replaceText(builder -> builder.times(maxTimes).match(Pattern.compile(patternString)).replacement((result, b) -> (ComponentLike)emojis.get(result.group())));
        return EmojiComponentProcessResult.success(text);
    }

    @Override
    public IllegalCharacterProcessResult processIllegalCharacters(String raw, char replacement) {
        boolean hasIllegal = false;
        Map<String, ComponentProvider> tokens = this.matchTags(raw);
        if (!tokens.isEmpty()) {
            for (Map.Entry<String, ComponentProvider> entry : tokens.entrySet()) {
                raw = raw.replace(entry.getKey(), String.valueOf(replacement));
                hasIllegal = true;
            }
        }
        if (this.isDefaultFontInUse()) {
            char[] chars = raw.toCharArray();
            int[] codepoints = CharacterUtils.charsToCodePoints(chars);
            int[] newCodepoints = new int[codepoints.length];
            for (int i = 0; i < codepoints.length; ++i) {
                int codepoint = codepoints[i];
                if (!this.isIllegalCodepoint(codepoint)) {
                    newCodepoints[i] = codepoint;
                    continue;
                }
                newCodepoints[i] = replacement;
                hasIllegal = true;
            }
            if (hasIllegal) {
                return IllegalCharacterProcessResult.has(new String(newCodepoints, 0, newCodepoints.length));
            }
        } else if (hasIllegal) {
            return IllegalCharacterProcessResult.has(raw);
        }
        return IllegalCharacterProcessResult.not();
    }

    private void buildEmojiKeywordsTrie() {
        this.emojiMapper = new HashMap<String, Emoji>();
        for (Emoji emoji : this.emojis.values()) {
            for (String keyword : emoji.keywords()) {
                this.emojiMapper.put(keyword, emoji);
            }
        }
        this.emojiKeywordTrie = Trie.builder().ignoreOverlaps().addKeywords(this.emojiMapper.keySet()).build();
    }

    private void buildNetworkTagTrie() {
        this.networkTagTrie = Trie.builder().ignoreOverlaps().addKeywords(this.networkTagMapper.keySet()).build();
    }

    private static String imageTag(String text) {
        return "<image:" + text + ">";
    }

    private static String globalTag(String text) {
        return "<global:" + text + ">";
    }

    @Override
    public boolean isDefaultFontInUse() {
        return !this.illegalChars.isEmpty();
    }

    @Override
    public boolean isIllegalCodepoint(int codepoint) {
        return this.illegalChars.contains(codepoint);
    }

    @Override
    public Collection<Font> fonts() {
        return Collections.unmodifiableCollection(this.fonts.values());
    }

    @Override
    public Optional<BitmapImage> bitmapImageByCodepoint(Key font, int codepoint) {
        return this.fontById(font).map(f -> f.bitmapImageByCodepoint(codepoint));
    }

    @Override
    public Optional<BitmapImage> bitmapImageByImageId(Key id) {
        return Optional.ofNullable(this.images.get(id));
    }

    @Override
    public int codepointByImageId(Key key, int x, int y) {
        BitmapImage image = this.images.get(key);
        if (image == null) {
            return -1;
        }
        return image.codepointAt(x, y);
    }

    @Override
    public String createOffsets(int offset, FontTagFormatter tagFormatter) {
        return Optional.ofNullable(this.offsetFont).map(it -> it.createOffset(offset, tagFormatter)).orElse("");
    }

    @Override
    public Optional<Font> fontById(Key id) {
        return Optional.ofNullable(this.fonts.get(id));
    }

    private Font getOrCreateFont(Key key) {
        return this.fonts.computeIfAbsent(key, Font::new);
    }

    public class ImageParser
    extends IdSectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"images", "image"};
        private final Map<Key, IdAllocator> idAllocators = new HashMap<Key, IdAllocator>();

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 80;
        }

        @Override
        public void postProcess() {
            for (Map.Entry<Key, IdAllocator> entry : this.idAllocators.entrySet()) {
                entry.getValue().processPendingAllocations();
                try {
                    entry.getValue().saveToCache();
                }
                catch (IOException e) {
                    AbstractFontManager.this.plugin.logger().warn("Error while saving codepoint allocation for font " + entry.getKey().asString(), e);
                }
            }
        }

        @Override
        public void preProcess() {
            this.idAllocators.clear();
        }

        public IdAllocator getOrCreateIdAllocator(Key key) {
            return this.idAllocators.computeIfAbsent(key, k -> {
                IdAllocator newAllocator = new IdAllocator(AbstractFontManager.this.plugin.dataFolderPath().resolve("cache").resolve("font").resolve(k.namespace()).resolve(k.value() + ".json"));
                newAllocator.reset(Config.codepointStartingValue(k), 0x10FFFF);
                try {
                    newAllocator.loadFromCache();
                }
                catch (IOException e) {
                    AbstractFontManager.this.plugin.logger().warn("Error while loading chars data from cache for font " + k.asString(), e);
                }
                return newAllocator;
            });
        }

        @Override
        public void parseSection(Pack pack, Path path, String node, Key id, Map<String, Object> section) {
            int columns;
            int rows;
            if (AbstractFontManager.this.images.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.image.duplicate", new String[0]);
            }
            Object file = section.get("file");
            if (file == null) {
                throw new LocalizedResourceConfigException("warning.config.image.missing_file", new String[0]);
            }
            String resourceLocation = MiscUtils.make(CharacterUtils.replaceBackslashWithSlash(file.toString()), s -> s.endsWith(".png") ? s : s + ".png");
            if (!ResourceLocation.isValid(resourceLocation)) {
                throw new LocalizedResourceConfigException("warning.config.image.invalid_file_chars", resourceLocation);
            }
            String fontName = section.getOrDefault("font", pack.namespace() + ":default").toString();
            if (!ResourceLocation.isValid(fontName)) {
                throw new LocalizedResourceConfigException("warning.config.image.invalid_font_chars", fontName);
            }
            Key fontId = Key.withDefaultNamespace(fontName, id.namespace());
            Font font = AbstractFontManager.this.getOrCreateFont(fontId);
            IdAllocator allocator = this.getOrCreateIdAllocator(fontId);
            ArrayList<CompletableFuture<Integer>> futureCodepoints = new ArrayList<CompletableFuture<Integer>>();
            Object charsObj = ResourceConfigUtils.get(section, "chars", "char");
            if (charsObj == null) {
                Object grid = section.get("grid-size");
                if (grid != null) {
                    String gridString = grid.toString();
                    String[] split = gridString.split(",");
                    if (split.length != 2) {
                        throw new LocalizedResourceConfigException("warning.config.image.invalid_grid_size", gridString);
                    }
                    rows = Integer.parseInt(split[0]);
                    int chars = rows * (columns = Integer.parseInt(split[1]));
                    if (chars <= 0) {
                        throw new LocalizedResourceConfigException("warning.config.image.invalid_grid_size", gridString);
                    }
                    for (int i = 0; i < rows; ++i) {
                        for (int j = 0; j < columns; ++j) {
                            futureCodepoints.add(allocator.requestAutoId(id.asString() + ":" + i + ":" + j));
                        }
                    }
                } else {
                    rows = 1;
                    columns = 1;
                    futureCodepoints.add(allocator.requestAutoId(id.asString()));
                }
            } else if (charsObj instanceof List) {
                List list = (List)charsObj;
                List<String> charsList = MiscUtils.getAsStringList(list);
                if (charsList.isEmpty() || charsList.getFirst().isEmpty()) {
                    throw new LocalizedResourceConfigException("warning.config.image.missing_char", new String[0]);
                }
                int tempColumns = -1;
                rows = charsList.size();
                for (int i = 0; i < charsList.size(); ++i) {
                    String charString = charsList.get(i);
                    int[] codepoints = charString.startsWith("\\u") ? CharacterUtils.charsToCodePoints(CharacterUtils.decodeUnicodeToChars(charString)) : CharacterUtils.charsToCodePoints(charString.toCharArray());
                    for (int j = 0; j < codepoints.length; ++j) {
                        if (codepoints[j] == 0) {
                            futureCodepoints.add(CompletableFuture.completedFuture(0));
                            continue;
                        }
                        futureCodepoints.add(allocator.assignFixedId(id.asString() + ":" + i + ":" + j, codepoints[j]));
                    }
                    if (tempColumns == -1) {
                        tempColumns = codepoints.length;
                        continue;
                    }
                    if (tempColumns == codepoints.length) continue;
                    throw new LocalizedResourceConfigException("warning.config.image.invalid_codepoint_grid", new String[0]);
                }
                columns = tempColumns;
            } else if (charsObj instanceof Integer) {
                Integer codepoint = (Integer)charsObj;
                futureCodepoints.add(allocator.assignFixedId(id.asString(), codepoint));
                rows = 1;
                columns = 1;
            } else {
                String character = charsObj.toString();
                if (character.isEmpty()) {
                    throw new LocalizedResourceConfigException("warning.config.image.missing_char", new String[0]);
                }
                rows = 1;
                int[] codepoints = character.startsWith("\\u") ? CharacterUtils.charsToCodePoints(CharacterUtils.decodeUnicodeToChars(character)) : CharacterUtils.charsToCodePoints(character.toCharArray());
                columns = codepoints.length;
                for (int i = 0; i < codepoints.length; ++i) {
                    if (codepoints[i] == 0) {
                        futureCodepoints.add(CompletableFuture.completedFuture(0));
                        continue;
                    }
                    futureCodepoints.add(allocator.assignFixedId(id.asString() + ":0:" + i, codepoints[i]));
                }
            }
            CompletableFutures.allOf(futureCodepoints).whenComplete((v, t) -> ResourceConfigUtils.runCatching(path, node, () -> {
                int ascent;
                int height;
                Object heightObj;
                int[][] codepointGrid;
                block21: {
                    if (t != null) {
                        if (t instanceof CompletionException) {
                            CompletionException e = (CompletionException)t;
                            Throwable cause = e.getCause();
                            if (cause instanceof IdAllocator.IdConflictException) {
                                IdAllocator.IdConflictException conflict = (IdAllocator.IdConflictException)cause;
                                throw new LocalizedResourceConfigException("warning.config.image.codepoint.conflict", fontId.toString(), CharacterUtils.encodeCharsToUnicode(Character.toChars(conflict.id())), new String(Character.toChars(conflict.id())), conflict.previousOwner());
                            }
                            if (cause instanceof IdAllocator.IdExhaustedException) {
                                throw new LocalizedResourceConfigException("warning.config.image.codepoint.exhausted", fontId.asString());
                            }
                        }
                        throw new RuntimeException("Unknown error occurred", (Throwable)t);
                    }
                    codepointGrid = new int[rows][columns];
                    for (int i = 0; i < rows; ++i) {
                        for (int j = 0; j < columns; ++j) {
                            try {
                                int codepoint;
                                codepointGrid[i][j] = codepoint = ((Integer)((CompletableFuture)futureCodepoints.get(i * columns + j)).get()).intValue();
                                continue;
                            }
                            catch (InterruptedException | ExecutionException e) {
                                AbstractFontManager.this.plugin.logger().warn("Interrupted while allocating codepoint for image " + id.asString(), e);
                                return;
                            }
                        }
                    }
                    heightObj = section.get("height");
                    if (heightObj == null) {
                        Key namespacedPath = Key.of(resourceLocation);
                        Path targetImagePath = pack.resourcePackFolder().resolve("assets").resolve(namespacedPath.namespace()).resolve("textures").resolve(namespacedPath.value());
                        if (Files.exists(targetImagePath, new LinkOption[0])) {
                            try (InputStream in = Files.newInputStream(targetImagePath, new OpenOption[0]);){
                                BufferedImage image = ImageIO.read(in);
                                heightObj = image.getHeight() / codepointGrid.length;
                                break block21;
                            }
                            catch (IOException e) {
                                AbstractFontManager.this.plugin.logger().warn("Failed to load image " + String.valueOf(targetImagePath), e);
                                return;
                            }
                        }
                        throw new LocalizedResourceConfigException("warning.config.image.missing_height", new String[0]);
                    }
                }
                if ((height = ResourceConfigUtils.getAsInt(heightObj, "height")) < (ascent = ResourceConfigUtils.getAsInt(section.getOrDefault("ascent", height - 1), "ascent"))) {
                    throw new LocalizedResourceConfigException("warning.config.image.height_ascent_conflict", String.valueOf(height), String.valueOf(ascent));
                }
                BitmapImage bitmapImage = new BitmapImage(id, fontId, height, ascent, resourceLocation, codepointGrid);
                int[][] nArray = codepointGrid;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] y;
                    for (int x : y = nArray[i]) {
                        font.addBitmapImage(x, bitmapImage);
                    }
                }
                AbstractFontManager.this.images.put(id, bitmapImage);
            }, () -> GsonHelper.get().toJson((Object)section)));
        }
    }

    public class EmojiParser
    extends IdSectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"emoji", "emojis"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 140;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void parseSection(Pack pack, Path path, String node, Key id, Map<String, Object> section) {
            String content;
            if (AbstractFontManager.this.emojis.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.emoji.duplicate", new String[0]);
            }
            String permission = (String)section.get("permission");
            Object keywordsRaw = section.get("keywords");
            if (keywordsRaw == null) {
                throw new LocalizedResourceConfigException("warning.config.emoji.missing_keywords", new String[0]);
            }
            List<String> keywords = MiscUtils.getAsStringList(keywordsRaw);
            if (keywords.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.emoji.missing_keywords", new String[0]);
            }
            Object rawContent = section.getOrDefault("content", "<white><arg:emoji></white>");
            if (rawContent instanceof List) {
                List list = (List)rawContent;
                content = list.stream().map(Object::toString).collect(Collectors.joining());
            } else {
                content = rawContent.toString();
            }
            String image = null;
            if (section.containsKey("image")) {
                String rawImage = section.get("image").toString();
                String[] split = rawImage.split(":");
                if (split.length == 2) {
                    Key imageId = new Key(split[0], split[1]);
                    Optional<BitmapImage> bitmapImage = AbstractFontManager.this.bitmapImageByImageId(imageId);
                    if (!bitmapImage.isPresent()) throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", rawImage);
                    image = bitmapImage.get().miniMessageAt(0, 0);
                } else {
                    if (split.length != 4) throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", rawImage);
                    Key imageId = new Key(split[0], split[1]);
                    Optional<BitmapImage> bitmapImage = AbstractFontManager.this.bitmapImageByImageId(imageId);
                    if (!bitmapImage.isPresent()) throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", rawImage);
                    try {
                        image = bitmapImage.get().miniMessageAt(Integer.parseInt(split[2]), Integer.parseInt(split[3]));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", rawImage);
                    }
                }
            }
            Emoji emoji = new Emoji(content, permission, image, keywords);
            AbstractFontManager.this.emojis.put(id, emoji);
        }
    }
}

