/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ExternalItemSource;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.ItemSettings;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviors;
import net.momirealms.craftengine.core.item.equipment.ComponentBasedEquipment;
import net.momirealms.craftengine.core.item.equipment.Equipment;
import net.momirealms.craftengine.core.item.equipment.EquipmentLayerType;
import net.momirealms.craftengine.core.item.equipment.Equipments;
import net.momirealms.craftengine.core.item.equipment.TrimBasedEquipment;
import net.momirealms.craftengine.core.item.modifier.CustomModelDataModifier;
import net.momirealms.craftengine.core.item.modifier.IdModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.item.modifier.ItemModelModifier;
import net.momirealms.craftengine.core.item.modifier.ItemVersionModifier;
import net.momirealms.craftengine.core.item.updater.ItemUpdateConfig;
import net.momirealms.craftengine.core.item.updater.ItemUpdateResult;
import net.momirealms.craftengine.core.item.updater.ItemUpdater;
import net.momirealms.craftengine.core.item.updater.ItemUpdaters;
import net.momirealms.craftengine.core.pack.AbstractPackManager;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.allocator.IdAllocator;
import net.momirealms.craftengine.core.pack.model.BaseItemModel;
import net.momirealms.craftengine.core.pack.model.ConditionItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.LegacyItemModel;
import net.momirealms.craftengine.core.pack.model.LegacyModelPredicate;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.ModernItemModel;
import net.momirealms.craftengine.core.pack.model.RangeDispatchItemModel;
import net.momirealms.craftengine.core.pack.model.SelectItemModel;
import net.momirealms.craftengine.core.pack.model.SpecialItemModel;
import net.momirealms.craftengine.core.pack.model.condition.ConditionProperty;
import net.momirealms.craftengine.core.pack.model.generation.AbstractModelGenerator;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.select.ChargeTypeSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.SelectProperty;
import net.momirealms.craftengine.core.pack.model.select.TrimMaterialSelectProperty;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.IdSectionConfigParser;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventFunctions;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.util.ExceptionCollector;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersions;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.type.Either;

public abstract class AbstractItemManager<I>
extends AbstractModelGenerator
implements ItemManager<I> {
    protected static final Map<Key, List<ItemBehavior>> VANILLA_ITEM_EXTRA_BEHAVIORS = new HashMap<Key, List<ItemBehavior>>();
    protected static final Set<Key> VANILLA_ITEMS = new HashSet<Key>(1024);
    protected static final Map<Key, List<UniqueKey>> VANILLA_ITEM_TAGS = new HashMap<Key, List<UniqueKey>>();
    private final ItemParser itemParser;
    private final EquipmentParser equipmentParser;
    protected final Map<String, ExternalItemSource<I>> externalItemSources = new HashMap<String, ExternalItemSource<I>>();
    protected final Map<Key, CustomItem<I>> customItemsById = new HashMap<Key, CustomItem<I>>();
    protected final Map<String, CustomItem<I>> customItemsByPath = new HashMap<String, CustomItem<I>>();
    protected final Map<Key, List<UniqueKey>> customItemTags = new HashMap<Key, List<UniqueKey>>();
    protected final Map<Key, ModernItemModel> modernItemModels1_21_4 = new HashMap<Key, ModernItemModel>();
    protected final Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2 = new HashMap<Key, TreeSet<LegacyOverridesModel>>();
    protected final Map<Key, TreeSet<LegacyOverridesModel>> legacyOverrides = new HashMap<Key, TreeSet<LegacyOverridesModel>>();
    protected final Map<Key, TreeMap<Integer, ModernItemModel>> modernOverrides = new HashMap<Key, TreeMap<Integer, ModernItemModel>>();
    protected final Map<Key, Equipment> equipments = new HashMap<Key, Equipment>();
    protected final List<Suggestion> cachedCustomItemSuggestions = new ArrayList<Suggestion>();
    protected final List<Suggestion> cachedAllItemSuggestions = new ArrayList<Suggestion>();
    protected final List<Suggestion> cachedVanillaItemSuggestions = new ArrayList<Suggestion>();
    protected final List<Suggestion> cachedTotemSuggestions = new ArrayList<Suggestion>();

    protected AbstractItemManager(CraftEngine plugin) {
        super(plugin);
        this.itemParser = new ItemParser();
        this.equipmentParser = new EquipmentParser();
        ItemDataModifiers.init();
    }

    public ItemParser itemParser() {
        return this.itemParser;
    }

    public EquipmentParser equipmentParser() {
        return this.equipmentParser;
    }

    protected static void registerVanillaItemExtraBehavior(ItemBehavior behavior, Key ... items) {
        for (Key key : items) {
            VANILLA_ITEM_EXTRA_BEHAVIORS.computeIfAbsent(key, k -> new ArrayList()).add(behavior);
        }
    }

    protected void applyDataModifiers(Map<String, Object> dataSection, Consumer<ItemDataModifier<I>> callback) {
        ExceptionCollector errorCollector = new ExceptionCollector();
        if (dataSection != null) {
            for (Map.Entry<String, Object> dataEntry : dataSection.entrySet()) {
                Object value = dataEntry.getValue();
                if (value == null) continue;
                String key = dataEntry.getKey();
                int idIndex = key.indexOf(35);
                if (idIndex != -1) {
                    key = key.substring(0, idIndex);
                }
                Optional.ofNullable(BuiltInRegistries.ITEM_DATA_MODIFIER_FACTORY.getValue(Key.withDefaultNamespace(key, "craftengine"))).ifPresent(factory -> {
                    try {
                        callback.accept(factory.create(value));
                    }
                    catch (LocalizedResourceConfigException e) {
                        errorCollector.add(e);
                    }
                });
            }
        }
        errorCollector.throwIfPresent();
    }

    @Override
    public ConfigParser[] parsers() {
        return new ConfigParser[]{this.itemParser, this.equipmentParser};
    }

    @Override
    public ExternalItemSource<I> getExternalItemSource(String name) {
        return this.externalItemSources.get(name);
    }

    @Override
    public boolean registerExternalItemSource(ExternalItemSource<I> externalItemSource) {
        if (!ResourceLocation.isValidNamespace(externalItemSource.plugin())) {
            return false;
        }
        if (this.externalItemSources.containsKey(externalItemSource.plugin())) {
            return false;
        }
        this.externalItemSources.put(externalItemSource.plugin(), externalItemSource);
        return true;
    }

    @Override
    public void unload() {
        super.clearModelsToGenerate();
        this.customItemsById.clear();
        this.customItemsByPath.clear();
        this.cachedCustomItemSuggestions.clear();
        this.cachedAllItemSuggestions.clear();
        this.cachedTotemSuggestions.clear();
        this.legacyOverrides.clear();
        this.modernOverrides.clear();
        this.customItemTags.clear();
        this.equipments.clear();
        this.modernItemModels1_21_4.clear();
        this.modernItemModels1_21_2.clear();
    }

    @Override
    public Map<Key, Equipment> equipments() {
        return Collections.unmodifiableMap(this.equipments);
    }

    @Override
    public Optional<Equipment> getEquipment(Key key) {
        return Optional.ofNullable(this.equipments.get(key));
    }

    @Override
    public Optional<CustomItem<I>> getCustomItem(Key key) {
        return Optional.ofNullable(this.customItemsById.get(key));
    }

    @Override
    public Optional<CustomItem<I>> getCustomItemByPathOnly(String path) {
        return Optional.ofNullable(this.customItemsByPath.get(path));
    }

    @Override
    public ItemUpdateResult updateItem(Item<I> item, Supplier<ItemBuildContext> contextSupplier) {
        CustomItem<I> customItem;
        Optional<ItemUpdateConfig> updater;
        Optional<CustomItem<I>> optionalCustomItem = item.getCustomItem();
        if (optionalCustomItem.isPresent() && (updater = (customItem = optionalCustomItem.get()).updater()).isPresent()) {
            return updater.get().update(item, contextSupplier);
        }
        return new ItemUpdateResult(item, false, false);
    }

    @Override
    public boolean addCustomItem(CustomItem<I> customItem) {
        Key id = customItem.id();
        if (this.customItemsById.containsKey(id)) {
            return false;
        }
        this.customItemsById.put(id, customItem);
        this.customItemsByPath.put(id.value(), customItem);
        if (!customItem.isVanillaItem()) {
            this.cachedCustomItemSuggestions.add(Suggestion.suggestion((String)id.toString()));
            if (VersionHelper.isOrAbove1_21_2()) {
                this.cachedTotemSuggestions.add(Suggestion.suggestion((String)id.toString()));
            } else if (customItem.material().equals(ItemKeys.TOTEM_OF_UNDYING)) {
                this.cachedTotemSuggestions.add(Suggestion.suggestion((String)id.toString()));
            }
            Set<Key> tags = customItem.settings().tags();
            for (Key tag : tags) {
                this.customItemTags.computeIfAbsent(tag, k -> new ArrayList()).add(customItem.uniqueId());
            }
        }
        return true;
    }

    @Override
    public List<UniqueKey> vanillaItemIdsByTag(Key tag) {
        return Collections.unmodifiableList(VANILLA_ITEM_TAGS.getOrDefault(tag, List.of()));
    }

    @Override
    public List<UniqueKey> customItemIdsByTag(Key tag) {
        return Collections.unmodifiableList(this.customItemTags.getOrDefault(tag, List.of()));
    }

    @Override
    public Collection<Suggestion> cachedCustomItemSuggestions() {
        return Collections.unmodifiableCollection(this.cachedCustomItemSuggestions);
    }

    @Override
    public Collection<Suggestion> cachedAllItemSuggestions() {
        return Collections.unmodifiableCollection(this.cachedAllItemSuggestions);
    }

    @Override
    public Collection<Suggestion> cachedTotemSuggestions() {
        return Collections.unmodifiableCollection(this.cachedTotemSuggestions);
    }

    @Override
    public Optional<List<ItemBehavior>> getItemBehavior(Key key) {
        Optional<CustomItem<I>> customItemOptional = this.getCustomItem(key);
        if (customItemOptional.isPresent()) {
            CustomItem<I> customItem = customItemOptional.get();
            Key vanillaMaterial = customItem.material();
            List<ItemBehavior> behavior = VANILLA_ITEM_EXTRA_BEHAVIORS.get(vanillaMaterial);
            if (behavior != null) {
                return Optional.of(Stream.concat(customItem.behaviors().stream(), behavior.stream()).toList());
            }
            return Optional.of(List.copyOf(customItem.behaviors()));
        }
        List<ItemBehavior> behavior = VANILLA_ITEM_EXTRA_BEHAVIORS.get(key);
        if (behavior != null) {
            return Optional.of(List.copyOf(behavior));
        }
        return Optional.empty();
    }

    @Override
    public void delayedLoad() {
        this.cachedAllItemSuggestions.addAll(this.cachedVanillaItemSuggestions);
        this.cachedAllItemSuggestions.addAll(this.cachedCustomItemSuggestions);
    }

    @Override
    public Map<Key, CustomItem<I>> loadedItems() {
        return Collections.unmodifiableMap(this.customItemsById);
    }

    @Override
    public Map<Key, ModernItemModel> modernItemModels1_21_4() {
        return Collections.unmodifiableMap(this.modernItemModels1_21_4);
    }

    @Override
    public Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2() {
        return Collections.unmodifiableMap(this.modernItemModels1_21_2);
    }

    @Override
    public Collection<Key> vanillaItems() {
        return Collections.unmodifiableCollection(VANILLA_ITEMS);
    }

    @Override
    public Map<Key, TreeSet<LegacyOverridesModel>> legacyItemOverrides() {
        return Collections.unmodifiableMap(this.legacyOverrides);
    }

    @Override
    public Map<Key, TreeMap<Integer, ModernItemModel>> modernItemOverrides() {
        return Collections.unmodifiableMap(this.modernOverrides);
    }

    @Override
    public boolean isVanillaItem(Key item) {
        return VANILLA_ITEMS.contains(item);
    }

    protected abstract CustomItem.Builder<I> createPlatformItemBuilder(UniqueKey var1, Key var2, Key var3);

    protected abstract void registerArmorTrimPattern(Collection<Key> var1);

    public void addOrMergeEquipment(ComponentBasedEquipment equipment) {
        Equipment previous = this.equipments.get(equipment.assetId());
        if (previous instanceof ComponentBasedEquipment) {
            ComponentBasedEquipment another = (ComponentBasedEquipment)previous;
            for (Map.Entry<EquipmentLayerType, List<ComponentBasedEquipment.Layer>> entry : equipment.layers().entrySet()) {
                another.addLayer(entry.getKey(), entry.getValue());
            }
        } else {
            this.equipments.put(equipment.assetId(), equipment);
        }
    }

    protected void processModelRecursively(ItemModel currentModel, Map<String, Object> accumulatedPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        if (currentModel instanceof ConditionItemModel) {
            ConditionItemModel conditionModel = (ConditionItemModel)currentModel;
            this.handleConditionModel(conditionModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof RangeDispatchItemModel) {
            RangeDispatchItemModel rangeModel = (RangeDispatchItemModel)currentModel;
            this.handleRangeModel(rangeModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof SelectItemModel) {
            SelectItemModel selectModel = (SelectItemModel)currentModel;
            this.handleSelectModel(selectModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof BaseItemModel) {
            BaseItemModel baseModel = (BaseItemModel)currentModel;
            resultList.add(new LegacyOverridesModel(new LinkedHashMap<String, Object>(accumulatedPredicates), baseModel.path(), customModelData));
        } else if (currentModel instanceof SpecialItemModel) {
            SpecialItemModel specialModel = (SpecialItemModel)currentModel;
            resultList.add(new LegacyOverridesModel(new LinkedHashMap<String, Object>(accumulatedPredicates), specialModel.base(), customModelData));
        }
    }

    private void handleConditionModel(ConditionItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        ConditionProperty conditionProperty = model.property();
        if (conditionProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)conditionProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            Map<String, Object> truePredicates = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(true));
            this.processModelRecursively(model.onTrue(), truePredicates, resultList, materialId, customModelData);
            Map<String, Object> falsePredicates = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(false));
            this.processModelRecursively(model.onFalse(), falsePredicates, resultList, materialId, customModelData);
        }
    }

    private void handleRangeModel(RangeDispatchItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        RangeDispatchProperty rangeDispatchProperty = model.property();
        if (rangeDispatchProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)rangeDispatchProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            for (Map.Entry<Float, ItemModel> entry : model.entries().entrySet()) {
                Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(entry.getKey()));
                this.processModelRecursively(entry.getValue(), merged, resultList, materialId, customModelData);
            }
            if (model.fallBack() != null) {
                Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(Float.valueOf(0.0f)));
                this.processModelRecursively(model.fallBack(), merged, resultList, materialId, customModelData);
            }
        }
    }

    private void handleSelectModel(SelectItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        SelectProperty selectProperty = model.property();
        if (selectProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)selectProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            for (Map.Entry<Either<JsonElement, List<JsonElement>>, ItemModel> entry : model.whenMap().entrySet()) {
                List cases = (List)entry.getKey().fallbackOrMapPrimary(List::of);
                for (JsonElement caseValue : cases) {
                    if (!(caseValue instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)caseValue;
                    Number legacyValue = primitive.isBoolean() ? (Number)predicate.toLegacyValue(primitive.getAsBoolean()) : (Number)(primitive.isString() ? (Number)predicate.toLegacyValue(primitive.getAsString()) : (Number)predicate.toLegacyValue(primitive.getAsNumber()));
                    if (predicate instanceof TrimMaterialSelectProperty && legacyValue.floatValue() > 1.0f) continue;
                    Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, legacyValue);
                    if (predicate instanceof ChargeTypeSelectProperty && materialId.equals(ItemKeys.CROSSBOW)) {
                        merged = this.mergePredicates(merged, "charged", 1);
                    }
                    this.processModelRecursively(entry.getValue(), merged, resultList, materialId, customModelData);
                }
            }
            if (model.fallBack() != null) {
                if (predicate instanceof ChargeTypeSelectProperty && materialId.equals(ItemKeys.CROSSBOW)) {
                    this.processModelRecursively(model.fallBack(), this.mergePredicates(parentPredicates, "charged", 0), resultList, materialId, customModelData);
                } else if (predicate instanceof TrimMaterialSelectProperty) {
                    this.processModelRecursively(model.fallBack(), this.mergePredicates(parentPredicates, "trim_type", Float.valueOf(0.0f)), resultList, materialId, customModelData);
                }
            }
        }
    }

    private Map<String, Object> mergePredicates(Map<String, Object> existing, String newKey, Number newValue) {
        LinkedHashMap<String, Object> merged = new LinkedHashMap<String, Object>(existing);
        if (newKey == null) {
            return merged;
        }
        merged.put(newKey, newValue);
        return merged;
    }

    public class ItemParser
    extends IdSectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"items", "item"};
        private final Map<Key, IdAllocator> idAllocators = new HashMap<Key, IdAllocator>();

        private boolean isModernFormatRequired() {
            return Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_4);
        }

        private boolean needsLegacyCompatibility() {
            return Config.packMinVersion().isBelow(MinecraftVersions.V1_21_4);
        }

        private boolean needsCustomModelDataCompatibility() {
            return Config.packMinVersion().isBelow(MinecraftVersions.V1_21_2);
        }

        private boolean needsItemModelCompatibility() {
            return Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2) && VersionHelper.isOrAbove1_21_2();
        }

        public Map<Key, IdAllocator> idAllocators() {
            return this.idAllocators;
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 50;
        }

        @Override
        public void preProcess() {
            this.idAllocators.clear();
        }

        @Override
        public void postProcess() {
            for (Map.Entry<Key, IdAllocator> entry : this.idAllocators.entrySet()) {
                entry.getValue().processPendingAllocations();
                try {
                    entry.getValue().saveToCache();
                }
                catch (IOException e) {
                    AbstractItemManager.this.plugin.logger().warn("Error while saving custom model data allocation for material " + entry.getKey().asString(), e);
                }
            }
        }

        private IdAllocator getOrCreateIdAllocator(Key key) {
            return this.idAllocators.computeIfAbsent(key, k -> {
                IdAllocator newAllocator = new IdAllocator(AbstractItemManager.this.plugin.dataFolderPath().resolve("cache").resolve("custom-model-data").resolve(k.value() + ".json"));
                newAllocator.reset(Config.customModelDataStartingValue(k), 0x1000000);
                try {
                    newAllocator.loadFromCache();
                }
                catch (IOException e) {
                    AbstractItemManager.this.plugin.logger().warn("Error while loading custom model data from cache for material " + k.asString(), e);
                }
                return newAllocator;
            });
        }

        @Override
        public void parseSection(Pack pack, Path path, String node, Key id, Map<String, Object> section) {
            boolean forceCustomModelData;
            CompletableFuture<Integer> customModelDataFuture;
            Key material;
            if (AbstractItemManager.this.customItemsById.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.item.duplicate", new String[0]);
            }
            UniqueKey uniqueId = UniqueKey.create(id);
            boolean isVanillaItem = AbstractItemManager.this.isVanillaItem(id);
            Key clientBoundMaterial = material = isVanillaItem ? id : Key.from(ResourceConfigUtils.requireNonEmptyStringOrThrow(section.get("material"), "warning.config.item.missing_material").toLowerCase(Locale.ROOT));
            if (!isVanillaItem) {
                if (section.containsKey("custom-model-data")) {
                    int customModelData = ResourceConfigUtils.getAsInt(section.getOrDefault("custom-model-data", 0), "custom-model-data");
                    if (customModelData < 0) {
                        throw new LocalizedResourceConfigException("warning.config.item.invalid_custom_model_data", String.valueOf(customModelData));
                    }
                    if (customModelData > 0x1000000) {
                        throw new LocalizedResourceConfigException("warning.config.item.bad_custom_model_data", String.valueOf(customModelData));
                    }
                    customModelDataFuture = this.getOrCreateIdAllocator(clientBoundMaterial).assignFixedId(id.asString(), customModelData);
                    forceCustomModelData = true;
                } else {
                    forceCustomModelData = false;
                    customModelDataFuture = this.needsCustomModelDataCompatibility() ? this.getOrCreateIdAllocator(clientBoundMaterial).requestAutoId(id.asString()) : CompletableFuture.completedFuture(0);
                }
            } else {
                forceCustomModelData = false;
                customModelDataFuture = CompletableFuture.completedFuture(0);
            }
            customModelDataFuture.whenComplete((cmd, throwable) -> ResourceConfigUtils.runCatching(path, node, () -> {
                boolean isVanillaItemModel;
                List<ItemBehavior> behaviors;
                ItemSettings settings;
                Map<EventTrigger, List<Function<PlayerOptionalContext>>> eventTriggerListMap;
                boolean hasModelSection;
                int customModelData;
                block52: {
                    if (throwable != null) {
                        if (throwable instanceof IdAllocator.IdConflictException) {
                            IdAllocator.IdConflictException exception = (IdAllocator.IdConflictException)throwable;
                            if (section.containsKey("model") || section.containsKey("legacy-model")) {
                                throw new LocalizedResourceConfigException("warning.config.item.custom_model_data.conflict", String.valueOf(exception.id()), exception.previousOwner());
                            }
                            customModelData = exception.id();
                            break block52;
                        } else {
                            if (throwable instanceof IdAllocator.IdExhaustedException) {
                                throw new LocalizedResourceConfigException("warning.config.item.custom_model_data.exhausted", clientBoundMaterial.asString());
                            }
                            Debugger.ITEM.warn(() -> "Unknown error while allocating custom model data.", (Throwable)throwable);
                            return;
                        }
                    }
                    customModelData = cmd;
                }
                Key itemModel = null;
                boolean forceItemModel = false;
                if (!isVanillaItem && this.needsItemModelCompatibility()) {
                    if (section.containsKey("item-model")) {
                        itemModel = Key.from(section.get("item-model").toString());
                        forceItemModel = true;
                    } else if (customModelData == 0 || Config.alwaysUseItemModel()) {
                        itemModel = id;
                    }
                }
                boolean clientBoundModel = false;
                CustomItem.Builder itemBuilder = AbstractItemManager.this.createPlatformItemBuilder(uniqueId, material, clientBoundMaterial);
                Map<String, Object> modelSection = MiscUtils.castToMap(section.get("model"), true);
                Map<String, Object> legacyModelSection = MiscUtils.castToMap(section.get("legacy-model"), true);
                boolean bl = hasModelSection = modelSection != null || legacyModelSection != null;
                if (customModelData > 0 && (hasModelSection || forceCustomModelData)) {
                    if (clientBoundModel) {
                        itemBuilder.clientBoundDataModifier(new CustomModelDataModifier(customModelData));
                    } else {
                        itemBuilder.dataModifier(new CustomModelDataModifier(customModelData));
                    }
                }
                if (itemModel != null && (hasModelSection || forceItemModel)) {
                    if (clientBoundModel) {
                        itemBuilder.clientBoundDataModifier(new ItemModelModifier(itemModel));
                    } else {
                        itemBuilder.dataModifier(new ItemModelModifier(itemModel));
                    }
                }
                ExceptionCollector<LocalizedResourceConfigException> collector = new ExceptionCollector<LocalizedResourceConfigException>();
                try {
                    AbstractItemManager.this.applyDataModifiers(MiscUtils.castToMap(section.get("data"), true), itemBuilder::dataModifier);
                }
                catch (LocalizedResourceConfigException e) {
                    collector.add(e);
                }
                if (!isVanillaItem) {
                    itemBuilder.dataModifier(new IdModifier(id));
                }
                try {
                    eventTriggerListMap = EventFunctions.parseEvents(ResourceConfigUtils.get(section, "events", "event"));
                }
                catch (LocalizedResourceConfigException e) {
                    collector.add(e);
                    eventTriggerListMap = Map.of();
                }
                try {
                    settings = Optional.ofNullable(ResourceConfigUtils.get(section, "settings")).map(map -> ItemSettings.fromMap(MiscUtils.castToMap(map, true))).map(it -> isVanillaItem ? it.canPlaceRelatedVanillaBlock(true) : it).orElse(ItemSettings.of().canPlaceRelatedVanillaBlock(isVanillaItem));
                }
                catch (LocalizedResourceConfigException e) {
                    collector.add(e);
                    settings = ItemSettings.of().canPlaceRelatedVanillaBlock(isVanillaItem);
                }
                try {
                    behaviors = ResourceConfigUtils.parseConfigAsList(ResourceConfigUtils.get(section, "behavior", "behaviors"), map -> ItemBehaviors.fromMap(pack, path, node, id, map));
                }
                catch (LocalizedResourceConfigException e) {
                    collector.add(e);
                    behaviors = Collections.emptyList();
                }
                if (section.containsKey("updater")) {
                    Map<String, Object> updater = ResourceConfigUtils.getAsMap(section.get("updater"), "updater");
                    ArrayList<ItemUpdateConfig.Version> versions = new ArrayList<ItemUpdateConfig.Version>(2);
                    for (Map.Entry<String, Object> entry : updater.entrySet()) {
                        try {
                            int version = Integer.parseInt(entry.getKey());
                            versions.add(new ItemUpdateConfig.Version(version, ResourceConfigUtils.parseConfigAsList(entry.getValue(), map -> ItemUpdaters.fromMap(id, map)).toArray(new ItemUpdater[0])));
                        }
                        catch (NumberFormatException version) {}
                    }
                    ItemUpdateConfig config = new ItemUpdateConfig(versions);
                    itemBuilder.updater(config);
                    itemBuilder.dataModifier(new ItemVersionModifier(config.maxVersion()));
                }
                CustomItem customItem = itemBuilder.isVanillaItem(isVanillaItem).behaviors(behaviors).settings(settings).events(eventTriggerListMap).build();
                AbstractItemManager.this.addCustomItem(customItem);
                if (section.containsKey("category")) {
                    AbstractItemManager.this.plugin.itemBrowserManager().addExternalCategoryMember(id, MiscUtils.getAsStringList(section.get("category")).stream().map(Key::of).toList());
                }
                if (isVanillaItem) {
                    return;
                }
                if (!hasModelSection) {
                    collector.throwIfPresent();
                    return;
                }
                if (customModelData == 0 && itemModel == null) {
                    collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.missing_model_id", new String[0]));
                }
                ItemModel modernModel = null;
                TreeSet<LegacyOverridesModel> legacyOverridesModels = null;
                if (this.isModernFormatRequired() || this.needsLegacyCompatibility() && legacyModelSection == null) {
                    if (modelSection == null) {
                        collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.missing_model", new String[0]));
                        return;
                    }
                    try {
                        modernModel = ItemModels.fromMap(modelSection);
                        for (ModelGeneration generation : modernModel.modelsToGenerate()) {
                            AbstractItemManager.this.prepareModelGeneration(generation);
                        }
                    }
                    catch (LocalizedResourceConfigException localizedResourceConfigException) {
                        collector.addAndThrow(localizedResourceConfigException);
                    }
                }
                if (this.needsLegacyCompatibility()) {
                    if (legacyModelSection != null) {
                        try {
                            LegacyItemModel legacyItemModel = LegacyItemModel.fromMap(legacyModelSection, customModelData);
                            for (ModelGeneration generation : legacyItemModel.modelsToGenerate()) {
                                AbstractItemManager.this.prepareModelGeneration(generation);
                            }
                            legacyOverridesModels = new TreeSet<LegacyOverridesModel>(legacyItemModel.overrides());
                        }
                        catch (LocalizedResourceConfigException localizedResourceConfigException) {
                            collector.addAndThrow(localizedResourceConfigException);
                        }
                    } else {
                        legacyOverridesModels = new TreeSet<LegacyOverridesModel>();
                        AbstractItemManager.this.processModelRecursively(modernModel, new LinkedHashMap<String, Object>(), legacyOverridesModels, clientBoundMaterial, customModelData);
                        if (legacyOverridesModels.isEmpty()) {
                            collector.add(new LocalizedResourceConfigException("warning.config.item.legacy_model.cannot_convert", new String[0]));
                        }
                    }
                }
                boolean bl2 = legacyOverridesModels != null && !legacyOverridesModels.isEmpty();
                boolean hasModernModel = modernModel != null;
                boolean bl3 = isVanillaItemModel = itemModel != null && AbstractPackManager.PRESET_ITEMS.containsKey(itemModel);
                if (customModelData != 0) {
                    Key finalBaseModel;
                    Key key = finalBaseModel = isVanillaItemModel ? itemModel : clientBoundMaterial;
                    if (this.isModernFormatRequired() && hasModernModel) {
                        TreeMap map2 = AbstractItemManager.this.modernOverrides.computeIfAbsent(finalBaseModel, k -> new TreeMap());
                        map2.put(customModelData, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
                    }
                    if (this.needsLegacyCompatibility() && bl2) {
                        TreeSet lom = AbstractItemManager.this.legacyOverrides.computeIfAbsent(finalBaseModel, k -> new TreeSet());
                        lom.addAll(legacyOverridesModels);
                    }
                } else if (isVanillaItemModel) {
                    collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.item_model.conflict", itemModel.asString()));
                }
                if (itemModel != null && !isVanillaItemModel) {
                    if (this.isModernFormatRequired() && hasModernModel) {
                        AbstractItemManager.this.modernItemModels1_21_4.put(itemModel, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
                    }
                    if (this.needsItemModelCompatibility() && this.needsLegacyCompatibility() && bl2) {
                        TreeSet lom = AbstractItemManager.this.modernItemModels1_21_2.computeIfAbsent(itemModel, k -> new TreeSet());
                        lom.addAll(legacyOverridesModels);
                    }
                }
                collector.throwIfPresent();
            }, () -> GsonHelper.get().toJson((Object)section)));
        }
    }

    public class EquipmentParser
    extends IdSectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"equipments", "equipment"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 40;
        }

        @Override
        public void parseSection(Pack pack, Path path, String node, Key id, Map<String, Object> section) {
            if (AbstractItemManager.this.equipments.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.equipment.duplicate", new String[0]);
            }
            Equipment equipment = Equipments.fromMap(id, section);
            AbstractItemManager.this.equipments.put(id, equipment);
        }

        @Override
        public void postProcess() {
            List<Key> trims = AbstractItemManager.this.equipments.values().stream().filter(TrimBasedEquipment.class::isInstance).map(Equipment::assetId).toList();
            AbstractItemManager.this.registerArmorTrimPattern(trims);
        }
    }
}

