/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Optional;
import net.momirealms.craftengine.core.attribute.AttributeModifier;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.item.data.FireworkExplosion;
import net.momirealms.craftengine.core.item.data.JukeboxPlayable;
import net.momirealms.craftengine.core.item.data.Trim;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.setting.EquipmentData;
import net.momirealms.craftengine.core.util.Color;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Item<I> {
    public boolean isEmpty();

    public Optional<CustomItem<I>> getCustomItem();

    public Optional<List<ItemBehavior>> getItemBehavior();

    public boolean isCustomItem();

    public boolean isBlockItem();

    @NotNull
    public Key id();

    @NotNull
    public Key vanillaId();

    @Nullable
    public UniqueKey recipeIngredientId();

    public Optional<Key> customId();

    public Item<I> customId(Key var1);

    public int count();

    public Item<I> count(int var1);

    public Item<I> trim(Trim var1);

    public Optional<Trim> trim();

    public Item<I> customModelData(Integer var1);

    public Optional<Integer> customModelData();

    public Item<I> damage(Integer var1);

    public Optional<Integer> damage();

    public Item<I> repairCost(Integer var1);

    public Optional<Integer> repairCost();

    public Item<I> maxDamage(Integer var1);

    public int maxDamage();

    public Item<I> dyedColor(Color var1);

    public Optional<Color> dyedColor();

    public Item<I> fireworkExplosion(FireworkExplosion var1);

    public Optional<FireworkExplosion> fireworkExplosion();

    public Item<I> customNameJson(String var1);

    public Item<I> customNameComponent(Component var1);

    public Optional<String> customNameJson();

    public Optional<Component> customNameComponent();

    default public Optional<String> hoverNameJson() {
        return this.customNameJson().or(this::itemNameJson);
    }

    default public Optional<Component> hoverNameComponent() {
        return this.customNameComponent().or(this::itemNameComponent);
    }

    public Item<I> itemNameJson(String var1);

    public Item<I> itemNameComponent(Component var1);

    public Optional<String> itemNameJson();

    public Optional<Component> itemNameComponent();

    public Item<I> itemModel(String var1);

    public Optional<String> itemModel();

    public Item<I> tooltipStyle(String var1);

    public Optional<String> tooltipStyle();

    public Item<I> loreJson(List<String> var1);

    public Item<I> loreComponent(List<Component> var1);

    public Optional<List<String>> loreJson();

    public Optional<List<Component>> loreComponent();

    public Item<I> attributeModifiers(List<AttributeModifier> var1);

    public Optional<JukeboxPlayable> jukeboxSong();

    public Item<I> jukeboxSong(JukeboxPlayable var1);

    public Optional<EquipmentData> equippable();

    public Item<I> equippable(EquipmentData var1);

    public Item<I> unbreakable(boolean var1);

    public boolean unbreakable();

    public Item<I> skull(String var1);

    public Optional<Enchantment> getEnchantment(Key var1);

    public Item<I> setEnchantments(List<Enchantment> var1);

    public Item<I> setStoredEnchantments(List<Enchantment> var1);

    public Item<I> itemFlags(List<String> var1);

    public Object getJavaTag(Object ... var1);

    public Tag getTag(Object ... var1);

    public Object getExactTag(Object ... var1);

    public Item<I> setTag(Object var1, Object ... var2);

    public boolean hasTag(Object ... var1);

    public boolean removeTag(Object ... var1);

    public boolean hasComponent(Object var1);

    public boolean hasNonDefaultComponent(Object var1);

    public void removeComponent(Object var1);

    public void setExactComponent(Object var1, Object var2);

    public Object getExactComponent(Object var1);

    public Object getJavaComponent(Object var1);

    public JsonElement getJsonComponent(Object var1);

    public Tag getSparrowNBTComponent(Object var1);

    public Object getNBTComponent(Object var1);

    public void setComponent(Object var1, Object var2);

    public void setJavaComponent(Object var1, Object var2);

    public void setJsonComponent(Object var1, JsonElement var2);

    public void setNBTComponent(Object var1, Tag var2);

    public void resetComponent(Object var1);

    public I getItem();

    public int maxStackSize();

    public Item<I> maxStackSize(int var1);

    public Item<I> copyWithCount(int var1);

    public boolean hasItemTag(Key var1);

    public Object getLiteralObject();

    public Item<I> mergeCopy(Item<?> var1);

    public Item<I> transmuteCopy(Key var1, int var2);

    public Item<I> unsafeTransmuteCopy(Object var1, int var2);

    public void shrink(int var1);

    default public Item<I> transmuteCopy(Key another) {
        return this.transmuteCopy(another, this.count());
    }

    public void merge(Item<I> var1);

    default public Item<I> apply(ItemDataModifier<I> modifier, ItemBuildContext context) {
        return modifier.apply(this, context);
    }

    public byte[] toByteArray();

    default public Item<I> applyDyedColors(List<Color> colors) {
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int totalMaxComponent = 0;
        int colorCount = 0;
        Optional<Color> existingColor = this.dyedColor();
        existingColor.ifPresent(colors::add);
        for (Color color : colors) {
            int dyeRed = color.r();
            int dyeGreen = color.g();
            int dyeBlue = color.b();
            totalMaxComponent += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue));
            totalRed += dyeRed;
            totalGreen += dyeGreen;
            totalBlue += dyeBlue;
            ++colorCount;
        }
        int avgRed = totalRed / colorCount;
        int avgGreen = totalGreen / colorCount;
        int avgBlue = totalBlue / colorCount;
        float avgMaxComponent = (float)totalMaxComponent / (float)colorCount;
        float currentMaxComponent = Math.max(avgRed, Math.max(avgGreen, avgBlue));
        avgRed = (int)((float)avgRed * avgMaxComponent / currentMaxComponent);
        avgGreen = (int)((float)avgGreen * avgMaxComponent / currentMaxComponent);
        avgBlue = (int)((float)avgBlue * avgMaxComponent / currentMaxComponent);
        Color finalColor = new Color(0, avgRed, avgGreen, avgBlue);
        return this.dyedColor(finalColor);
    }
}

