/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.util.StringUtils;
import net.momirealms.craftengine.core.util.TriConsumer;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public interface NetworkItemHandler<T> {
    public static final Operation[] BY_INDEX = new Operation[]{Operation.ADD, Operation.REMOVE, Operation.RESET};
    public static final String NETWORK_ITEM_TAG = "craftengine:network_modifiers";
    public static final String NETWORK_OPERATION = "type";
    public static final String NETWORK_VALUE = "value";

    public Optional<Item<T>> s2c(Item<T> var1, Player var2);

    public Optional<Item<T>> c2s(Item<T> var1);

    public static CompoundTag pack(Operation operation, @Nullable Tag value) {
        if (value == null) {
            return new CompoundTag(Map.of(NETWORK_OPERATION, operation.tag()));
        }
        return new CompoundTag(Map.of(NETWORK_OPERATION, operation.tag(), NETWORK_VALUE, value));
    }

    public static CompoundTag pack(Operation operation) {
        return new CompoundTag(Map.of(NETWORK_OPERATION, operation.tag()));
    }

    public static <T> void apply(String tagPath, CompoundTag networkData, Item<T> item) {
        byte index = networkData.getByte(NETWORK_OPERATION);
        Operation operation = BY_INDEX[index];
        operation.consumer.accept(item, tagPath, operation == Operation.ADD ? networkData.get(NETWORK_VALUE) : null);
    }

    public static enum Operation {
        ADD(0, Item::setNBTComponent, (i, s, t) -> i.setTag(t, StringUtils.splitByDot(s))),
        REMOVE(1, (i, s, t) -> i.removeComponent(s), (i, s, t) -> i.removeTag(StringUtils.splitByDot(s))),
        RESET(2, (i, s, t) -> i.resetComponent(s), (i, s, t) -> i.removeTag(StringUtils.splitByDot(s)));

        private final int id;
        private final ByteTag tag;
        private final TriConsumer<Item<?>, String, Tag> consumer;

        private Operation(int id, TriConsumer<Item<?>, String, Tag> componentConsumer, TriConsumer<Item<?>, String, Tag> nbtConsumer) {
            this.id = id;
            this.tag = new ByteTag((byte)id);
            this.consumer = VersionHelper.isOrAbove1_20_5() ? componentConsumer : nbtConsumer;
        }

        public int id() {
            return this.id;
        }

        public ByteTag tag() {
            return this.tag;
        }
    }
}

