/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.behavior;

import java.nio.file.Path;
import java.util.Map;
import net.momirealms.craftengine.core.item.behavior.EmptyItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviorFactory;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class ItemBehaviors {
    public static final Key EMPTY = Key.withDefaultNamespace("empty", "craftengine");

    public static void register(Key key, ItemBehaviorFactory factory) {
        ((WritableRegistry)BuiltInRegistries.ITEM_BEHAVIOR_FACTORY).register(ResourceKey.create(Registries.ITEM_BEHAVIOR_FACTORY.location(), key), factory);
    }

    public static ItemBehavior fromMap(Pack pack, Path path, String node, Key id, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EmptyItemBehavior.INSTANCE;
        }
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.item.behavior.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        ItemBehaviorFactory factory = BuiltInRegistries.ITEM_BEHAVIOR_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.behavior.invalid_type", type);
        }
        return factory.create(pack, path, node, id, map);
    }
}

