/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.equipment;

import java.util.Map;
import net.momirealms.craftengine.core.item.equipment.ComponentBasedEquipment;
import net.momirealms.craftengine.core.item.equipment.Equipment;
import net.momirealms.craftengine.core.item.equipment.EquipmentFactory;
import net.momirealms.craftengine.core.item.equipment.TrimBasedEquipment;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public final class Equipments {
    public static final Key TRIM = Key.of("craftengine:trim");
    public static final Key COMPONENT = Key.of("craftengine:component");

    public static void register(Key key, EquipmentFactory factory) {
        ((WritableRegistry)BuiltInRegistries.EQUIPMENT_FACTORY).register(ResourceKey.create(Registries.EQUIPMENT_FACTORY.location(), key), factory);
    }

    public static Equipment fromMap(Key id, Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.equipment.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        EquipmentFactory factory = BuiltInRegistries.EQUIPMENT_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.equipment.invalid_type", type);
        }
        return factory.create(id, map);
    }

    static {
        Equipments.register(TRIM, TrimBasedEquipment.FACTORY);
        Equipments.register(COMPONENT, ComponentBasedEquipment.FACTORY);
    }
}

