/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.item.modifier.SimpleNetworkItemDataModifier;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.text.minimessage.FormattedLine;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.Nullable;

public class CustomNameModifier<I>
implements SimpleNetworkItemDataModifier<I> {
    public static final Factory<?> FACTORY = new Factory();
    private final String argument;
    private final FormattedLine line;

    public CustomNameModifier(String argument) {
        this.argument = Config.addNonItalicTag() ? (argument.startsWith("<!i>") ? argument : "<!i>" + argument) : argument;
        this.line = FormattedLine.create(this.argument);
    }

    public String customName() {
        return this.argument;
    }

    @Override
    public Key type() {
        return ItemDataModifiers.CUSTOM_NAME;
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        item.customNameComponent(this.line.parse(context));
        return item;
    }

    @Override
    @Nullable
    public Key componentType(Item<I> item, ItemBuildContext context) {
        return ComponentKeys.CUSTOM_NAME;
    }

    @Override
    @Nullable
    public Object[] nbtPath(Item<I> item, ItemBuildContext context) {
        return new Object[]{"display", "Name"};
    }

    @Override
    public String nbtPathString(Item<I> item, ItemBuildContext context) {
        return "display.Name";
    }

    public static class Factory<I>
    implements ItemDataModifierFactory<I> {
        @Override
        public ItemDataModifier<I> create(Object arg) {
            String name = arg.toString();
            return new CustomNameModifier(name);
        }
    }
}

