/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import net.momirealms.craftengine.core.item.ExternalItemSource;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.NotNull;

public class ExternalModifier<I>
implements ItemDataModifier<I> {
    public static final Factory<?> FACTORY = new Factory();
    private static final ThreadLocal<Set<Dependency>> BUILD_STACK = ThreadLocal.withInitial(LinkedHashSet::new);
    private final String id;
    private final ExternalItemSource<I> provider;

    public ExternalModifier(String id, ExternalItemSource<I> provider) {
        this.id = id;
        this.provider = provider;
    }

    public String id() {
        return this.id;
    }

    public ExternalItemSource<I> source() {
        return this.provider;
    }

    @Override
    public Key type() {
        return ItemDataModifiers.EXTERNAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        Dependency dependency = new Dependency(this.provider.plugin(), this.id);
        Set<Dependency> buildStack = BUILD_STACK.get();
        if (buildStack.contains(dependency)) {
            StringJoiner dependencyChain = new StringJoiner(" -> ");
            buildStack.forEach(element -> dependencyChain.add(element.asString()));
            dependencyChain.add(dependency.asString());
            CraftEngine.instance().logger().warn("Failed to build '" + this.id + "' from plugin '" + this.provider.plugin() + "' due to dependency loop: " + String.valueOf(dependencyChain));
            return item;
        }
        buildStack.add(dependency);
        try {
            I another = this.provider.build(this.id, context);
            if (another == null) {
                CraftEngine.instance().logger().warn("'" + this.id + "' could not be found in " + this.provider.plugin());
                Item item2 = item;
                return item2;
            }
            Item anotherWrapped = CraftEngine.instance().itemManager().wrap(another);
            item.merge(anotherWrapped);
            Item item3 = item;
            return item3;
        }
        catch (Throwable e) {
            CraftEngine.instance().logger().warn("Failed to build item '" + this.id + "' from plugin '" + this.provider.plugin() + "'", e);
            Item item4 = item;
            return item4;
        }
        finally {
            buildStack.remove(dependency);
            BUILD_STACK.remove();
        }
    }

    private record Dependency(String source, String id) {
        @NotNull
        public String asString() {
            return this.source + "[id=" + this.id + "]";
        }
    }

    public static class Factory<I>
    implements ItemDataModifierFactory<I> {
        @Override
        public ItemDataModifier<I> create(Object arg) {
            Map<String, Object> data = ResourceConfigUtils.getAsMap(arg, "external");
            String plugin = ResourceConfigUtils.requireNonEmptyStringOrThrow(ResourceConfigUtils.get(data, "plugin", "source"), "warning.config.item.data.external.missing_source");
            String id = ResourceConfigUtils.requireNonEmptyStringOrThrow(data.get("id"), "warning.config.item.data.external.missing_id");
            ExternalItemSource provider = CraftEngine.instance().itemManager().getExternalItemSource(plugin.toLowerCase(Locale.ENGLISH));
            return new ExternalModifier(id, ResourceConfigUtils.requireNonNullOrThrow(provider, () -> new LocalizedResourceConfigException("warning.config.item.data.external.invalid_source", plugin)));
        }
    }
}

