/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.modifier.ArgumentsModifier;
import net.momirealms.craftengine.core.item.modifier.AttributeModifiersModifier;
import net.momirealms.craftengine.core.item.modifier.ComponentsModifier;
import net.momirealms.craftengine.core.item.modifier.CustomModelDataModifier;
import net.momirealms.craftengine.core.item.modifier.CustomNameModifier;
import net.momirealms.craftengine.core.item.modifier.DyedColorModifier;
import net.momirealms.craftengine.core.item.modifier.EnchantmentsModifier;
import net.momirealms.craftengine.core.item.modifier.EquippableModifier;
import net.momirealms.craftengine.core.item.modifier.ExternalModifier;
import net.momirealms.craftengine.core.item.modifier.FoodModifier;
import net.momirealms.craftengine.core.item.modifier.HideTooltipModifier;
import net.momirealms.craftengine.core.item.modifier.ItemModelModifier;
import net.momirealms.craftengine.core.item.modifier.ItemNameModifier;
import net.momirealms.craftengine.core.item.modifier.JukeboxSongModifier;
import net.momirealms.craftengine.core.item.modifier.MaxDamageModifier;
import net.momirealms.craftengine.core.item.modifier.OverwritableItemNameModifier;
import net.momirealms.craftengine.core.item.modifier.PDCModifier;
import net.momirealms.craftengine.core.item.modifier.RemoveComponentModifier;
import net.momirealms.craftengine.core.item.modifier.TagsModifier;
import net.momirealms.craftengine.core.item.modifier.TooltipStyleModifier;
import net.momirealms.craftengine.core.item.modifier.TrimModifier;
import net.momirealms.craftengine.core.item.modifier.UnbreakableModifier;
import net.momirealms.craftengine.core.item.modifier.lore.DynamicLoreModifier;
import net.momirealms.craftengine.core.item.modifier.lore.LoreModifier;
import net.momirealms.craftengine.core.item.modifier.lore.OverwritableLoreModifier;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.core.util.VersionHelper;

public final class ItemDataModifiers {
    public static final Key ITEM_MODEL = Key.of("craftengine:item-model");
    public static final Key ID = Key.of("craftengine:id");
    public static final Key HIDE_TOOLTIP = Key.of("craftengine:hide-tooltip");
    public static final Key FOOD = Key.of("craftengine:food");
    public static final Key EXTERNAL = Key.of("craftengine:external");
    public static final Key EQUIPPABLE = Key.of("craftengine:equippable");
    public static final Key EQUIPPABLE_ASSET_ID = Key.of("craftengine:equippable-asset-id");
    public static final Key ENCHANTMENT = Key.of("craftengine:enchantment");
    public static final Key ENCHANTMENTS = Key.of("craftengine:enchantments");
    public static final Key DYED_COLOR = Key.of("craftengine:dyed-color");
    public static final Key DISPLAY_NAME = Key.of("craftengine:display-name");
    public static final Key CUSTOM_NAME = Key.of("craftengine:custom-name");
    public static final Key CUSTOM_MODEL_DATA = Key.of("craftengine:custom-model-data");
    public static final Key COMPONENTS = Key.of("craftengine:components");
    public static final Key ATTRIBUTE_MODIFIERS = Key.of("craftengine:attribute-modifiers");
    public static final Key ATTRIBUTES = Key.of("craftengine:attributes");
    public static final Key ARGUMENTS = Key.of("craftengine:arguments");
    public static final Key VERSION = Key.of("craftengine:version");
    public static final Key PDC = Key.of("craftengine:pdc");
    public static final Key ITEM_NAME = Key.of("craftengine:item-name");
    public static final Key OVERWRITABLE_ITEM_NAME = Key.of("craftengine:overwritable-item-name");
    public static final Key JUKEBOX_PLAYABLE = Key.of("craftengine:jukebox-playable");
    public static final Key REMOVE_COMPONENTS = Key.of("craftengine:remove-components");
    public static final Key TAGS = Key.of("craftengine:tags");
    public static final Key NBT = Key.of("craftengine:nbt");
    public static final Key TOOLTIP_STYLE = Key.of("craftengine:tooltip-style");
    public static final Key TRIM = Key.of("craftengine:trim");
    public static final Key LORE = Key.of("craftengine:lore");
    public static final Key UNBREAKABLE = Key.of("craftengine:unbreakable");
    public static final Key DYNAMIC_LORE = Key.of("craftengine:dynamic-lore");
    public static final Key OVERWRITABLE_LORE = Key.of("craftengine:overwritable-lore");
    public static final Key MAX_DAMAGE = Key.of("craftengine:max-damage");

    private ItemDataModifiers() {
    }

    public static <T> void register(Key key, ItemDataModifierFactory<T> factory) {
        ((WritableRegistry)BuiltInRegistries.ITEM_DATA_MODIFIER_FACTORY).register(ResourceKey.create(Registries.ITEM_DATA_MODIFIER_FACTORY.location(), key), factory);
        if (key.value().contains("-")) {
            ((WritableRegistry)BuiltInRegistries.ITEM_DATA_MODIFIER_FACTORY).register(ResourceKey.create(Registries.ITEM_DATA_MODIFIER_FACTORY.location(), new Key(key.namespace(), key.value().replace("-", "_"))), factory);
        }
    }

    public static void init() {
    }

    static {
        ItemDataModifiers.register(EXTERNAL, ExternalModifier.FACTORY);
        ItemDataModifiers.register(LORE, LoreModifier.FACTORY);
        ItemDataModifiers.register(DYNAMIC_LORE, DynamicLoreModifier.FACTORY);
        ItemDataModifiers.register(OVERWRITABLE_LORE, OverwritableLoreModifier.FACTORY);
        ItemDataModifiers.register(DYED_COLOR, DyedColorModifier.FACTORY);
        ItemDataModifiers.register(TAGS, TagsModifier.FACTORY);
        ItemDataModifiers.register(NBT, TagsModifier.FACTORY);
        ItemDataModifiers.register(ATTRIBUTE_MODIFIERS, AttributeModifiersModifier.FACTORY);
        ItemDataModifiers.register(ATTRIBUTES, AttributeModifiersModifier.FACTORY);
        ItemDataModifiers.register(CUSTOM_MODEL_DATA, CustomModelDataModifier.FACTORY);
        ItemDataModifiers.register(UNBREAKABLE, UnbreakableModifier.FACTORY);
        ItemDataModifiers.register(ENCHANTMENT, EnchantmentsModifier.FACTORY);
        ItemDataModifiers.register(ENCHANTMENTS, EnchantmentsModifier.FACTORY);
        ItemDataModifiers.register(TRIM, TrimModifier.FACTORY);
        ItemDataModifiers.register(HIDE_TOOLTIP, HideTooltipModifier.FACTORY);
        ItemDataModifiers.register(ARGUMENTS, ArgumentsModifier.FACTORY);
        ItemDataModifiers.register(OVERWRITABLE_ITEM_NAME, OverwritableItemNameModifier.FACTORY);
        ItemDataModifiers.register(PDC, PDCModifier.FACTORY);
        if (VersionHelper.isOrAbove1_20_5()) {
            ItemDataModifiers.register(CUSTOM_NAME, CustomNameModifier.FACTORY);
            ItemDataModifiers.register(ITEM_NAME, ItemNameModifier.FACTORY);
            ItemDataModifiers.register(DISPLAY_NAME, ItemNameModifier.FACTORY);
            ItemDataModifiers.register(COMPONENTS, ComponentsModifier.FACTORY);
            ItemDataModifiers.register(REMOVE_COMPONENTS, RemoveComponentModifier.FACTORY);
            ItemDataModifiers.register(FOOD, FoodModifier.FACTORY);
            ItemDataModifiers.register(MAX_DAMAGE, MaxDamageModifier.FACTORY);
        } else {
            ItemDataModifiers.register(CUSTOM_NAME, CustomNameModifier.FACTORY);
            ItemDataModifiers.register(ITEM_NAME, CustomNameModifier.FACTORY);
            ItemDataModifiers.register(DISPLAY_NAME, CustomNameModifier.FACTORY);
        }
        if (VersionHelper.isOrAbove1_21()) {
            ItemDataModifiers.register(JUKEBOX_PLAYABLE, JukeboxSongModifier.FACTORY);
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            ItemDataModifiers.register(TOOLTIP_STYLE, TooltipStyleModifier.FACTORY);
            ItemDataModifiers.register(ITEM_MODEL, ItemModelModifier.FACTORY);
            ItemDataModifiers.register(EQUIPPABLE, EquippableModifier.FACTORY);
        }
    }
}

