/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.item.modifier.ItemNameModifier;
import net.momirealms.craftengine.core.item.modifier.SimpleNetworkItemDataModifier;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.jetbrains.annotations.Nullable;

public class OverwritableItemNameModifier<I>
implements SimpleNetworkItemDataModifier<I> {
    public static final Factory<?> FACTORY = new Factory();
    private final ItemNameModifier<I> modifier;

    public OverwritableItemNameModifier(String argument) {
        this.modifier = new ItemNameModifier(argument);
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        if (VersionHelper.COMPONENT_RELEASE ? item.hasNonDefaultComponent(ComponentKeys.ITEM_NAME) : item.hasTag("display", "Name")) {
            return item;
        }
        return this.modifier.apply(item, context);
    }

    @Override
    public Key type() {
        return ItemDataModifiers.OVERWRITABLE_ITEM_NAME;
    }

    @Override
    @Nullable
    public Key componentType(Item<I> item, ItemBuildContext context) {
        return ComponentKeys.ITEM_NAME;
    }

    @Override
    @Nullable
    public Object[] nbtPath(Item<I> item, ItemBuildContext context) {
        return new Object[]{"display", "Name"};
    }

    @Override
    public String nbtPathString(Item<I> item, ItemBuildContext context) {
        return "display.Name";
    }

    public static class Factory<I>
    implements ItemDataModifierFactory<I> {
        @Override
        public ItemDataModifier<I> create(Object arg) {
            return new OverwritableItemNameModifier(arg.toString());
        }
    }
}

