/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import java.util.Collections;
import java.util.List;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class RemoveComponentModifier<I>
implements ItemDataModifier<I> {
    public static final Factory<?> FACTORY = new Factory();
    private final List<String> arguments;

    public RemoveComponentModifier(List<String> arguments) {
        this.arguments = arguments;
    }

    public List<String> components() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Key type() {
        return ItemDataModifiers.REMOVE_COMPONENTS;
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        for (String argument : this.arguments) {
            item.removeComponent(argument);
        }
        return item;
    }

    @Override
    public Item<I> prepareNetworkItem(Item<I> item, ItemBuildContext context, CompoundTag networkData) {
        for (String component : this.arguments) {
            Tag previous = item.getSparrowNBTComponent(component);
            if (previous == null) continue;
            networkData.put(component, NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
        }
        return item;
    }

    public static class Factory<I>
    implements ItemDataModifierFactory<I> {
        @Override
        public ItemDataModifier<I> create(Object arg) {
            List<String> data = MiscUtils.getAsStringList(arg);
            return new RemoveComponentModifier(data);
        }
    }
}

