/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier.lore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.item.modifier.SimpleNetworkItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.lore.LoreModification;
import net.momirealms.craftengine.core.item.modifier.lore.LoreModificationHolder;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.text.minimessage.FormattedLine;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public sealed interface LoreModifier<I>
extends SimpleNetworkItemDataModifier<I> {
    public static final Factory<?> FACTORY = new Factory();

    @Override
    default public Key type() {
        return ItemDataModifiers.LORE;
    }

    @Override
    @Nullable
    default public Key componentType(Item<I> item, ItemBuildContext context) {
        return ComponentKeys.LORE;
    }

    @Override
    @Nullable
    default public Object[] nbtPath(Item<I> item, ItemBuildContext context) {
        return new Object[]{"display", "Lore"};
    }

    @Override
    default public String nbtPathString(Item<I> item, ItemBuildContext context) {
        return "display.Lore";
    }

    public List<LoreModification> lore();

    public static <I> LoreModifier<I> createLoreModifier(Object arg) {
        List<Object> rawLoreData;
        block8: {
            rawLoreData = MiscUtils.getAsList(arg, Object.class);
            String[] rawLore = new String[rawLoreData.size()];
            for (int i = 0; i < rawLore.length; ++i) {
                Object o = rawLoreData.get(i);
                if (!(o instanceof Map)) {
                    rawLore[i] = o.toString();
                    continue;
                }
                break block8;
            }
            return new SingleLoreModifier(new LoreModification(LoreModification.Operation.APPEND, false, (FormattedLine[])Arrays.stream(rawLore).map(line -> Config.addNonItalicTag() && !line.startsWith("<!i>") ? FormattedLine.create("<!i>" + line) : FormattedLine.create(line)).toArray(FormattedLine[]::new)));
        }
        ArrayList<LoreModificationHolder> modifications = new ArrayList<LoreModificationHolder>(rawLoreData.size() + 1);
        int lastPriority = 0;
        for (Object o : rawLoreData) {
            if (!(o instanceof Map)) continue;
            Map complexLore = (Map)o;
            String[] content = MiscUtils.getAsStringArray(complexLore.get("content"));
            LoreModification.Operation operation = ResourceConfigUtils.getAsEnum(Optional.ofNullable(complexLore.get("operation")).map(String::valueOf).orElse(null), LoreModification.Operation.class, LoreModification.Operation.APPEND);
            lastPriority = Optional.ofNullable(complexLore.get("priority")).map(it -> ResourceConfigUtils.getAsInt(it, "priority")).orElse(lastPriority);
            boolean split = ResourceConfigUtils.getAsBoolean(complexLore.get("split-lines"), "split-lines");
            modifications.add(new LoreModificationHolder(new LoreModification(operation, split, (FormattedLine[])Arrays.stream(content).map(line -> Config.addNonItalicTag() && !line.startsWith("<!i>") ? FormattedLine.create("<!i>" + line) : FormattedLine.create(line)).toArray(FormattedLine[]::new)), lastPriority));
        }
        modifications.sort(LoreModificationHolder::compareTo);
        return switch (modifications.size()) {
            case 0 -> new EmptyLoreModifier();
            case 1 -> new SingleLoreModifier(((LoreModificationHolder)modifications.get(0)).modification());
            case 2 -> new DoubleLoreModifier(((LoreModificationHolder)modifications.get(0)).modification(), ((LoreModificationHolder)modifications.get(1)).modification());
            default -> new CompositeLoreModifier((LoreModification[])modifications.stream().map(LoreModificationHolder::modification).toArray(LoreModification[]::new));
        };
    }

    public static class SingleLoreModifier<I>
    implements LoreModifier<I> {
        private final LoreModification modification;

        public SingleLoreModifier(LoreModification modification) {
            this.modification = modification;
        }

        @Override
        public Item<I> apply(Item<I> item, ItemBuildContext context) {
            item.loreComponent(this.modification.parseAsList(context));
            return item;
        }

        @Override
        public List<LoreModification> lore() {
            return List.of(this.modification);
        }
    }

    public static class EmptyLoreModifier<I>
    implements LoreModifier<I> {
        @Override
        public Item<I> apply(Item<I> item, ItemBuildContext context) {
            return item;
        }

        @Override
        public List<LoreModification> lore() {
            return List.of();
        }
    }

    public static class DoubleLoreModifier<I>
    implements LoreModifier<I> {
        private final LoreModification modification1;
        private final LoreModification modification2;

        public DoubleLoreModifier(LoreModification m1, LoreModification m2) {
            this.modification1 = m1;
            this.modification2 = m2;
        }

        @Override
        public Item<I> apply(Item<I> item, ItemBuildContext context) {
            item.loreComponent(this.modification2.apply(this.modification1.apply(Stream.empty(), context), context).toList());
            return item;
        }

        @Override
        public List<LoreModification> lore() {
            return List.of(this.modification1, this.modification2);
        }
    }

    public static class CompositeLoreModifier<I>
    implements LoreModifier<I> {
        private final LoreModification[] modifications;

        public CompositeLoreModifier(LoreModification ... modifications) {
            this.modifications = modifications;
        }

        @Override
        public Item<I> apply(Item<I> item, ItemBuildContext context) {
            item.loreComponent(Arrays.stream(this.modifications).reduce(Stream.empty(), (stream, modification) -> modification.apply((Stream<Component>)stream, context), Stream::concat).toList());
            return item;
        }

        @Override
        public List<LoreModification> lore() {
            return Arrays.asList(this.modifications);
        }
    }

    public static class Factory<I>
    implements ItemDataModifierFactory<I> {
        @Override
        public ItemDataModifier<I> create(Object arg) {
            return LoreModifier.createLoreModifier(arg);
        }
    }
}

