/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.item.recipe.AbstractedFixedResultRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeManager;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializers;
import net.momirealms.craftengine.core.item.recipe.RecipeType;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.IdSectionConfigParser;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeManager<T>
implements RecipeManager<T> {
    protected final Map<RecipeType, List<Recipe<T>>> byType = new EnumMap<RecipeType, List<Recipe<T>>>(RecipeType.class);
    protected final Map<Key, Recipe<T>> byId = new LinkedHashMap<Key, Recipe<T>>();
    protected final Map<Key, List<Recipe<T>>> byResult = new HashMap<Key, List<Recipe<T>>>();
    protected final Map<Key, List<Recipe<T>>> byIngredient = new HashMap<Key, List<Recipe<T>>>();
    protected final Set<Key> dataPackRecipes = new HashSet<Key>();
    protected final RecipeParser recipeParser = new RecipeParser();

    @Override
    public ConfigParser parser() {
        return this.recipeParser;
    }

    @Override
    public void unload() {
        this.dataPackRecipes.clear();
        this.byType.clear();
        this.byId.clear();
        this.byResult.clear();
        this.byIngredient.clear();
    }

    protected void markAsDataPackRecipe(Key key) {
        this.dataPackRecipes.add(key);
    }

    @Override
    public boolean isDataPackRecipe(Key key) {
        return this.dataPackRecipes.contains(key);
    }

    @Override
    public boolean isCustomRecipe(Key key) {
        return this.byId.containsKey(key);
    }

    @Override
    public Optional<Recipe<T>> recipeById(Key key) {
        return Optional.ofNullable(this.byId.get(key));
    }

    @Override
    public List<Recipe<T>> recipesByType(RecipeType type) {
        return this.byType.getOrDefault((Object)type, List.of());
    }

    @Override
    public List<Recipe<T>> recipeByResult(Key result) {
        return this.byResult.getOrDefault(result, List.of());
    }

    @Override
    public List<Recipe<T>> recipeByIngredient(Key ingredient) {
        return this.byIngredient.getOrDefault(ingredient, List.of());
    }

    @Override
    @Nullable
    public Recipe<T> recipeByInput(RecipeType type, RecipeInput input) {
        List<Recipe<T>> recipes = this.byType.get((Object)type);
        if (recipes == null) {
            return null;
        }
        for (Recipe<T> recipe : recipes) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    @Nullable
    public Recipe<T> recipeByInput(RecipeType type, RecipeInput input, Key lastRecipe) {
        Recipe<T> last;
        if (lastRecipe != null && (last = this.byId.get(lastRecipe)) != null && last.matches(input)) {
            return last;
        }
        return this.recipeByInput(type, input);
    }

    protected boolean registerInternalRecipe(Key id, Recipe<T> recipe) {
        if (this.byId.containsKey(id)) {
            return false;
        }
        this.byType.computeIfAbsent(recipe.type(), k -> new ArrayList()).add(recipe);
        this.byId.put(id, recipe);
        if (recipe instanceof AbstractedFixedResultRecipe) {
            AbstractedFixedResultRecipe fixedResult = (AbstractedFixedResultRecipe)recipe;
            this.byResult.computeIfAbsent(fixedResult.result().item().id(), k -> new ArrayList()).add(recipe);
        }
        if (recipe.canBeSearchedByIngredients()) {
            HashSet<Key> usedKeys = new HashSet<Key>();
            for (Ingredient<T> ingredient : recipe.ingredientsInUse()) {
                for (UniqueKey holder : ingredient.items()) {
                    Key key = holder.key();
                    if (!usedKeys.add(key)) continue;
                    this.byIngredient.computeIfAbsent(key, k -> new ArrayList()).add(recipe);
                }
            }
        }
        return true;
    }

    protected abstract void unregisterPlatformRecipeMainThread(Key var1, boolean var2);

    protected abstract void registerPlatformRecipeMainThread(Recipe<T> var1);

    public class RecipeParser
    extends IdSectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"recipes", "recipe"};

        @Override
        public int loadingSequence() {
            return 90;
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public void parseSection(Pack pack, Path path, String node, Key id, Map<String, Object> section) {
            if (!Config.enableRecipeSystem()) {
                return;
            }
            if (AbstractRecipeManager.this.byId.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.recipe.duplicate", new String[0]);
            }
            Recipe recipe = RecipeSerializers.fromMap(id, section);
            try {
                AbstractRecipeManager.this.registerInternalRecipe(id, recipe);
            }
            catch (LocalizedResourceConfigException e) {
                throw e;
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Failed to register custom recipe " + String.valueOf(id), e);
            }
        }
    }
}

