/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe.network.modern.display;

import net.momirealms.craftengine.core.item.recipe.network.modern.display.FurnaceRecipeDisplay;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.RecipeDisplay;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.ShapedCraftingRecipeDisplay;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.ShapelessCraftingRecipeDisplay;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.SmithingRecipeDisplay;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.StonecutterRecipeDisplay;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;

public final class RecipeDisplayTypes {
    public static final Key CRAFTING_SHAPELESS = Key.of("crafting_shapeless");
    public static final Key CRAFTING_SHAPED = Key.of("crafting_shaped");
    public static final Key FURNACE = Key.of("furnace");
    public static final Key STONECUTTER = Key.of("stonecutter");
    public static final Key SMITHING = Key.of("smithing");

    private RecipeDisplayTypes() {
    }

    public static void init() {
    }

    public static void register(Key key, RecipeDisplay.Type type) {
        ((WritableRegistry)BuiltInRegistries.RECIPE_DISPLAY_TYPE).register(ResourceKey.create(Registries.RECIPE_DISPLAY_TYPE.location(), key), type);
    }

    static {
        RecipeDisplayTypes.register(CRAFTING_SHAPELESS, new RecipeDisplay.Type(ShapelessCraftingRecipeDisplay::read));
        RecipeDisplayTypes.register(CRAFTING_SHAPED, new RecipeDisplay.Type(ShapedCraftingRecipeDisplay::read));
        RecipeDisplayTypes.register(FURNACE, new RecipeDisplay.Type(FurnaceRecipeDisplay::read));
        RecipeDisplayTypes.register(STONECUTTER, new RecipeDisplay.Type(StonecutterRecipeDisplay::read));
        RecipeDisplayTypes.register(SMITHING, new RecipeDisplay.Type(SmithingRecipeDisplay::read));
    }
}

