/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.entry;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.momirealms.craftengine.core.loot.LootConditions;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.entry.AbstractLootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntry;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainerFactory;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainers;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.Position;

public class ExpLootEntryContainer<T>
extends AbstractLootEntryContainer<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final NumberProvider value;

    protected ExpLootEntryContainer(NumberProvider value, List<Condition<LootContext>> conditions) {
        super(conditions);
        this.value = value;
    }

    @Override
    public Key type() {
        return LootEntryContainers.EXP;
    }

    @Override
    public boolean expand(LootContext context, Consumer<LootEntry<T>> choiceConsumer) {
        if (super.test(context)) {
            context.getOptionalParameter(DirectContextParameters.POSITION).ifPresent(it -> it.world().dropExp((Position)it, this.value.getInt(context)));
            return true;
        }
        return false;
    }

    public static class Factory<A>
    implements LootEntryContainerFactory<A> {
        @Override
        public LootEntryContainer<A> create(Map<String, Object> arguments) {
            Object value = ResourceConfigUtils.requireNonNullOrThrow(arguments.get("count"), "warning.config.loot_table.entry.exp.missing_count");
            List<Condition<LootContext>> conditions = Optional.ofNullable(arguments.get("conditions")).map(it -> LootConditions.fromMapList((List)it)).orElse(Collections.emptyList());
            return new ExpLootEntryContainer(NumberProviders.fromObject(value), conditions);
        }
    }
}

