/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.function;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootConditions;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.function.AbstractLootConditionalFunction;
import net.momirealms.craftengine.core.loot.function.LootFunction;
import net.momirealms.craftengine.core.loot.function.LootFunctionFactory;
import net.momirealms.craftengine.core.loot.function.LootFunctions;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.Position;

public class DropExpFunction<T>
extends AbstractLootConditionalFunction<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final NumberProvider value;

    public DropExpFunction(NumberProvider value, List<Condition<LootContext>> predicates) {
        super(predicates);
        this.value = value;
    }

    @Override
    protected Item<T> applyInternal(Item<T> item, LootContext context) {
        context.getOptionalParameter(DirectContextParameters.POSITION).ifPresent(it -> it.world().dropExp((Position)it, this.value.getInt(context)));
        return item;
    }

    @Override
    public Key type() {
        return LootFunctions.DROP_EXP;
    }

    public static class Factory<T>
    implements LootFunctionFactory<T> {
        @Override
        public LootFunction<T> create(Map<String, Object> arguments) {
            Object value = ResourceConfigUtils.requireNonNullOrThrow(arguments.get("count"), "warning.config.loot_table.function.drop_exp.missing_count");
            List<Condition<LootContext>> conditions = Optional.ofNullable(arguments.get("conditions")).map(it -> LootConditions.fromMapList((List)it)).orElse(Collections.emptyList());
            return new DropExpFunction(NumberProviders.fromObject(value), conditions);
        }
    }
}

