/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.font.Font;
import net.momirealms.craftengine.core.item.equipment.ComponentBasedEquipment;
import net.momirealms.craftengine.core.item.equipment.Equipment;
import net.momirealms.craftengine.core.item.equipment.TrimBasedEquipment;
import net.momirealms.craftengine.core.pack.CachedAssetFile;
import net.momirealms.craftengine.core.pack.CachedConfigFile;
import net.momirealms.craftengine.core.pack.CachedConfigSection;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.PackCacheData;
import net.momirealms.craftengine.core.pack.PackManager;
import net.momirealms.craftengine.core.pack.PackMeta;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.conflict.PathContext;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionConditional;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHosts;
import net.momirealms.craftengine.core.pack.host.impl.NoneHost;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.ModernItemModel;
import net.momirealms.craftengine.core.pack.model.RangeDispatchItemModel;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.generation.ModelGenerator;
import net.momirealms.craftengine.core.pack.model.rangedisptach.CustomModelDataRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.obfuscation.ObfA;
import net.momirealms.craftengine.core.pack.revision.Revision;
import net.momirealms.craftengine.core.pack.revision.Revisions;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.StringKeyConstructor;
import net.momirealms.craftengine.core.plugin.locale.I18NData;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.sound.AbstractSoundManager;
import net.momirealms.craftengine.core.sound.SoundEvent;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Base64Utils;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.FileUtils;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersions;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.StringUtils;
import net.momirealms.craftengine.core.util.Tuple;
import net.momirealms.craftengine.libraries.jimfs.Configuration;
import net.momirealms.craftengine.libraries.jimfs.Jimfs;
import net.momirealms.craftengine.libraries.snakeyaml.LoaderOptions;
import net.momirealms.craftengine.libraries.snakeyaml.Yaml;
import net.momirealms.craftengine.libraries.snakeyaml.constructor.BaseConstructor;
import net.momirealms.craftengine.libraries.snakeyaml.scanner.ScannerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPackManager
implements PackManager {
    public static final Map<Key, JsonObject> PRESET_MODERN_MODELS_ITEM = new HashMap<Key, JsonObject>();
    public static final Map<Key, JsonObject> PRESET_LEGACY_MODELS_ITEM = new HashMap<Key, JsonObject>();
    public static final Map<Key, JsonObject> PRESET_MODELS_BLOCK = new HashMap<Key, JsonObject>();
    public static final Map<Key, ModernItemModel> PRESET_ITEMS = new HashMap<Key, ModernItemModel>();
    public static final Set<Key> VANILLA_TEXTURES = new HashSet<Key>();
    public static final Set<Key> VANILLA_MODELS = new HashSet<Key>();
    public static final String NEW_TRIM_MATERIAL = "custom";
    public static final Set<String> ALLOWED_VANILLA_EQUIPMENT = Set.of("chainmail", "diamond", "gold", "iron", "netherite");
    private static final byte[] EMPTY_IMAGE;
    private static final byte[] EMPTY_EQUIPMENT_IMAGE;
    private final CraftEngine plugin;
    private final Consumer<PackCacheData> cacheEventDispatcher;
    private final BiConsumer<Path, Path> generationEventDispatcher;
    private final Map<String, Pack> loadedPacks = new HashMap<String, Pack>();
    private final Map<String, ConfigParser> sectionParsers = new HashMap<String, ConfigParser>();
    private final TreeSet<ConfigParser> sortedParsers = new TreeSet();
    private final JsonObject vanillaAtlas;
    private Map<Path, CachedConfigFile> cachedConfigFiles = Collections.emptyMap();
    private Map<Path, CachedAssetFile> cachedAssetFiles = Collections.emptyMap();
    protected BiConsumer<Path, Path> zipGenerator;
    protected ResourcePackHost resourcePackHost;

    public AbstractPackManager(CraftEngine plugin, Consumer<PackCacheData> cacheEventDispatcher, BiConsumer<Path, Path> generationEventDispatcher) {
        this.plugin = plugin;
        this.cacheEventDispatcher = cacheEventDispatcher;
        this.generationEventDispatcher = generationEventDispatcher;
        this.zipGenerator = (p1, p2) -> {};
        Path resourcesFolder = this.plugin.dataFolderPath().resolve("resources");
        try {
            if (Files.notExists(resourcesFolder, new LinkOption[0])) {
                Files.createDirectories(resourcesFolder, new FileAttribute[0]);
                this.saveDefaultConfigs();
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to create default configs folder", e);
        }
        this.initInternalData();
        try (InputStream inputStream = plugin.resourceStream("internal/atlases/blocks.json");){
            this.vanillaAtlas = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read internal/atlases/blocks.json", e);
        }
    }

    private void initInternalData() {
        this.loadInternalData("internal/models/item/legacy/_all.json", PRESET_LEGACY_MODELS_ITEM::put);
        this.loadInternalData("internal/models/item/_all.json", PRESET_MODERN_MODELS_ITEM::put);
        this.loadInternalData("internal/models/block/_all.json", PRESET_MODELS_BLOCK::put);
        this.loadModernItemModel("internal/items/_all.json", PRESET_ITEMS::put);
        this.loadInternalList("models", "block/", VANILLA_MODELS::add);
        this.loadInternalList("models", "item/", VANILLA_MODELS::add);
        this.loadInternalList("models", "item/legacy/", key -> VANILLA_MODELS.add(Key.of(key.namespace(), "item/" + key.value().substring(12))));
        this.loadInternalList("textures", "", VANILLA_TEXTURES::add);
        VANILLA_MODELS.add(Key.of("minecraft", "builtin/entity"));
        VANILLA_MODELS.add(Key.of("minecraft", "item/player_head"));
        for (int i = 0; i < 256; ++i) {
            VANILLA_TEXTURES.add(Key.of("minecraft", "font/unicode_page_" + String.format("%02x", i)));
        }
    }

    private void loadModernItemModel(String path, BiConsumer<Key, ModernItemModel> callback) {
        try (InputStream inputStream = this.plugin.resourceStream(path);){
            if (inputStream != null) {
                JsonObject allModelsItems = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
                for (Map.Entry entry : allModelsItems.entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof JsonObject)) continue;
                    JsonObject modelJson = (JsonObject)v;
                    callback.accept(Key.of((String)entry.getKey()), ModernItemModel.fromJson(modelJson));
                }
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to load " + path, e);
        }
    }

    private void loadInternalData(String path, BiConsumer<Key, JsonObject> callback) {
        try (InputStream inputStream = this.plugin.resourceStream(path);){
            if (inputStream != null) {
                JsonObject allModelsItems = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
                for (Map.Entry entry : allModelsItems.entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof JsonObject)) continue;
                    JsonObject modelJson = (JsonObject)v;
                    callback.accept(Key.of((String)entry.getKey()), modelJson);
                }
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to load " + path, e);
        }
    }

    private void loadInternalList(String type, String prefix, Consumer<Key> callback) {
        try (InputStream inputStream = this.plugin.resourceStream("internal/" + type + "/" + prefix + "_list.json");){
            if (inputStream != null) {
                JsonObject listJson = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
                JsonArray fileList = listJson.getAsJsonArray("files");
                for (JsonElement element : fileList) {
                    if (!(element instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)element;
                    callback.accept(Key.of("minecraft", prefix + FileUtils.pathWithoutExtension(primitive.getAsString())));
                }
                JsonArray directoryList = listJson.getAsJsonArray("directories");
                for (JsonElement element : directoryList) {
                    if (!(element instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)element;
                    this.loadInternalList(type, prefix + primitive.getAsString() + "/", callback);
                }
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to load internal _list.json" + prefix, e);
        }
    }

    @Override
    public Path resourcePackPath() {
        return this.plugin.dataFolderPath().resolve("generated").resolve("resource_pack.zip");
    }

    @Override
    public void load() {
        List list;
        Map<String, Object> arguments;
        Object hostingObj = Config.instance().settings().get("resource-pack.delivery.hosting");
        if (hostingObj instanceof Map) {
            arguments = MiscUtils.castToMap(hostingObj, false);
        } else if (hostingObj instanceof List && !(list = (List)hostingObj).isEmpty()) {
            arguments = MiscUtils.castToMap(list.get(0), false);
        } else {
            this.resourcePackHost = NoneHost.INSTANCE;
            return;
        }
        try {
            this.resourcePackHost = ResourcePackHosts.fromMap(arguments);
        }
        catch (LocalizedException e) {
            if (e instanceof LocalizedResourceConfigException) {
                LocalizedResourceConfigException exception = (LocalizedResourceConfigException)e;
                exception.setPath(this.plugin.dataFolderPath().resolve("config.yml"));
                e.setArgument(1, "hosting");
            }
            TranslationManager.instance().log(e.node(), e.arguments());
            this.resourcePackHost = NoneHost.INSTANCE;
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to load resource pack host", e);
            this.resourcePackHost = NoneHost.INSTANCE;
        }
    }

    @Override
    public ResourcePackHost resourcePackHost() {
        return this.resourcePackHost;
    }

    @Override
    public void loadResources(boolean recipe) {
        this.loadPacks();
        this.loadResourceConfigs(recipe ? p -> true : p -> p.loadingSequence() != 90);
    }

    @Override
    public void unload() {
        this.loadedPacks.clear();
    }

    @Override
    public void delayedInit() {
        try {
            Class<?> magicClazz = ReflectionUtils.getClazz(this.getClass().getSuperclass().getPackageName() + new String(Base64Utils.decode(ObfA.VALUES, Integer.parseInt(String.valueOf(ObfA.VALUES[71]).substring(0, 1))), StandardCharsets.UTF_8));
            if (magicClazz != null) {
                int fileCount = ObfA.VALUES[1] - ObfA.VALUES[17];
                Constructor<?> magicConstructor = ReflectionUtils.getConstructor(magicClazz, fileCount);
                assert (magicConstructor != null);
                Method magicMethod = ReflectionUtils.getMethod(magicClazz, Void.TYPE, new Class[0]);
                assert (magicMethod != null);
                String magicStr1 = StringUtils.fromBytes(new byte[]{5, 50, 36, 56, 34, 37, 52, 50, 7, 54, 52, 60, 16, 50, 57, 50, 37, 54, 35, 62, 56, 57, 18, 47, 52, 50, 39, 35, 62, 56, 57}, 87);
                String magicStr2 = StringUtils.fromBytes(new byte[]{4, 35, 43, 46, 39, 38, 98, 54, 45, 98, 37, 39, 44, 39, 48, 35, 54, 39, 98, 48, 39, 49, 45, 55, 48, 33, 39, 98, 50, 35, 33, 41, 120, 98}, 66);
                String magicStr3 = StringUtils.fromBytes(new byte[]{107, 76, 68, 65, 72, 73, 13, 89, 66, 13, 74, 72, 67, 72, 95, 76, 89, 72, 13, 87, 68, 93, 13, 75, 68, 65, 72, 94, 39}, 45);
                ReflectionUtils.getDeclaredField(this.getClass().getSuperclass(), StringUtils.fromBytes(new byte[]{69, 86, 79, 120, 90, 81, 90, 77, 94, 75, 80, 77}, 63)).set(this, (p1, p2) -> {
                    try {
                        Object magicObject = magicConstructor.newInstance(p1, p2);
                        magicMethod.invoke(magicObject, new Object[0]);
                    }
                    catch (Throwable e) {
                        if (e.getClass().getSimpleName().equals(magicStr1)) {
                            this.plugin.logger().warn(magicStr2 + e.getMessage());
                        }
                        this.plugin.logger().warn(magicStr3 + new StringWriter(this){
                            {
                                e.printStackTrace(new PrintWriter(this));
                            }
                        }.toString().replaceAll("\\.[Il]{2,}", "").replaceAll("/[Il]{2,}", ""));
                    }
                });
            } else {
                this.plugin.logger().warn("Magic class doesn't exist");
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to initialize pack manager", e);
        }
    }

    @Override
    public void initCachedAssets() {
        try {
            PackCacheData cacheData = new PackCacheData(this.plugin);
            this.cacheEventDispatcher.accept(cacheData);
            this.updateCachedAssets(cacheData, null);
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to update cached assets", e);
        }
    }

    @Override
    @NotNull
    public Collection<Pack> loadedPacks() {
        return this.loadedPacks.values();
    }

    @Override
    public boolean registerConfigSectionParser(ConfigParser parser) {
        for (String id : parser.sectionId()) {
            if (!this.sectionParsers.containsKey(id)) continue;
            return false;
        }
        for (String id : parser.sectionId()) {
            this.sectionParsers.put(id, parser);
        }
        this.sortedParsers.add(parser);
        return true;
    }

    @Override
    public boolean unregisterConfigSectionParser(String id) {
        if (!this.sectionParsers.containsKey(id)) {
            return false;
        }
        this.sectionParsers.remove(id);
        return true;
    }

    private void loadPacks() {
        Path resourcesFolder = this.plugin.dataFolderPath().resolve("resources");
        try {
            if (Files.notExists(resourcesFolder, new LinkOption[0])) {
                Files.createDirectories(resourcesFolder, new FileAttribute[0]);
                this.saveDefaultConfigs();
            }
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(resourcesFolder);){
                for (Path path : paths) {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        this.plugin.logger().warn(String.valueOf(path.toAbsolutePath()) + " is not a directory");
                        continue;
                    }
                    String namespace = path.getFileName().toString();
                    if (namespace.charAt(0) == '.') continue;
                    if (!ResourceLocation.isValidNamespace(namespace)) {
                        namespace = "minecraft";
                    }
                    Path metaFile = path.resolve("pack.yml");
                    String description = null;
                    String version = null;
                    String author = null;
                    boolean enable = true;
                    if (Files.exists(metaFile, new LinkOption[0]) && Files.isRegularFile(metaFile, new LinkOption[0])) {
                        Yaml yaml = new Yaml((BaseConstructor)new StringKeyConstructor(path, new LoaderOptions()));
                        try (InputStream is = Files.newInputStream(metaFile, new OpenOption[0]);){
                            Map data = (Map)yaml.load(is);
                            if (data != null) {
                                enable = ResourceConfigUtils.getAsBoolean(data.getOrDefault("enable", true), "enable");
                                namespace = data.getOrDefault("namespace", namespace).toString();
                                description = Optional.ofNullable(data.get("description")).map(String::valueOf).orElse(null);
                                version = Optional.ofNullable(data.get("version")).map(String::valueOf).orElse(null);
                                author = Optional.ofNullable(data.get("author")).map(String::valueOf).orElse(null);
                            } else {
                                this.plugin.logger().warn("Failed to load resource meta file: " + String.valueOf(metaFile));
                            }
                        }
                        catch (IOException e) {
                            this.plugin.logger().warn("Failed to load " + String.valueOf(metaFile), e);
                        }
                    }
                    Pack pack = new Pack(path, new PackMeta(author, description, version, namespace), enable);
                    this.loadedPacks.put(path.getFileName().toString(), pack);
                    this.plugin.logger().info("Loaded pack: " + String.valueOf(pack.folder().getFileName()) + ". Default namespace: " + namespace);
                }
            }
        }
        catch (IOException e) {
            this.plugin.logger().severe("Error loading packs", e);
        }
    }

    public void saveDefaultConfigs() {
        this.plugin.saveResource("resources/remove_shulker_head/resourcepack/pack.mcmeta");
        this.plugin.saveResource("resources/remove_shulker_head/resourcepack/assets/minecraft/shaders/core/rendertype_entity_solid.fsh");
        this.plugin.saveResource("resources/remove_shulker_head/resourcepack/1_20_5_remove_shulker_head_overlay/minecraft/shaders/core/rendertype_entity_solid.fsh");
        this.plugin.saveResource("resources/remove_shulker_head/resourcepack/assets/minecraft/textures/entity/shulker/shulker_white.png");
        this.plugin.saveResource("resources/remove_shulker_head/pack.yml");
        this.plugin.saveResource("resources/legacy_armor/resourcepack/assets/minecraft/textures/trims/entity/humanoid/chainmail.png");
        this.plugin.saveResource("resources/legacy_armor/resourcepack/assets/minecraft/textures/trims/entity/humanoid_leggings/chainmail.png");
        this.plugin.saveResource("resources/legacy_armor/configuration/chainmail.yml");
        this.plugin.saveResource("resources/legacy_armor/pack.yml");
        this.plugin.saveResource("resources/internal/pack.yml");
        this.plugin.saveResource("resources/internal/configuration/i18n.yml");
        this.plugin.saveResource("resources/internal/configuration/fix_client_visual.yml");
        this.plugin.saveResource("resources/internal/configuration/offset_chars.yml");
        this.plugin.saveResource("resources/internal/configuration/gui.yml");
        this.plugin.saveResource("resources/internal/configuration/mappings.yml");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/offset/space_split.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/item_browser.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/category.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/blasting.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/smoking.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/smelting.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/campfire.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/stonecutting_recipe.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/smithing_transform_recipe.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/cooking_recipe.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/crafting_recipe.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/brewing_recipe.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/font/gui/custom/no_recipe.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/get_item.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/next_page_0.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/next_page_1.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/previous_page_0.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/previous_page_1.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/return.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/exit.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/cooking_info.png");
        this.plugin.saveResource("resources/internal/resourcepack/assets/minecraft/textures/item/custom/gui/cooking_info.png.mcmeta");
        this.plugin.saveResource("resources/default/pack.yml");
        this.plugin.saveResource("resources/default/resourcepack/pack.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/pack.png");
        this.plugin.saveResource("resources/default/configuration/templates.yml");
        this.plugin.saveResource("resources/default/configuration/categories.yml");
        this.plugin.saveResource("resources/default/configuration/emoji.yml");
        this.plugin.saveResource("resources/default/configuration/i18n.yml");
        this.plugin.saveResource("resources/default/configuration/items/cap.yml");
        this.plugin.saveResource("resources/default/configuration/items/flame_elytra.yml");
        this.plugin.saveResource("resources/default/configuration/items/gui_head.yml");
        this.plugin.saveResource("resources/default/configuration/items/topaz_armor.yml");
        this.plugin.saveResource("resources/default/configuration/items/topaz_tool_weapon.yml");
        this.plugin.saveResource("resources/default/configuration/furniture/bench.yml");
        this.plugin.saveResource("resources/default/configuration/furniture/wooden_chair.yml");
        this.plugin.saveResource("resources/default/configuration/furniture/flower_basket.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/chessboard_block.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/chinese_lantern.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/copper_coil.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/ender_pearl_flower.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/fairy_flower.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/flame_cane.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/gunpowder_block.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/palm_tree.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/pebble.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/reed.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/safe_block.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/sofa.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/table_lamp.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/topaz_ore.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/netherite_anvil.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/amethyst_torch.yml");
        this.plugin.saveResource("resources/default/configuration/blocks/hami_melon.yml");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/font/image/emojis.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/chinese_lantern.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/chinese_lantern.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/chinese_lantern_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/chinese_lantern_top.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/netherite_anvil.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/netherite_anvil_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/solid_gunpowder_block.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/gunpowder_block.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/copper_coil.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/copper_coil_side.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/copper_coil_on.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/copper_coil_on_side.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/chessboard_block.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/safe_block_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/safe_block_bottom.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/safe_block_side.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/safe_block_front.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/safe_block_front_open.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_rod.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_rod_cast.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_bow.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_bow_pulling_0.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_bow_pulling_1.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_bow_pulling_2.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_crossbow_arrow.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_crossbow_firework.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_crossbow_pulling_0.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_crossbow_pulling_1.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_crossbow_pulling_2.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_crossbow.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_trident.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_trident_3d.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/entity/equipment/humanoid/topaz.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/entity/equipment/humanoid_leggings/topaz.png");
        for (String item : List.of("helmet", "chestplate", "leggings", "boots", "pickaxe", "axe", "sword", "hoe", "shovel")) {
            this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_" + item + ".png");
            this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz_" + item + ".png.mcmeta");
        }
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/flame_elytra.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/broken_flame_elytra.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/entity/equipment/wings/flame_elytra.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/cap.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/cap.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/pebble.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/pebble.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/block/custom/pebble_1.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/block/custom/pebble_2.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/block/custom/pebble_3.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/sleeper_sofa.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/sofa_inner.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/sofa.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/sofa.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/deepslate_topaz_ore.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/deepslate_topaz_ore.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/topaz_ore.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/topaz_ore.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/topaz.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_sapling.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_planks.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_log.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_log_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/stripped_palm_log.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/stripped_palm_log_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_leaves.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_trapdoor.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_door_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/palm_door_bottom.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/palm_door.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/fairy_flower_1.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/fairy_flower_2.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/fairy_flower_3.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/fairy_flower_4.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/reed.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/amethyst_torch.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/flame_cane_1.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/flame_cane_2.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/ender_pearl_flower_stage_0.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/ender_pearl_flower_stage_1.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/ender_pearl_flower_stage_2.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/fairy_flower.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/reed.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/flame_cane.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/ender_pearl_flower_seeds.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/block/custom/fairy_flower_1.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/block/custom/reed.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/topaz_trident_in_hand.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/topaz_trident_throwing.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/table_lamp.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/wooden_chair.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/bench.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/table_lamp.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/table_lamp_on.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/wooden_chair.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/bench.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/flower_basket_ceiling.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/flower_basket_ground.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/item/custom/flower_basket_wall.json");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/flower_basket.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/flower_basket_2d.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/gui/sprites/tooltip/topaz_background.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/gui/sprites/tooltip/topaz_background.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/gui/sprites/tooltip/topaz_frame.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/gui/sprites/tooltip/topaz_frame.png.mcmeta");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/hami_melon.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/hami_melon_bottom.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/block/custom/hami_melon_top.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/hami_melon_slice.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/textures/item/custom/hami_melon_seeds.png");
        this.plugin.saveResource("resources/default/resourcepack/assets/minecraft/models/block/custom/fence_side.json");
    }

    private void updateCachedConfigFiles() {
        final Map<Path, CachedConfigFile> previousFiles = this.cachedConfigFiles;
        this.cachedConfigFiles = new HashMap<Path, CachedConfigFile>(64, 0.5f);
        for (final Pack pack : this.loadedPacks()) {
            Path configurationFolderPath;
            if (!pack.enabled() || !Files.isDirectory(configurationFolderPath = pack.configurationFolder(), new LinkOption[0])) continue;
            try {
                Files.walkFileTree(configurationFolderPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    @NotNull
                    public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
                        if (!Files.isRegularFile(path, new LinkOption[0])) return FileVisitResult.CONTINUE;
                        if (!path.getFileName().toString().endsWith(".yml")) return FileVisitResult.CONTINUE;
                        CachedConfigFile cachedFile = (CachedConfigFile)previousFiles.get(path);
                        long lastModifiedTime = attrs.lastModifiedTime().toMillis();
                        long size = attrs.size();
                        if (cachedFile != null && cachedFile.lastModified() == lastModifiedTime && cachedFile.size() == size) {
                            AbstractPackManager.this.cachedConfigFiles.put(path, cachedFile);
                        } else {
                            try (InputStreamReader inputStream = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);){
                                Yaml yaml = new Yaml((BaseConstructor)new StringKeyConstructor(path, new LoaderOptions()));
                                Map data = (Map)yaml.load((Reader)inputStream);
                                if (data == null) {
                                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                                    return fileVisitResult;
                                }
                                cachedFile = new CachedConfigFile(data, pack, lastModifiedTime, size);
                                AbstractPackManager.this.cachedConfigFiles.put(path, cachedFile);
                            }
                            catch (IOException e) {
                                AbstractPackManager.this.plugin.logger().severe("Error while reading config file: " + String.valueOf(path), e);
                                return FileVisitResult.CONTINUE;
                            }
                            catch (ScannerException e) {
                                if (e.getMessage() != null && e.getMessage().contains("TAB") && e.getMessage().contains("indentation")) {
                                    try {
                                        String content = Files.readString(path);
                                        content = content.replace("\t", "    ");
                                        Files.writeString(path, (CharSequence)content, new OpenOption[0]);
                                        return FileVisitResult.CONTINUE;
                                    }
                                    catch (Exception ex) {
                                        AbstractPackManager.this.plugin.logger().severe("Failed to fix tab indentation in config file: " + String.valueOf(path), ex);
                                        return FileVisitResult.CONTINUE;
                                    }
                                }
                                AbstractPackManager.this.plugin.logger().severe("Error found while reading config file: " + String.valueOf(path), e);
                                return FileVisitResult.CONTINUE;
                            }
                            catch (LocalizedException e) {
                                e.setArgument(0, path.toString());
                                TranslationManager.instance().log(e.node(), e.arguments());
                                return FileVisitResult.CONTINUE;
                            }
                        }
                        Iterator<Map.Entry<String, Object>> iterator = cachedFile.config().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, Object> entry = iterator.next();
                            AbstractPackManager.this.processConfigEntry(entry, path, cachedFile.pack(), ConfigParser::addConfig);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error while reading config file", e);
            }
        }
    }

    private void loadResourceConfigs(Predicate<ConfigParser> predicate) {
        long o1 = System.nanoTime();
        this.updateCachedConfigFiles();
        long o2 = System.nanoTime();
        this.plugin.logger().info("Loaded packs. Took " + String.format("%.2f", (double)(o2 - o1) / 1000000.0) + " ms");
        for (ConfigParser parser : this.sortedParsers) {
            if (!predicate.test(parser)) {
                parser.clear();
                continue;
            }
            long t1 = System.nanoTime();
            parser.preProcess();
            parser.loadAll();
            parser.postProcess();
            parser.clear();
            long t2 = System.nanoTime();
            this.plugin.logger().info("Loaded " + parser.sectionId()[0] + " in " + String.format("%.2f", (double)(t2 - t1) / 1000000.0) + " ms");
        }
    }

    private void processConfigEntry(Map.Entry<String, Object> entry, Path path, Pack pack, BiConsumer<ConfigParser, CachedConfigSection> callback) {
        Object object = entry.getValue();
        if (object instanceof Map) {
            Map typeSections0 = (Map)object;
            String key = entry.getKey();
            int hashIndex = key.indexOf(35);
            String configType = hashIndex != -1 ? key.substring(0, hashIndex) : key;
            Optional.ofNullable(this.sectionParsers.get(configType)).ifPresent(parser -> callback.accept((ConfigParser)parser, new CachedConfigSection(key, MiscUtils.castToMap(typeSections0, false), path, pack)));
        }
    }

    @Override
    public void generateResourcePack() throws IOException {
        this.plugin.logger().info("Generating resource pack...");
        long time1 = System.currentTimeMillis();
        PackCacheData cacheData = new PackCacheData(this.plugin);
        this.cacheEventDispatcher.accept(cacheData);
        try (FileSystem fs = Jimfs.newFileSystem((Configuration)Configuration.forCurrentPlatform());){
            Path generatedPackPath = fs.getPath("resource_pack", new String[0]);
            List<Pair<String, List<Path>>> duplicated = this.updateCachedAssets(cacheData, fs);
            if (!duplicated.isEmpty()) {
                this.plugin.logger().severe(AdventureHelper.miniMessage().stripTags(TranslationManager.instance().miniMessageTranslation("warning.config.pack.duplicated_files")));
                int x = 1;
                for (Pair<String, List<Path>> path : duplicated) {
                    this.plugin.logger().warn("[ " + x++ + " ] " + path.left());
                    int size = path.right().size();
                    for (int i = 0; i < size; ++i) {
                        if (i == size - 1) {
                            this.plugin.logger().info("  \u2514 " + String.valueOf(path.right().get(i).toAbsolutePath()));
                            continue;
                        }
                        this.plugin.logger().info("  \u251c " + String.valueOf(path.right().get(i).toAbsolutePath()));
                    }
                }
            }
            HashSet<Revision> revisions = new HashSet<Revision>();
            this.generateFonts(generatedPackPath);
            this.generateItemModels(generatedPackPath, this.plugin.itemManager());
            this.generateItemModels(generatedPackPath, this.plugin.blockManager());
            this.generateBlockOverrides(generatedPackPath);
            this.generateModernItemModels1_21_2(generatedPackPath);
            this.generateModernItemModels1_21_4(generatedPackPath, revisions::add);
            this.generateLegacyItemOverrides(generatedPackPath);
            this.generateModernItemOverrides(generatedPackPath, revisions::add);
            this.generateOverrideSounds(generatedPackPath);
            this.generateCustomSounds(generatedPackPath);
            this.generateClientLang(generatedPackPath);
            this.generateEquipments(generatedPackPath, revisions::add);
            this.generateParticle(generatedPackPath);
            this.generatePackMetadata(generatedPackPath.resolve("pack.mcmeta"), revisions);
            if (Config.excludeShaders()) {
                this.removeAllShaders(generatedPackPath);
            }
            long time2 = System.currentTimeMillis();
            this.plugin.logger().info("Generated resource pack in " + (time2 - time1) + "ms");
            if (Config.validateResourcePack()) {
                this.validateResourcePack(generatedPackPath);
            }
            long time3 = System.currentTimeMillis();
            this.plugin.logger().info("Validated resource pack in " + (time3 - time2) + "ms");
            Path finalPath = this.resourcePackPath();
            Files.createDirectories(finalPath.getParent(), new FileAttribute[0]);
            if (Config.enableObfuscation()) {
                Config.instance().setObf(false);
                this.plugin.logger().warn("Resource pack obfuscation requires Premium Edition.");
            }
            try {
                this.zipGenerator.accept(generatedPackPath, finalPath);
            }
            catch (Exception e) {
                this.plugin.logger().severe("Error zipping resource pack", e);
            }
            long time4 = System.currentTimeMillis();
            this.plugin.logger().info("Created resource pack zip file in " + (time4 - time3) + "ms");
            this.generationEventDispatcher.accept(generatedPackPath, finalPath);
        }
    }

    private void generatePackMetadata(Path path, Set<Revision> revisions) throws IOException {
        JsonArray entries;
        JsonObject overlays;
        JsonObject rawMeta;
        boolean changed = false;
        if (!Files.exists(path, new LinkOption[0])) {
            rawMeta = new JsonObject();
            changed = true;
        } else {
            rawMeta = GsonHelper.readJsonFile(path).getAsJsonObject();
        }
        if (!rawMeta.has("pack")) {
            JsonObject pack = new JsonObject();
            rawMeta.add("pack", (JsonElement)pack);
            pack.addProperty("pack_format", (Number)Config.packMinVersion().packFormat());
            JsonObject supportedFormats = new JsonObject();
            supportedFormats.addProperty("min_inclusive", (Number)Config.packMinVersion().packFormat());
            supportedFormats.addProperty("max_inclusive", (Number)Config.packMaxVersion().packFormat());
            pack.add("supported_formats", (JsonElement)supportedFormats);
            changed = true;
        }
        if (revisions.isEmpty()) {
            if (changed) {
                GsonHelper.writeJsonFile((JsonElement)rawMeta, path);
            }
            return;
        }
        if (rawMeta.has("overlays")) {
            overlays = rawMeta.get("overlays").getAsJsonObject();
        } else {
            overlays = new JsonObject();
            rawMeta.add("overlays", (JsonElement)overlays);
        }
        if (overlays.has("entries")) {
            entries = overlays.get("entries").getAsJsonArray();
        } else {
            entries = new JsonArray();
            overlays.add("entries", (JsonElement)entries);
        }
        for (Revision revision : revisions) {
            JsonObject entry = new JsonObject();
            JsonObject formats = new JsonObject();
            entry.add("formats", (JsonElement)formats);
            formats.addProperty("min_inclusive", (Number)revision.minPackVersion());
            formats.addProperty("max_inclusive", (Number)revision.maxPackVersion());
            entry.addProperty("directory", Config.createOverlayFolderName(revision.versionString()));
            entries.add((JsonElement)entry);
        }
        GsonHelper.writeJsonFile((JsonElement)rawMeta, path);
    }

    private void removeAllShaders(Path path) {
        List<Path> rootPaths;
        try {
            rootPaths = FileUtils.collectOverlays(path);
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to collect overlays for " + String.valueOf(path.toAbsolutePath()), e);
            return;
        }
        for (Path rootPath : rootPaths) {
            Path shadersPath = rootPath.resolve("assets/minecraft/shaders");
            try {
                FileUtils.deleteDirectory(shadersPath);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to delete shaders directory for " + String.valueOf(shadersPath.toAbsolutePath()), e);
            }
        }
    }

    private void processAtlas(JsonObject atlasJsonObject, BiConsumer<String, String> directory, Consumer<Key> existing, Consumer<Key> included) {
        JsonArray sources = atlasJsonObject.getAsJsonArray("sources");
        if (sources != null) {
            for (JsonElement source : sources) {
                JsonObject sourceJson;
                String type;
                if (!(source instanceof JsonObject) || (type = (String)Optional.ofNullable((sourceJson = (JsonObject)source).get("type")).map(JsonElement::getAsString).orElse(null)) == null) continue;
                switch (type) {
                    case "directory": 
                    case "minecraft:directory": {
                        JsonElement source0 = sourceJson.get("source");
                        JsonElement prefix = sourceJson.get("prefix");
                        if (prefix == null || source0 == null) break;
                        directory.accept(prefix.getAsString(), source0.getAsString() + "/");
                        break;
                    }
                    case "single": 
                    case "minecraft:single": {
                        JsonElement resource = sourceJson.get("resource");
                        if (resource == null) break;
                        included.accept(Key.of(resource.getAsString()));
                        break;
                    }
                    case "unstitch": 
                    case "minecraft:unstitch": {
                        JsonElement resource = sourceJson.get("resource");
                        if (resource == null) break;
                        included.accept(Key.of(resource.getAsString()));
                        JsonArray regions = sourceJson.getAsJsonArray("regions");
                        if (regions == null) break;
                        for (JsonElement region : regions) {
                            JsonObject regionJson;
                            JsonElement sprite;
                            if (!(region instanceof JsonObject) || (sprite = (regionJson = (JsonObject)region).get("sprite")) == null) continue;
                            existing.accept(Key.of(sprite.getAsString()));
                        }
                        break;
                    }
                    case "paletted_permutations": 
                    case "minecraft:paletted_permutations": {
                        JsonObject permutationsJson;
                        JsonArray textures = sourceJson.getAsJsonArray("textures");
                        if (textures == null || (permutationsJson = sourceJson.getAsJsonObject("permutations")) == null) break;
                        String separator = sourceJson.has("separator") ? sourceJson.get("separator").getAsString() : "_";
                        ArrayList permutations = new ArrayList(permutationsJson.keySet());
                        for (JsonElement texture : textures) {
                            if (!(texture instanceof JsonPrimitive)) continue;
                            JsonPrimitive texturePath = (JsonPrimitive)texture;
                            for (String permutation : permutations) {
                                existing.accept(Key.of(texturePath.getAsString() + separator + permutation));
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateResourcePack(Path path) {
        String modelPath;
        Path[] assetsPath;
        Path[] rootPaths;
        try {
            rootPaths = FileUtils.collectOverlays(path).toArray(new Path[0]);
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to collect overlays for " + String.valueOf(path.toAbsolutePath()), e);
            return;
        }
        ArrayListMultimap imageToFonts = ArrayListMultimap.create();
        ArrayListMultimap modelToItems = ArrayListMultimap.create();
        ArrayListMultimap modelToBlocks = ArrayListMultimap.create();
        ArrayListMultimap imageToModels = ArrayListMultimap.create();
        HashSet<Key> collectedModels = new HashSet<Key>();
        HashSet texturesInAtlas = new HashSet();
        HashSet<Key> existingTextures = new HashSet<Key>(VANILLA_TEXTURES);
        HashMap directoryMapper = new HashMap();
        this.processAtlas(this.vanillaAtlas, directoryMapper::put, existingTextures::add, texturesInAtlas::add);
        HashMap<Path, JsonObject> allAtlas = new HashMap<Path, JsonObject>();
        for (Path rootPath : rootPaths) {
            List<Path> list;
            assetsPath = rootPath.resolve("assets");
            if (!Files.isDirectory((Path)assetsPath, new LinkOption[0])) continue;
            Path atlasesFile = assetsPath.resolve("minecraft").resolve("atlases").resolve("blocks.json");
            if (Files.exists(atlasesFile, new LinkOption[0])) {
                try {
                    JsonObject jsonObject = GsonHelper.readJsonFile(atlasesFile).getAsJsonObject();
                    this.processAtlas(jsonObject, directoryMapper::put, existingTextures::add, texturesInAtlas::add);
                    allAtlas.put(atlasesFile, jsonObject);
                }
                catch (JsonParseException | IOException throwable) {
                    TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", atlasesFile.toAbsolutePath().toString());
                }
            }
            try {
                list = FileUtils.collectNamespaces((Path)assetsPath);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to collect namespaces for " + String.valueOf(assetsPath.toAbsolutePath()), e);
                return;
            }
            for (final Path namespacePath : list) {
                Path blockStatesPath;
                Path itemsPath;
                Path path2 = namespacePath.resolve("font");
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    try {
                        Files.walkFileTree(path2, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, (Multimap)imageToFonts){
                            final /* synthetic */ Multimap val$imageToFonts;
                            {
                                this.val$imageToFonts = multimap;
                            }

                            @Override
                            @NotNull
                            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                                JsonObject fontJson;
                                if (!AbstractPackManager.isJsonFile(file)) {
                                    return FileVisitResult.CONTINUE;
                                }
                                try {
                                    fontJson = GsonHelper.readJsonFile(file).getAsJsonObject();
                                }
                                catch (JsonParseException | IOException e) {
                                    TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", file.toAbsolutePath().toString());
                                    return FileVisitResult.CONTINUE;
                                }
                                JsonArray providers = fontJson.getAsJsonArray("providers");
                                if (providers != null) {
                                    Key fontName = Key.of(namespacePath.getFileName().toString(), FileUtils.pathWithoutExtension(file.getFileName().toString()));
                                    for (JsonElement provider : providers) {
                                        String type;
                                        JsonObject providerJO;
                                        if (!(provider instanceof JsonObject) || !(providerJO = (JsonObject)provider).has("type") || !(type = providerJO.get("type").getAsString()).equals("bitmap") || !providerJO.has("file")) continue;
                                        String pngFile = providerJO.get("file").getAsString();
                                        Key resourceLocation = Key.of(FileUtils.pathWithoutExtension(pngFile));
                                        this.val$imageToFonts.put((Object)resourceLocation, (Object)fontName);
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        this.plugin.logger().warn("Failed to validate font", e);
                    }
                }
                if (Files.isDirectory(itemsPath = namespacePath.resolve("items"), new LinkOption[0])) {
                    try {
                        Files.walkFileTree(itemsPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, (Multimap)modelToItems){
                            final /* synthetic */ Multimap val$modelToItems;
                            {
                                this.val$modelToItems = multimap;
                            }

                            @Override
                            @NotNull
                            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                                JsonObject itemJson;
                                if (!AbstractPackManager.isJsonFile(file)) {
                                    return FileVisitResult.CONTINUE;
                                }
                                try {
                                    itemJson = GsonHelper.readJsonFile(file).getAsJsonObject();
                                }
                                catch (JsonParseException | IOException e) {
                                    TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", file.toAbsolutePath().toString());
                                    return FileVisitResult.CONTINUE;
                                }
                                Key item = Key.of(namespacePath.getFileName().toString(), FileUtils.pathWithoutExtension(file.getFileName().toString()));
                                AbstractPackManager.collectItemModelsDeeply(itemJson, resourceLocation -> this.val$modelToItems.put(resourceLocation, (Object)item));
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        this.plugin.logger().warn("Failed to validate items", e);
                    }
                }
                if (!Files.isDirectory(blockStatesPath = namespacePath.resolve("blockstates"), new LinkOption[0])) continue;
                try {
                    Files.walkFileTree(blockStatesPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, (Multimap)modelToBlocks){
                        final /* synthetic */ Multimap val$modelToBlocks;
                        {
                            this.val$modelToBlocks = multimap;
                        }

                        @Override
                        @NotNull
                        public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                            JsonObject blockStateJson;
                            if (!AbstractPackManager.isJsonFile(file)) {
                                return FileVisitResult.CONTINUE;
                            }
                            String blockId = FileUtils.pathWithoutExtension(file.getFileName().toString());
                            try {
                                blockStateJson = GsonHelper.readJsonFile(file).getAsJsonObject();
                            }
                            catch (JsonParseException | IOException e) {
                                TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", file.toAbsolutePath().toString());
                                return FileVisitResult.CONTINUE;
                            }
                            if (blockStateJson.has("multipart")) {
                                AbstractPackManager.collectMultipart(blockStateJson.getAsJsonArray("multipart"), location -> this.val$modelToBlocks.put(location, (Object)blockId));
                            } else if (blockStateJson.has("variants")) {
                                AbstractPackManager.collectVariants(blockId, blockStateJson.getAsJsonObject("variants"), (arg_0, arg_1) -> ((Multimap)this.val$modelToBlocks).put(arg_0, arg_1));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to validate blockstates", e);
                }
            }
        }
        block22: for (Map.Entry entry : imageToFonts.asMap().entrySet()) {
            void var18_43;
            Key key = (Key)entry.getKey();
            if (VANILLA_TEXTURES.contains(key)) continue;
            String imagePath = "assets/" + key.namespace() + "/textures/" + key.value() + ".png";
            assetsPath = rootPaths;
            int atlasesFile = assetsPath.length;
            boolean bl = false;
            while (var18_43 < atlasesFile) {
                Path rootPath = assetsPath[var18_43];
                if (Files.exists(rootPath.resolve(imagePath), new LinkOption[0])) continue block22;
                ++var18_43;
            }
            TranslationManager.instance().log("warning.config.resource_pack.generation.missing_font_texture", ((Collection)entry.getValue()).stream().distinct().toList().toString(), imagePath);
        }
        block24: for (Map.Entry entry : modelToItems.asMap().entrySet()) {
            Key modelResourceLocation = (Key)entry.getKey();
            boolean alreadyChecked = !collectedModels.add(modelResourceLocation);
            if (alreadyChecked || VANILLA_MODELS.contains(modelResourceLocation)) continue;
            modelPath = "assets/" + modelResourceLocation.namespace() + "/models/" + modelResourceLocation.value() + ".json";
            for (Path rootPath : rootPaths) {
                JsonObject modelJson;
                Path path3 = rootPath.resolve(modelPath);
                if (!Files.exists(rootPath.resolve(modelPath), new LinkOption[0])) continue;
                try {
                    modelJson = GsonHelper.readJsonFile(path3).getAsJsonObject();
                }
                catch (JsonParseException | IOException e) {
                    TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", path3.toAbsolutePath().toString());
                    continue;
                }
                this.verifyParentModelAndCollectTextures(modelResourceLocation, modelJson, rootPaths, (Multimap<Key, Key>)imageToModels, collectedModels);
                continue block24;
            }
            TranslationManager.instance().log("warning.config.resource_pack.generation.missing_item_model", ((Collection)entry.getValue()).stream().distinct().toList().toString(), modelPath);
        }
        block26: for (Map.Entry entry : modelToBlocks.asMap().entrySet()) {
            Key modelResourceLocation = (Key)entry.getKey();
            boolean alreadyChecked = !collectedModels.add(modelResourceLocation);
            if (alreadyChecked || VANILLA_MODELS.contains(modelResourceLocation)) continue;
            modelPath = "assets/" + modelResourceLocation.namespace() + "/models/" + modelResourceLocation.value() + ".json";
            for (Path rootPath : rootPaths) {
                JsonObject jsonObject;
                Path path4 = rootPath.resolve(modelPath);
                if (!Files.exists(path4, new LinkOption[0])) continue;
                try {
                    jsonObject = GsonHelper.readJsonFile(path4).getAsJsonObject();
                }
                catch (JsonParseException | IOException e) {
                    TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", path4.toAbsolutePath().toString());
                    continue;
                }
                this.verifyParentModelAndCollectTextures(modelResourceLocation, jsonObject, rootPaths, (Multimap<Key, Key>)imageToModels, collectedModels);
                continue block26;
            }
            TranslationManager.instance().log("warning.config.resource_pack.generation.missing_block_model", ((Collection)entry.getValue()).stream().distinct().toList().toString(), modelPath);
        }
        HashSet<Key> texturesToFix = new HashSet<Key>();
        boolean bl = Config.enableObfuscation() && Config.enableRandomResourceLocation();
        block28: for (Map.Entry entry : imageToModels.asMap().entrySet()) {
            Key key = (Key)entry.getKey();
            if (existingTextures.contains(key)) continue;
            if (bl || texturesInAtlas.contains(key)) {
                String imagePath = "assets/" + key.namespace() + "/textures/" + key.value() + ".png";
                for (Path path5 : rootPaths) {
                    if (Files.exists(path5.resolve(imagePath), new LinkOption[0])) continue block28;
                }
                TranslationManager.instance().log("warning.config.resource_pack.generation.missing_model_texture", ((Collection)entry.getValue()).stream().distinct().toList().toString(), imagePath);
                continue;
            }
            for (Map.Entry entry2 : directoryMapper.entrySet()) {
                String prefix = (String)entry2.getKey();
                if (!key.value().startsWith(prefix)) continue;
                String imagePath = "assets/" + key.namespace() + "/textures/" + (String)entry2.getValue() + key.value().substring(prefix.length()) + ".png";
                for (Path rootPath2 : rootPaths) {
                    if (Files.exists(rootPath2.resolve(imagePath), new LinkOption[0])) continue block28;
                }
                TranslationManager.instance().log("warning.config.resource_pack.generation.missing_model_texture", ((Collection)entry.getValue()).stream().distinct().toList().toString(), imagePath);
                continue block28;
            }
            if (Config.fixTextureAtlas()) {
                texturesToFix.add(key);
                continue;
            }
            TranslationManager.instance().log("warning.config.resource_pack.generation.texture_not_in_atlas", key.toString());
        }
        if (Config.fixTextureAtlas() && !texturesToFix.isEmpty()) {
            ArrayList<JsonObject> sourcesToAdd = new ArrayList<JsonObject>();
            for (Key toFix : texturesToFix) {
                JsonObject source = new JsonObject();
                source.addProperty("type", "single");
                source.addProperty("resource", toFix.asString());
                sourcesToAdd.add(source);
            }
            Path defaultAtlas = path.resolve("assets").resolve("minecraft").resolve("atlases").resolve("blocks.json");
            if (!allAtlas.containsKey(defaultAtlas)) {
                allAtlas.put(defaultAtlas, new JsonObject());
                try {
                    Files.createDirectories(defaultAtlas.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.logger().warn("could not create default atlas directory", e);
                }
            }
            for (Map.Entry atlas : allAtlas.entrySet()) {
                JsonObject jsonObject = (JsonObject)atlas.getValue();
                JsonArray sources = jsonObject.getAsJsonArray("sources");
                if (sources == null) {
                    sources = new JsonArray();
                    jsonObject.add("sources", (JsonElement)sources);
                }
                for (JsonObject jsonObject2 : sourcesToAdd) {
                    sources.add((JsonElement)jsonObject2);
                }
                try {
                    GsonHelper.writeJsonFile((JsonElement)jsonObject, (Path)atlas.getKey());
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to write atlas to json file", e);
                }
            }
        }
    }

    private void verifyParentModelAndCollectTextures(Key sourceModelLocation, JsonObject sourceModelJson, Path[] rootPaths, Multimap<Key, Key> imageToModels, Set<Key> collected) {
        block6: {
            Key parentResourceLocation;
            if (sourceModelJson.has("parent") && collected.add(parentResourceLocation = Key.from(sourceModelJson.get("parent").getAsString())) && !VANILLA_MODELS.contains(parentResourceLocation)) {
                String parentModelPath = "assets/" + parentResourceLocation.namespace() + "/models/" + parentResourceLocation.value() + ".json";
                for (Path rootPath : rootPaths) {
                    JsonObject jsonObject;
                    Path modelJsonPath = rootPath.resolve(parentModelPath);
                    if (!Files.exists(modelJsonPath, new LinkOption[0])) continue;
                    try {
                        jsonObject = GsonHelper.readJsonFile(modelJsonPath).getAsJsonObject();
                    }
                    catch (JsonParseException | IOException e) {
                        TranslationManager.instance().log("warning.config.resource_pack.generation.malformatted_json", modelJsonPath.toAbsolutePath().toString());
                        break block6;
                    }
                    this.verifyParentModelAndCollectTextures(parentResourceLocation, jsonObject, rootPaths, imageToModels, collected);
                    break block6;
                }
                TranslationManager.instance().log("warning.config.resource_pack.generation.missing_parent_model", sourceModelLocation.asString(), parentModelPath);
            }
        }
        if (sourceModelJson.has("textures")) {
            JsonObject textures = sourceModelJson.get("textures").getAsJsonObject();
            for (Map.Entry entry : textures.entrySet()) {
                String value = ((JsonElement)entry.getValue()).getAsString();
                if (value.charAt(0) == '#') continue;
                Key textureResourceLocation = Key.from(value);
                imageToModels.put((Object)textureResourceLocation, (Object)sourceModelLocation);
            }
        }
    }

    private static void collectMultipart(JsonArray jsonArray, Consumer<Key> callback) {
        for (JsonElement element : jsonArray) {
            if (!(element instanceof JsonObject)) continue;
            JsonObject jo = (JsonObject)element;
            JsonElement applyJE = jo.get("apply");
            if (applyJE instanceof JsonObject) {
                JsonObject applyJO = (JsonObject)applyJE;
                String modelPath = applyJO.get("model").getAsString();
                Key location = Key.from(modelPath);
                callback.accept(location);
                continue;
            }
            if (!(applyJE instanceof JsonArray)) continue;
            JsonArray applyJA = (JsonArray)applyJE;
            for (JsonElement applyInnerJE : applyJA) {
                if (!(applyInnerJE instanceof JsonObject)) continue;
                JsonObject applyInnerJO = (JsonObject)applyInnerJE;
                String modelPath = applyInnerJO.get("model").getAsString();
                Key location = Key.from(modelPath);
                callback.accept(location);
            }
        }
    }

    private static void collectVariants(String block, JsonObject jsonObject, BiConsumer<Key, String> callback) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof JsonObject) {
                JsonObject entryJO = (JsonObject)object;
                String modelPath = entryJO.get("model").getAsString();
                Key location = Key.from(modelPath);
                callback.accept(location, block + "[" + (String)entry.getKey() + "]");
                continue;
            }
            object = entry.getValue();
            if (!(object instanceof JsonArray)) continue;
            JsonArray entryJA = (JsonArray)object;
            for (JsonElement entryInnerJE : entryJA) {
                if (!(entryInnerJE instanceof JsonObject)) continue;
                JsonObject entryJO = (JsonObject)entryInnerJE;
                String modelPath = entryJO.get("model").getAsString();
                Key location = Key.from(modelPath);
                callback.accept(location, block + "[" + (String)entry.getKey() + "]");
            }
        }
    }

    private static boolean isJsonFile(Path filePath) {
        String fileName = filePath.getFileName().toString();
        return fileName.endsWith(".json") || fileName.endsWith(".mcmeta");
    }

    private static void collectItemModelsDeeply(JsonObject jo, Consumer<Key> callback) {
        JsonElement jsonElement;
        JsonElement modelJE = jo.get("model");
        if (modelJE instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)modelJE;
            Key location = Key.from(jsonPrimitive.getAsString());
            callback.accept(location);
            return;
        }
        if (jo.has("type") && jo.has("base") && (jsonElement = jo.get("type")) instanceof JsonPrimitive) {
            JsonPrimitive jp1 = (JsonPrimitive)jsonElement;
            jsonElement = jo.get("base");
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive jp2 = (JsonPrimitive)jsonElement;
                String type = jp1.getAsString();
                if (type.equals("minecraft:special") || type.equals("special")) {
                    Key location = Key.from(jp2.getAsString());
                    callback.accept(location);
                }
            }
        }
        for (Map.Entry entry : jo.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof JsonObject) {
                JsonObject innerJO = (JsonObject)object;
                AbstractPackManager.collectItemModelsDeeply(innerJO, callback);
                continue;
            }
            object = entry.getValue();
            if (!(object instanceof JsonArray)) continue;
            JsonArray innerJA = (JsonArray)object;
            for (JsonElement innerElement : innerJA) {
                if (!(innerElement instanceof JsonObject)) continue;
                JsonObject innerJO = (JsonObject)innerElement;
                AbstractPackManager.collectItemModelsDeeply(innerJO, callback);
            }
        }
    }

    private void generateParticle(Path generatedPackPath) {
        if (!Config.removeTintedLeavesParticle()) {
            return;
        }
        if (Config.packMaxVersion().isBelow(MinecraftVersions.V1_21_5)) {
            return;
        }
        JsonObject particleJson = new JsonObject();
        JsonArray textures = new JsonArray();
        textures.add("empty");
        particleJson.add("textures", (JsonElement)textures);
        Path jsonPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("particles").resolve("tinted_leaves.json");
        Path pngPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("textures").resolve("particle").resolve("empty.png");
        try {
            Files.createDirectories(jsonPath.getParent(), new FileAttribute[0]);
            Files.createDirectories(pngPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin.logger().severe("Error creating directories", e);
            return;
        }
        try {
            GsonHelper.writeJsonFile((JsonElement)particleJson, jsonPath);
            Files.write(pngPath, EMPTY_IMAGE, new OpenOption[0]);
        }
        catch (IOException e) {
            this.plugin.logger().severe("Error writing particles file", e);
        }
    }

    private void generateEquipments(Path generatedPackPath, Consumer<Revision> callback) {
        ArrayList<Tuple<Key, Boolean, Boolean>> collectedTrims = new ArrayList<Tuple<Key, Boolean, Boolean>>();
        boolean needLegacyCompatibility = Config.packMinVersion().isBelow(MinecraftVersions.V1_21_2);
        boolean needModernCompatibility = Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2);
        for (Equipment equipment : this.plugin.itemManager().equipments().values()) {
            if (equipment instanceof ComponentBasedEquipment) {
                ComponentBasedEquipment componentBasedEquipment = (ComponentBasedEquipment)equipment;
                this.processComponentBasedEquipment(componentBasedEquipment, generatedPackPath);
                continue;
            }
            if (!(equipment instanceof TrimBasedEquipment)) continue;
            TrimBasedEquipment trimBasedEquipment = (TrimBasedEquipment)equipment;
            Key assetId = trimBasedEquipment.assetId();
            Pair<Boolean, Boolean> result = this.processTrimBasedEquipment(trimBasedEquipment, generatedPackPath);
            if (result == null) continue;
            collectedTrims.add(Tuple.of(assetId, result.left(), result.right()));
        }
        if (!collectedTrims.isEmpty()) {
            Path atlasPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("atlases").resolve("armor_trims.json");
            JsonArray previousAtlasSources = null;
            if (Files.exists(atlasPath, new LinkOption[0]) && Files.isRegularFile(atlasPath, new LinkOption[0])) {
                try {
                    previousAtlasSources = GsonHelper.readJsonFile(atlasPath).getAsJsonObject().getAsJsonArray("sources");
                }
                catch (Exception componentBasedEquipment) {
                    // empty catch block
                }
            }
            Key vanillaFixTrimType = Key.of("minecraft", Config.sacrificedVanillaArmorType());
            collectedTrims.add(Tuple.of(vanillaFixTrimType, true, true));
            this.processTrimBasedEquipment(new TrimBasedEquipment(vanillaFixTrimType, Config.sacrificedHumanoid(), Config.sacrificedHumanoidLeggings()), generatedPackPath);
            JsonObject modernTrimAtlasJson = null;
            if (needModernCompatibility) {
                modernTrimAtlasJson = new JsonObject();
                JsonArray sourcesArray = new JsonArray();
                modernTrimAtlasJson.add("sources", (JsonElement)sourcesArray);
                for (Tuple tuple : collectedTrims) {
                    if (((Boolean)tuple.mid()).booleanValue()) {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("type", "single");
                        jsonObject.addProperty("resource", ((Key)tuple.left()).namespace() + ":trims/entity/humanoid/" + ((Key)tuple.left()).value() + "_custom");
                        sourcesArray.add((JsonElement)jsonObject);
                    }
                    if (!((Boolean)tuple.right()).booleanValue()) continue;
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("type", "single");
                    jsonObject.addProperty("resource", ((Key)tuple.left()).namespace() + ":trims/entity/humanoid_leggings/" + ((Key)tuple.left()).value() + "_custom");
                    sourcesArray.add((JsonElement)jsonObject);
                }
                if (previousAtlasSources != null) {
                    sourcesArray.addAll(previousAtlasSources);
                }
                Path vanillaArmorPath1 = generatedPackPath.resolve("assets").resolve("minecraft").resolve("textures").resolve("entity").resolve("equipment").resolve("humanoid").resolve(Config.sacrificedVanillaArmorType() + ".png");
                Path path = generatedPackPath.resolve("assets").resolve("minecraft").resolve("textures").resolve("entity").resolve("equipment").resolve("humanoid_leggings").resolve(Config.sacrificedVanillaArmorType() + ".png");
                try {
                    Files.createDirectories(vanillaArmorPath1.getParent(), new FileAttribute[0]);
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.write(vanillaArmorPath1, EMPTY_EQUIPMENT_IMAGE, new OpenOption[0]);
                    Files.write(path, EMPTY_EQUIPMENT_IMAGE, new OpenOption[0]);
                }
                catch (IOException iOException) {
                    this.plugin.logger().warn("Failed to write empty vanilla armor texture file", iOException);
                }
            }
            JsonObject legacyTrimAtlasJson = null;
            if (needLegacyCompatibility) {
                legacyTrimAtlasJson = new JsonObject();
                JsonArray sourcesArray = new JsonArray();
                legacyTrimAtlasJson.add("sources", (JsonElement)sourcesArray);
                for (Tuple tuple : collectedTrims) {
                    if (((Boolean)tuple.mid()).booleanValue()) {
                        JsonObject single1 = new JsonObject();
                        single1.addProperty("type", "single");
                        single1.addProperty("resource", ((Key)tuple.left()).namespace() + ":trims/models/armor/" + ((Key)tuple.left()).value() + "_custom");
                        sourcesArray.add((JsonElement)single1);
                    }
                    if (!((Boolean)tuple.right()).booleanValue()) continue;
                    JsonObject single2 = new JsonObject();
                    single2.addProperty("type", "single");
                    single2.addProperty("resource", ((Key)tuple.left()).namespace() + ":trims/models/armor/" + ((Key)tuple.left()).value() + "_leggings_custom");
                    sourcesArray.add((JsonElement)single2);
                }
                if (previousAtlasSources != null) {
                    sourcesArray.addAll(previousAtlasSources);
                }
                Path path = generatedPackPath.resolve("assets").resolve("minecraft").resolve("textures").resolve("models").resolve("armor").resolve(Config.sacrificedVanillaArmorType() + "_layer_1.png");
                Path path2 = generatedPackPath.resolve("assets").resolve("minecraft").resolve("textures").resolve("models").resolve("armor").resolve(Config.sacrificedVanillaArmorType() + "_layer_2.png");
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.write(path, EMPTY_EQUIPMENT_IMAGE, new OpenOption[0]);
                    Files.write(path2, EMPTY_EQUIPMENT_IMAGE, new OpenOption[0]);
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to write empty vanilla armor texture file", e);
                }
            }
            try {
                Files.createDirectories(atlasPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(atlasPath.toAbsolutePath()), e);
                return;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(atlasPath, new OpenOption[0]);){
                JsonObject jsonObject = needLegacyCompatibility ? legacyTrimAtlasJson : modernTrimAtlasJson;
                GsonHelper.get().toJson((JsonElement)jsonObject, (Appendable)writer);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error writing " + String.valueOf(atlasPath.toAbsolutePath()), e);
            }
            if (needLegacyCompatibility && needModernCompatibility) {
                Revision revision = Revisions.SINCE_1_21_2;
                callback.accept(revision);
                Path path = generatedPackPath.resolve(Config.createOverlayFolderName(revision.versionString())).resolve("assets").resolve("minecraft").resolve("atlases").resolve("armor_trims.json");
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    this.plugin.logger().severe("Error creating " + String.valueOf(path.toAbsolutePath()), iOException);
                    return;
                }
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    GsonHelper.get().toJson((JsonElement)modernTrimAtlasJson, (Appendable)bufferedWriter);
                    callback.accept(revision);
                }
                catch (IOException iOException) {
                    this.plugin.logger().severe("Error writing " + String.valueOf(path.toAbsolutePath()), iOException);
                }
            }
        }
    }

    private void processComponentBasedEquipment(ComponentBasedEquipment componentBasedEquipment, Path generatedPackPath) {
        BufferedReader reader;
        JsonObject equipmentJson;
        Path equipmentPath;
        Key assetId = componentBasedEquipment.assetId();
        if (Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_4)) {
            equipmentPath = generatedPackPath.resolve("assets").resolve(assetId.namespace()).resolve("equipment").resolve(assetId.value() + ".json");
            equipmentJson = null;
            if (Files.exists(equipmentPath, new LinkOption[0])) {
                try {
                    reader = Files.newBufferedReader(equipmentPath);
                    try {
                        equipmentJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to load existing sounds.json", e);
                    return;
                }
            }
            equipmentJson = equipmentJson != null ? GsonHelper.deepMerge(equipmentJson, componentBasedEquipment.get()) : componentBasedEquipment.get();
            try {
                Files.createDirectories(equipmentPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(equipmentPath.toAbsolutePath()));
                return;
            }
            try {
                GsonHelper.writeJsonFile((JsonElement)equipmentJson, equipmentPath);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error writing equipment file", e);
            }
        }
        if (Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2) && Config.packMinVersion().isBelow(MinecraftVersions.V1_21_4)) {
            equipmentPath = generatedPackPath.resolve("assets").resolve(assetId.namespace()).resolve("models").resolve("equipment").resolve(assetId.value() + ".json");
            equipmentJson = null;
            if (Files.exists(equipmentPath, new LinkOption[0])) {
                try {
                    reader = Files.newBufferedReader(equipmentPath);
                    try {
                        equipmentJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to load existing sounds.json", e);
                    return;
                }
            }
            equipmentJson = equipmentJson != null ? GsonHelper.deepMerge(equipmentJson, componentBasedEquipment.get()) : componentBasedEquipment.get();
            try {
                Files.createDirectories(equipmentPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(equipmentPath.toAbsolutePath()));
                return;
            }
            try {
                GsonHelper.writeJsonFile((JsonElement)equipmentJson, equipmentPath);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error writing equipment file", e);
            }
        }
    }

    @Nullable
    private Pair<Boolean, Boolean> processTrimBasedEquipment(TrimBasedEquipment trimBasedEquipment, Path generatedPackPath) {
        Path modernTarget;
        Path legacyTarget;
        boolean shouldPreserve;
        Path texture;
        boolean hasLayer2;
        Key assetId = trimBasedEquipment.assetId();
        Key humanoidResourceLocation = trimBasedEquipment.humanoid();
        boolean hasLayer1 = humanoidResourceLocation != null;
        Key humanoidLeggingsResourceLocation = trimBasedEquipment.humanoidLeggings();
        boolean bl = hasLayer2 = humanoidLeggingsResourceLocation != null;
        if (hasLayer1) {
            texture = generatedPackPath.resolve("assets").resolve(humanoidResourceLocation.namespace()).resolve("textures").resolve(humanoidResourceLocation.value() + ".png");
            if (!Files.exists(texture, new LinkOption[0]) || !Files.isRegularFile(texture, new LinkOption[0])) {
                TranslationManager.instance().log("warning.config.resource_pack.generation.missing_equipment_texture", assetId.asString(), texture.toString());
                return null;
            }
            shouldPreserve = false;
            if (Config.packMinVersion().isBelow(MinecraftVersions.V1_21_2)) {
                legacyTarget = generatedPackPath.resolve("assets").resolve(assetId.namespace()).resolve("textures").resolve("trims").resolve("models").resolve("armor").resolve(assetId.value() + "_custom.png");
                if (!legacyTarget.equals(texture)) {
                    try {
                        Files.createDirectories(legacyTarget.getParent(), new FileAttribute[0]);
                        Files.copy(texture, legacyTarget, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.plugin.logger().severe("Error writing armor texture file from " + String.valueOf(texture) + " to " + String.valueOf(legacyTarget), e);
                    }
                } else {
                    shouldPreserve = true;
                }
            }
            if (Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2)) {
                modernTarget = generatedPackPath.resolve("assets").resolve(assetId.namespace()).resolve("textures").resolve("trims").resolve("entity").resolve("humanoid").resolve(assetId.value() + "_custom.png");
                if (!modernTarget.equals(texture)) {
                    try {
                        Files.createDirectories(modernTarget.getParent(), new FileAttribute[0]);
                        Files.copy(texture, modernTarget, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.plugin.logger().severe("Error writing armor texture file from " + String.valueOf(texture) + " to " + String.valueOf(modernTarget), e);
                    }
                } else {
                    shouldPreserve = true;
                }
            }
            if (!shouldPreserve) {
                try {
                    Files.delete(texture);
                }
                catch (IOException e) {
                    this.plugin.logger().severe("Error deleting armor texture file from " + String.valueOf(texture), e);
                }
            }
        }
        if (hasLayer2) {
            texture = generatedPackPath.resolve("assets").resolve(humanoidLeggingsResourceLocation.namespace()).resolve("textures").resolve(humanoidLeggingsResourceLocation.value() + ".png");
            if (!Files.exists(texture, new LinkOption[0]) && !Files.isRegularFile(texture, new LinkOption[0])) {
                TranslationManager.instance().log("warning.config.resource_pack.generation.missing_equipment_texture", assetId.asString(), texture.toString());
                return null;
            }
            shouldPreserve = false;
            if (Config.packMinVersion().isBelow(MinecraftVersions.V1_21_2)) {
                legacyTarget = generatedPackPath.resolve("assets").resolve(assetId.namespace()).resolve("textures").resolve("trims").resolve("models").resolve("armor").resolve(assetId.value() + "_leggings_custom.png");
                if (!legacyTarget.equals(texture)) {
                    try {
                        Files.createDirectories(legacyTarget.getParent(), new FileAttribute[0]);
                        Files.copy(texture, legacyTarget, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.plugin.logger().severe("Error writing armor texture file from " + String.valueOf(texture) + " to " + String.valueOf(legacyTarget), e);
                    }
                } else {
                    shouldPreserve = true;
                }
            }
            if (Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2)) {
                modernTarget = generatedPackPath.resolve("assets").resolve(assetId.namespace()).resolve("textures").resolve("trims").resolve("entity").resolve("humanoid_leggings").resolve(assetId.value() + "_custom.png");
                if (!modernTarget.equals(texture)) {
                    try {
                        Files.createDirectories(modernTarget.getParent(), new FileAttribute[0]);
                        Files.copy(texture, modernTarget, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.plugin.logger().severe("Error writing armor texture file from " + String.valueOf(texture) + " to " + String.valueOf(modernTarget), e);
                    }
                } else {
                    shouldPreserve = true;
                }
            }
            if (!shouldPreserve) {
                try {
                    Files.delete(texture);
                }
                catch (IOException e) {
                    this.plugin.logger().severe("Error deleting armor texture file from " + String.valueOf(texture), e);
                }
            }
        }
        return Pair.of(hasLayer1, hasLayer2);
    }

    private void generateClientLang(Path generatedPackPath) {
        for (Map.Entry<String, I18NData> entry : this.plugin.translationManager().clientLangData().entrySet()) {
            JsonObject json;
            Path langPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("lang").resolve(entry.getKey() + ".json");
            if (Files.exists(langPath, new LinkOption[0])) {
                try {
                    json = GsonHelper.readJsonFile(langPath).getAsJsonObject();
                }
                catch (Exception e) {
                    json = new JsonObject();
                }
            } else {
                json = new JsonObject();
            }
            for (Map.Entry<String, String> pair : entry.getValue().translations.entrySet()) {
                json.addProperty(pair.getKey(), pair.getValue());
            }
            try {
                Files.createDirectories(langPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(langPath.toAbsolutePath()));
                return;
            }
            try {
                GsonHelper.writeJsonFile((JsonElement)json, langPath);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error writing language file", e);
            }
        }
    }

    private void generateCustomSounds(Path generatedPackPath) {
        AbstractSoundManager soundManager = (AbstractSoundManager)this.plugin.soundManager();
        for (Map.Entry<String, List<SoundEvent>> entry : soundManager.soundsByNamespace().entrySet()) {
            JsonObject soundJson;
            Path soundPath;
            block20: {
                soundPath = generatedPackPath.resolve("assets").resolve(entry.getKey()).resolve("sounds.json");
                if (Files.exists(soundPath, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(soundPath);){
                        soundJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        break block20;
                    }
                    catch (IOException e) {
                        this.plugin.logger().warn("Failed to load existing sounds.json", e);
                        return;
                    }
                }
                soundJson = new JsonObject();
            }
            for (SoundEvent soundEvent : entry.getValue()) {
                soundJson.add(soundEvent.id().value(), (JsonElement)soundEvent.get());
            }
            try {
                Files.createDirectories(soundPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(soundPath.toAbsolutePath()));
                return;
            }
            try {
                BufferedWriter writer = Files.newBufferedWriter(soundPath, new OpenOption[0]);
                try {
                    GsonHelper.get().toJson((JsonElement)soundJson, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to generate sounds.json: " + String.valueOf(soundPath.toAbsolutePath()), e);
            }
        }
    }

    private void generateOverrideSounds(Path generatedPackPath) {
        JsonObject soundJson;
        JsonObject soundTemplate;
        Path soundPath;
        block33: {
            if (!Config.enableSoundSystem()) {
                return;
            }
            soundPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("sounds.json");
            try (InputStream inputStream = this.plugin.resourceStream("internal/sounds.json");){
                if (inputStream == null) {
                    this.plugin.logger().warn("Failed to load internal/sounds.json");
                    return;
                }
                soundTemplate = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to load internal/sounds.json", e);
                return;
            }
            if (Files.exists(soundPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(soundPath);){
                    soundJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    break block33;
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to load existing sounds.json", e);
                    return;
                }
            }
            soundJson = new JsonObject();
        }
        for (Map.Entry<Key, Key> mapper : this.plugin.blockManager().soundReplacements().entrySet()) {
            Key originalKey = mapper.getKey();
            JsonObject empty = new JsonObject();
            empty.add("sounds", (JsonElement)new JsonArray());
            empty.addProperty("replace", Boolean.valueOf(true));
            soundJson.add(originalKey.value(), (JsonElement)empty);
            JsonObject originalSounds = soundTemplate.getAsJsonObject(originalKey.value());
            if (originalSounds != null) {
                soundJson.add(mapper.getValue().value(), (JsonElement)originalSounds);
                continue;
            }
            this.plugin.logger().warn("Cannot find " + originalKey.value() + " in sound template");
        }
        try {
            Files.createDirectories(soundPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin.logger().severe("Error creating " + String.valueOf(soundPath.toAbsolutePath()));
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(soundPath, new OpenOption[0]);){
            GsonHelper.get().toJson((JsonElement)soundJson, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to generate sounds.json: " + String.valueOf(soundPath.toAbsolutePath()), e);
        }
    }

    private void generateItemModels(Path generatedPackPath, ModelGenerator generator) {
        for (ModelGeneration generation : generator.modelsToGenerate()) {
            Path modelPath = generatedPackPath.resolve("assets").resolve(generation.path().namespace()).resolve("models").resolve(generation.path().value() + ".json");
            if (Files.exists(modelPath, new LinkOption[0])) {
                TranslationManager.instance().log("warning.config.resource_pack.model.generation.already_exist", modelPath.toAbsolutePath().toString());
                continue;
            }
            try {
                Files.createDirectories(modelPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(modelPath.toAbsolutePath()), e);
                continue;
            }
            try {
                BufferedWriter writer = Files.newBufferedWriter(modelPath, new OpenOption[0]);
                try {
                    GsonHelper.get().toJson((JsonElement)generation.get(), (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to generate model: " + String.valueOf(modelPath.toAbsolutePath()), e);
            }
        }
    }

    private void generateBlockOverrides(Path generatedPackPath) {
        BufferedWriter writer;
        JsonObject variants;
        JsonObject stateJson;
        Path overridedBlockPath;
        Key key;
        for (Map.Entry<Key, Map<String, JsonElement>> entry : this.plugin.blockManager().blockOverrides().entrySet()) {
            key = entry.getKey();
            overridedBlockPath = generatedPackPath.resolve("assets").resolve(key.namespace()).resolve("blockstates").resolve(key.value() + ".json");
            if (Files.exists(overridedBlockPath, new LinkOption[0])) {
                try {
                    stateJson = GsonHelper.readJsonFile(overridedBlockPath).getAsJsonObject();
                    if (!stateJson.has("variants")) {
                        stateJson = new JsonObject();
                    }
                }
                catch (IOException e) {
                    stateJson = new JsonObject();
                }
            } else {
                stateJson = new JsonObject();
            }
            if (!stateJson.has("variants")) {
                variants = new JsonObject();
                stateJson.add("variants", (JsonElement)variants);
            } else {
                variants = stateJson.get("variants").getAsJsonObject();
            }
            for (Map.Entry<String, JsonElement> resourcePathEntry : entry.getValue().entrySet()) {
                variants.add(resourcePathEntry.getKey(), resourcePathEntry.getValue());
            }
            try {
                Files.createDirectories(overridedBlockPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(overridedBlockPath.toAbsolutePath()), e);
                continue;
            }
            try {
                writer = Files.newBufferedWriter(overridedBlockPath, new OpenOption[0]);
                try {
                    GsonHelper.get().toJson((JsonElement)stateJson, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to create block states for " + String.valueOf(key), e);
            }
        }
        if (!Config.generateModAssets()) {
            return;
        }
        for (Map.Entry<Key, Map<String, JsonElement>> entry : this.plugin.blockManager().modBlockStates().entrySet()) {
            key = entry.getKey();
            overridedBlockPath = generatedPackPath.resolve("assets").resolve(key.namespace()).resolve("blockstates").resolve(key.value() + ".json");
            stateJson = new JsonObject();
            variants = new JsonObject();
            stateJson.add("variants", (JsonElement)variants);
            variants.add("", (JsonElement)entry.getValue());
            try {
                Files.createDirectories(overridedBlockPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(overridedBlockPath.toAbsolutePath()), e);
                continue;
            }
            try {
                writer = Files.newBufferedWriter(overridedBlockPath, new OpenOption[0]);
                try {
                    GsonHelper.get().toJson((JsonElement)stateJson, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to create block states for " + String.valueOf(key), e);
            }
        }
    }

    private void generateModernItemModels1_21_2(Path generatedPackPath) {
        if (Config.packMaxVersion().isBelow(MinecraftVersions.V1_21_2)) {
            return;
        }
        if (Config.packMinVersion().isAtOrAbove(MinecraftVersions.V1_21_4)) {
            return;
        }
        for (Map.Entry<Key, TreeSet<LegacyOverridesModel>> entry : this.plugin.itemManager().modernItemModels1_21_2().entrySet()) {
            JsonObject itemJson;
            Path itemPath;
            Key itemModelPath;
            block22: {
                itemModelPath = entry.getKey();
                TreeSet<LegacyOverridesModel> legacyOverridesModels = entry.getValue();
                itemPath = generatedPackPath.resolve("assets").resolve(itemModelPath.namespace()).resolve("models").resolve("item").resolve(itemModelPath.value() + ".json");
                boolean modelExists = Files.exists(itemPath, new LinkOption[0]);
                if (modelExists) {
                    try {
                        itemJson = GsonHelper.readJsonFile(itemPath).getAsJsonObject();
                        if (itemJson.has("overrides")) continue;
                        JsonArray overrides = new JsonArray();
                        for (LegacyOverridesModel legacyOverridesModel : legacyOverridesModels) {
                            if (!legacyOverridesModel.hasPredicate()) continue;
                            overrides.add((JsonElement)legacyOverridesModel.toLegacyPredicateElement());
                        }
                        if (!overrides.isEmpty()) {
                            itemJson.add("overrides", (JsonElement)overrides);
                        }
                        break block22;
                    }
                    catch (IOException e) {
                        this.plugin.logger().warn("Failed to read item json " + String.valueOf(itemPath.toAbsolutePath()));
                        continue;
                    }
                }
                itemJson = new JsonObject();
                LegacyOverridesModel firstBaseModel = null;
                ArrayList<JsonObject> overrideJsons = new ArrayList<JsonObject>();
                for (LegacyOverridesModel legacyOverridesModel3 : legacyOverridesModels) {
                    if (!legacyOverridesModel3.hasPredicate()) {
                        if (firstBaseModel != null) continue;
                        firstBaseModel = legacyOverridesModel3;
                        continue;
                    }
                    JsonObject legacyPredicateElement = legacyOverridesModel3.toLegacyPredicateElement();
                    overrideJsons.add(legacyPredicateElement);
                }
                if (firstBaseModel == null) {
                    firstBaseModel = (LegacyOverridesModel)legacyOverridesModels.getFirst();
                }
                itemJson.addProperty("parent", firstBaseModel.model());
                if (!overrideJsons.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (JsonObject override : overrideJsons) {
                        jsonArray.add((JsonElement)override);
                    }
                    itemJson.add("overrides", (JsonElement)jsonArray);
                }
            }
            try {
                Files.createDirectories(itemPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(itemPath.toAbsolutePath()), e);
                continue;
            }
            try {
                BufferedWriter writer = Files.newBufferedWriter(itemPath, new OpenOption[0]);
                try {
                    GsonHelper.get().toJson((JsonElement)itemJson, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to save item model for " + String.valueOf(itemModelPath), e);
            }
        }
    }

    private void generateModernItemModels1_21_4(Path generatedPackPath, Consumer<Revision> callback) {
        if (Config.packMaxVersion().isBelow(MinecraftVersions.V1_21_4)) {
            return;
        }
        for (Map.Entry<Key, ModernItemModel> entry : this.plugin.itemManager().modernItemModels1_21_4().entrySet()) {
            List<Revision> revisions;
            Key key = entry.getKey();
            Path itemPath = generatedPackPath.resolve("assets").resolve(key.namespace()).resolve("items").resolve(key.value() + ".json");
            if (Files.exists(itemPath, new LinkOption[0])) {
                TranslationManager.instance().log("warning.config.resource_pack.item_model.already_exist", key.asString(), itemPath.toAbsolutePath().toString());
                continue;
            }
            try {
                Files.createDirectories(itemPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(itemPath.toAbsolutePath()), e);
                continue;
            }
            ModernItemModel modernItemModel = entry.getValue();
            try (BufferedWriter writer = Files.newBufferedWriter(itemPath, new OpenOption[0]);){
                GsonHelper.get().toJson((JsonElement)modernItemModel.toJson(Config.packMinVersion()), (Appendable)writer);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to save item model for " + String.valueOf(key), e);
            }
            if ((revisions = modernItemModel.revisions()).isEmpty()) continue;
            for (Revision revision : revisions) {
                if (!revision.matches(Config.packMinVersion(), Config.packMaxVersion())) continue;
                Path overlayItemPath = generatedPackPath.resolve(Config.createOverlayFolderName(revision.versionString())).resolve("assets").resolve(key.namespace()).resolve("items").resolve(key.value() + ".json");
                try {
                    Files.createDirectories(overlayItemPath.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.logger().severe("Error creating " + String.valueOf(overlayItemPath.toAbsolutePath()), e);
                    continue;
                }
                try {
                    BufferedWriter writer = Files.newBufferedWriter(overlayItemPath, new OpenOption[0]);
                    try {
                        GsonHelper.get().toJson((JsonElement)modernItemModel.toJson(revision.minVersion()), (Appendable)writer);
                        callback.accept(revision);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to save item model for " + String.valueOf(key), e);
                }
            }
        }
    }

    private void generateModernItemOverrides(Path generatedPackPath, Consumer<Revision> callback) {
        if (Config.packMaxVersion().isBelow(MinecraftVersions.V1_21_4)) {
            return;
        }
        for (Map.Entry<Key, TreeMap<Integer, ModernItemModel>> entry : this.plugin.itemManager().modernItemOverrides().entrySet()) {
            List<Revision> revisions;
            ModernItemModel originalItemModel;
            Path overridedItemPath;
            Key vanillaItemModel;
            block28: {
                vanillaItemModel = entry.getKey();
                overridedItemPath = generatedPackPath.resolve("assets").resolve(vanillaItemModel.namespace()).resolve("items").resolve(vanillaItemModel.value() + ".json");
                if (Files.exists(overridedItemPath, new LinkOption[0])) {
                    try {
                        originalItemModel = ModernItemModel.fromJson(GsonHelper.readJsonFile(overridedItemPath).getAsJsonObject());
                        break block28;
                    }
                    catch (IOException e) {
                        this.plugin.logger().warn("Failed to load existing item model (modern)", e);
                        continue;
                    }
                }
                originalItemModel = PRESET_ITEMS.get(vanillaItemModel);
                if (originalItemModel == null) {
                    this.plugin.logger().warn("Failed to load existing item model for " + String.valueOf(vanillaItemModel) + " (modern)");
                    continue;
                }
            }
            boolean handAnimationOnSwap = originalItemModel.handAnimationOnSwap();
            boolean oversizedInGui = originalItemModel.oversizedInGui();
            HashMap<Float, ItemModel> entries = new HashMap<Float, ItemModel>();
            for (Map.Entry<Integer, ModernItemModel> modelWithDataEntry : entry.getValue().entrySet()) {
                ModernItemModel modernItemModel = modelWithDataEntry.getValue();
                entries.put(Float.valueOf(modelWithDataEntry.getKey().floatValue()), modernItemModel.itemModel());
                if (modernItemModel.handAnimationOnSwap()) {
                    handAnimationOnSwap = true;
                }
                if (!modernItemModel.oversizedInGui()) continue;
                oversizedInGui = true;
            }
            RangeDispatchItemModel rangeDispatch = new RangeDispatchItemModel(new CustomModelDataRangeDispatchProperty(0), 1.0f, originalItemModel.itemModel(), entries);
            ModernItemModel newItemModel = new ModernItemModel(rangeDispatch, handAnimationOnSwap, oversizedInGui);
            try {
                Files.createDirectories(overridedItemPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(overridedItemPath.toAbsolutePath()), e);
                continue;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(overridedItemPath, new OpenOption[0]);){
                GsonHelper.get().toJson((JsonElement)newItemModel.toJson(Config.packMinVersion()), (Appendable)writer);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to save item model for " + String.valueOf(vanillaItemModel), e);
            }
            if ((revisions = newItemModel.revisions()).isEmpty()) continue;
            for (Revision revision : revisions) {
                if (!revision.matches(Config.packMinVersion(), Config.packMaxVersion())) continue;
                Path overlayItemPath = generatedPackPath.resolve(Config.createOverlayFolderName(revision.versionString())).resolve("assets").resolve(vanillaItemModel.namespace()).resolve("items").resolve(vanillaItemModel.value() + ".json");
                try {
                    Files.createDirectories(overlayItemPath.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.logger().severe("Error creating " + String.valueOf(overlayItemPath.toAbsolutePath()), e);
                    continue;
                }
                try {
                    BufferedWriter writer = Files.newBufferedWriter(overlayItemPath, new OpenOption[0]);
                    try {
                        GsonHelper.get().toJson((JsonElement)newItemModel.toJson(revision.minVersion()), (Appendable)writer);
                        callback.accept(revision);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (IOException e) {
                    this.plugin.logger().warn("Failed to save item model for " + String.valueOf(vanillaItemModel), e);
                }
            }
        }
    }

    private void generateLegacyItemOverrides(Path generatedPackPath) {
        if (Config.packMinVersion().isAtOrAbove(MinecraftVersions.V1_21_4)) {
            return;
        }
        for (Map.Entry<Key, TreeSet<LegacyOverridesModel>> entry : this.plugin.itemManager().legacyItemOverrides().entrySet()) {
            JsonArray overrides;
            JsonObject originalItemModel;
            Path overridedItemPath;
            Key vanillaLegacyModel;
            block24: {
                vanillaLegacyModel = entry.getKey();
                overridedItemPath = generatedPackPath.resolve("assets").resolve(vanillaLegacyModel.namespace()).resolve("models").resolve("item").resolve(vanillaLegacyModel.value() + ".json");
                if (Files.exists(overridedItemPath, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(overridedItemPath);){
                        originalItemModel = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        break block24;
                    }
                    catch (IOException e) {
                        this.plugin.logger().warn("Failed to load existing item model (legacy)", e);
                        continue;
                    }
                }
                originalItemModel = PRESET_LEGACY_MODELS_ITEM.get(vanillaLegacyModel);
                if (originalItemModel == null) {
                    this.plugin.logger().warn("Failed to load item model for " + String.valueOf(vanillaLegacyModel) + " (legacy)");
                    continue;
                }
                originalItemModel = originalItemModel.deepCopy();
            }
            if (originalItemModel.has("overrides")) {
                overrides = originalItemModel.getAsJsonArray("overrides");
            } else {
                overrides = new JsonArray();
                originalItemModel.add("overrides", (JsonElement)overrides);
            }
            Collection legacyOverridesModels = entry.getValue();
            for (LegacyOverridesModel model : legacyOverridesModels) {
                overrides.add((JsonElement)model.toLegacyPredicateElement());
            }
            try {
                Files.createDirectories(overridedItemPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error creating " + String.valueOf(overridedItemPath.toAbsolutePath()), e);
                continue;
            }
            try {
                BufferedWriter writer = Files.newBufferedWriter(overridedItemPath, new OpenOption[0]);
                try {
                    GsonHelper.get().toJson((JsonElement)originalItemModel, (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to save item model for " + String.valueOf(vanillaLegacyModel), e);
            }
        }
    }

    private void generateFonts(Path generatedPackPath) {
        Path fontPath;
        for (Font font : this.plugin.fontManager().fonts()) {
            JsonArray providers;
            JsonObject fontJson;
            Key namespacedKey = font.key();
            Path fontPath2 = generatedPackPath.resolve("assets").resolve(namespacedKey.namespace()).resolve("font").resolve(namespacedKey.value() + ".json");
            if (Files.exists(fontPath2, new LinkOption[0])) {
                try {
                    String content = Files.readString(fontPath2);
                    fontJson = JsonParser.parseString((String)content).getAsJsonObject();
                }
                catch (IOException e) {
                    fontJson = new JsonObject();
                    this.plugin.logger().warn(String.valueOf(fontPath2) + " is not a valid font json file");
                }
            } else {
                fontJson = new JsonObject();
                try {
                    Files.createDirectories(fontPath2.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.logger().severe("Error creating " + String.valueOf(fontPath2.toAbsolutePath()), e);
                }
            }
            if (fontJson.has("providers")) {
                providers = fontJson.getAsJsonArray("providers");
            } else {
                providers = new JsonArray();
                fontJson.add("providers", (JsonElement)providers);
            }
            for (BitmapImage image : font.bitmapImages()) {
                providers.add((JsonElement)image.get());
            }
            try {
                Files.writeString(fontPath2, (CharSequence)CharacterUtils.replaceDoubleBackslashU(fontJson.toString()), new OpenOption[0]);
            }
            catch (IOException e) {
                this.plugin.logger().severe("Error writing font to " + String.valueOf(fontPath2.toAbsolutePath()), e);
            }
        }
        if (Config.resourcePack$overrideUniform() && Files.exists(fontPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("font").resolve("default.json"), new LinkOption[0])) {
            Path targetPath = generatedPackPath.resolve("assets").resolve("minecraft").resolve("font").resolve("uniform.json");
            try {
                Files.copy(fontPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<Pair<String, List<Path>>> updateCachedAssets(@NotNull PackCacheData cacheData, final @Nullable FileSystem fs) throws IOException {
        final HashMap<String, List<Path>> conflictChecker = new HashMap<String, List<Path>>(Math.max(128, this.cachedAssetFiles.size()), 0.6f);
        final Map<Path, CachedAssetFile> previousFiles = this.cachedAssetFiles;
        this.cachedAssetFiles = new HashMap<Path, CachedAssetFile>(Math.max(128, this.cachedAssetFiles.size()), 0.6f);
        ArrayList<Path> folders = new ArrayList<Path>();
        folders.addAll(this.loadedPacks().stream().filter(Pack::enabled).map(Pack::resourcePackFolder).toList());
        folders.addAll(cacheData.externalFolders());
        for (final Path sourceFolder : folders) {
            if (!Files.exists(sourceFolder, new LinkOption[0])) continue;
            Files.walkFileTree(sourceFolder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    AbstractPackManager.this.processRegularFile(file, attrs, sourceFolder, fs, conflictChecker, previousFiles);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        for (Path zip : cacheData.externalZips()) {
            this.processZipFile(zip, zip.getParent(), fs, conflictChecker, previousFiles);
        }
        ArrayList<Pair<String, List<Path>>> conflicts = new ArrayList<Pair<String, List<Path>>>();
        for (Map.Entry entry : conflictChecker.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            conflicts.add(Pair.of((String)entry.getKey(), (List)entry.getValue()));
        }
        return conflicts;
    }

    private void processRegularFile(Path file, BasicFileAttributes attrs, Path sourceFolder, @Nullable FileSystem fs, Map<String, List<Path>> conflictChecker, Map<Path, CachedAssetFile> previousFiles) throws IOException {
        if (Config.excludeFileExtensions().contains(FileUtils.getExtension(file))) {
            return;
        }
        CachedAssetFile cachedAsset = previousFiles.get(file);
        long lastModified = attrs.lastModifiedTime().toMillis();
        long size = attrs.size();
        if (cachedAsset != null && cachedAsset.lastModified() == lastModified && cachedAsset.size() == size) {
            this.cachedAssetFiles.put(file, cachedAsset);
        } else {
            cachedAsset = new CachedAssetFile(Files.readAllBytes(file), lastModified, size);
            this.cachedAssetFiles.put(file, cachedAsset);
        }
        if (fs == null) {
            return;
        }
        Path relative = sourceFolder.relativize(file);
        this.updateConflictChecker(fs, conflictChecker, file, file, relative, cachedAsset.data());
    }

    private void processZipFile(final Path zipFile, Path sourceFolder, final @Nullable FileSystem fs, final Map<String, List<Path>> conflictChecker, final Map<Path, CachedAssetFile> previousFiles) throws IOException {
        try (FileSystem zipFs = FileSystems.newFileSystem(zipFile);){
            final long zipLastModified = Files.getLastModifiedTime(zipFile, new LinkOption[0]).toMillis();
            final long zipSize = Files.size(zipFile);
            final Path zipRoot = zipFs.getPath("/", new String[0]);
            Files.walkFileTree(zipRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path entry, @NotNull BasicFileAttributes entryAttrs) throws IOException {
                    if (entryAttrs.isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (Config.excludeFileExtensions().contains(FileUtils.getExtension(entry))) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path entryPathInZip = zipRoot.relativize(entry);
                    Path sourcePath = Path.of(String.valueOf(zipFile) + "!" + String.valueOf(entryPathInZip), new String[0]);
                    CachedAssetFile cachedAsset = (CachedAssetFile)previousFiles.get(sourcePath);
                    if (cachedAsset != null && cachedAsset.lastModified() == zipLastModified && cachedAsset.size() == zipSize) {
                        AbstractPackManager.this.cachedAssetFiles.put(sourcePath, cachedAsset);
                    } else {
                        byte[] data = Files.readAllBytes(entry);
                        cachedAsset = new CachedAssetFile(data, zipLastModified, zipSize);
                        AbstractPackManager.this.cachedAssetFiles.put(sourcePath, cachedAsset);
                    }
                    if (fs != null) {
                        AbstractPackManager.this.updateConflictChecker(fs, conflictChecker, entry, sourcePath, entryPathInZip, cachedAsset.data());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void updateConflictChecker(FileSystem fs, Map<String, List<Path>> conflictChecker, Path sourcePath, Path namedSourcePath, Path relative, byte[] data) throws IOException {
        String relativePath = CharacterUtils.replaceBackslashWithSlash(relative.toString());
        Path targetPath = fs.getPath("resource_pack/" + relativePath, new String[0]);
        List<Path> conflicts = conflictChecker.get(relativePath);
        if (conflicts == null) {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.write(targetPath, data, new OpenOption[0]);
            conflictChecker.put(relativePath, List.of(namedSourcePath));
        } else {
            PathContext relativeCTX = PathContext.of(relative);
            PathContext targetCTX = PathContext.of(targetPath);
            PathContext sourceCTX = PathContext.of(sourcePath);
            for (ResolutionConditional resolution : Config.resolutions()) {
                if (!resolution.matcher().test(relativeCTX)) continue;
                resolution.resolution().run(targetCTX, sourceCTX);
                return;
            }
            switch (conflicts.size()) {
                case 1: {
                    conflictChecker.put(relativePath, List.of(conflicts.get(0), namedSourcePath));
                    break;
                }
                case 2: {
                    conflictChecker.put(relativePath, List.of(conflicts.get(0), conflicts.get(1), namedSourcePath));
                    break;
                }
                case 3: {
                    conflictChecker.put(relativePath, List.of(conflicts.get(0), conflicts.get(1), conflicts.get(2), namedSourcePath));
                    break;
                }
                case 4: {
                    conflictChecker.put(relativePath, List.of(conflicts.get(0), conflicts.get(1), conflicts.get(2), conflicts.get(3), namedSourcePath));
                    break;
                }
            }
        }
    }

    static {
        try (ByteArrayOutputStream stream1 = new ByteArrayOutputStream();
             ByteArrayOutputStream stream2 = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)new BufferedImage(1, 1, 2), "png", stream1);
            EMPTY_IMAGE = stream1.toByteArray();
            ImageIO.write((RenderedImage)new BufferedImage(64, 32, 2), "png", stream2);
            EMPTY_EQUIPMENT_IMAGE = stream2.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create empty images.", e);
        }
    }
}

