/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.allocator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.util.FileUtils;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Pair;

public class IdAllocator {
    private final Path cacheFilePath;
    private final BiMap<String, Integer> forcedIdMap = HashBiMap.create((int)128);
    private final Map<String, Integer> cachedIdMap = new HashMap<String, Integer>();
    private final BitSet occupiedIdSet = new BitSet();
    private final Map<String, CompletableFuture<Integer>> pendingAllocations = new LinkedHashMap<String, CompletableFuture<Integer>>();
    private int nextAutoId;
    private int minId;
    private int maxId;

    public IdAllocator(Path cacheFilePath) {
        this.cacheFilePath = cacheFilePath;
    }

    public void reset(int minId, int maxId) {
        this.minId = minId;
        this.nextAutoId = minId;
        this.maxId = maxId;
        this.occupiedIdSet.clear();
        this.forcedIdMap.clear();
        this.pendingAllocations.clear();
        this.cachedIdMap.clear();
    }

    public void processPendingAllocations() {
        for (Map.Entry<String, Integer> entry : this.cachedIdMap.entrySet()) {
            CompletableFuture<Integer> future = this.pendingAllocations.get(entry.getKey());
            if (future != null) {
                int id = entry.getValue();
                if (!this.isIdAvailable(id)) continue;
                this.allocateId(id, future);
                continue;
            }
            this.occupiedIdSet.set(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.pendingAllocations.entrySet()) {
            String name = entry.getKey();
            CompletableFuture future = (CompletableFuture)entry.getValue();
            if (future.isDone()) continue;
            int newId = this.findNextAvailableId();
            if (newId == -1) {
                future.completeExceptionally(new IdExhaustedException(name, this.minId, this.maxId));
                continue;
            }
            this.allocateId(newId, future);
            this.cachedIdMap.put(name, newId);
        }
        this.pendingAllocations.clear();
    }

    private boolean isIdAvailable(Integer id) {
        return id != null && id >= this.minId && id <= this.maxId && !this.occupiedIdSet.get(id);
    }

    private void allocateId(int id, CompletableFuture<Integer> future) {
        this.occupiedIdSet.set(id);
        future.complete(id);
    }

    private int findNextAvailableId() {
        if (this.nextAutoId > this.maxId) {
            return -1;
        }
        this.nextAutoId = this.occupiedIdSet.nextClearBit(this.nextAutoId);
        return this.nextAutoId <= this.maxId ? this.nextAutoId : -1;
    }

    public CompletableFuture<Integer> assignFixedId(String name, int id) {
        String existingOwner = (String)this.forcedIdMap.inverse().get((Object)id);
        if (existingOwner != null && !existingOwner.equals(name)) {
            return CompletableFuture.failedFuture(new IdConflictException(existingOwner, id));
        }
        this.forcedIdMap.put((Object)name, (Object)id);
        this.cachedIdMap.remove(name);
        this.occupiedIdSet.set(id);
        return CompletableFuture.completedFuture(id);
    }

    public boolean isForced(String name) {
        return this.forcedIdMap.containsKey((Object)name);
    }

    public List<Pair<String, Integer>> getFixedIdsBetween(int minId, int maxId) {
        BiMap inverse = this.forcedIdMap.inverse();
        ArrayList<Pair<String, Integer>> result = new ArrayList<Pair<String, Integer>>();
        for (int i = minId; i <= maxId; ++i) {
            String s = (String)inverse.get((Object)i);
            if (s == null) continue;
            result.add(Pair.of(s, i));
        }
        return result;
    }

    public CompletableFuture<Integer> requestAutoId(String name) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.pendingAllocations.put(name, future);
        return future;
    }

    public List<String> cleanupUnusedIds(Predicate<String> shouldRemove) {
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (String id : this.cachedIdMap.keySet()) {
            if (!shouldRemove.test(id)) continue;
            idsToRemove.add(id);
        }
        for (String id : idsToRemove) {
            Integer removedId = this.cachedIdMap.remove(id);
            if (removedId == null || this.forcedIdMap.containsValue((Object)removedId)) continue;
            this.occupiedIdSet.clear(removedId);
        }
        return idsToRemove;
    }

    public Integer getId(String name) {
        Integer forcedId = (Integer)this.forcedIdMap.get((Object)name);
        return forcedId != null ? forcedId : this.cachedIdMap.get(name);
    }

    public Map<String, Integer> getAllAllocatedIds() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.putAll((Map<String, Integer>)this.forcedIdMap);
        result.putAll(this.cachedIdMap);
        return Collections.unmodifiableMap(result);
    }

    public boolean isIdOccupied(int id) {
        return this.occupiedIdSet.get(id);
    }

    public void loadFromCache() throws IOException {
        if (!Files.exists(this.cacheFilePath, new LinkOption[0])) {
            return;
        }
        JsonElement element = GsonHelper.readJsonFile(this.cacheFilePath);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            for (Map.Entry entry : jsonObject.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof JsonPrimitive)) continue;
                JsonPrimitive primitive = (JsonPrimitive)v;
                int id = primitive.getAsInt();
                this.cachedIdMap.put((String)entry.getKey(), id);
            }
        }
    }

    public void saveToCache() throws IOException {
        TreeMap<Integer, String> sortedById = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : this.cachedIdMap.entrySet()) {
            sortedById.put(entry.getValue(), entry.getKey());
        }
        JsonObject sortedJsonObject = new JsonObject();
        for (Map.Entry entry : sortedById.entrySet()) {
            sortedJsonObject.addProperty((String)entry.getValue(), (Number)entry.getKey());
        }
        if (sortedJsonObject.asMap().isEmpty()) {
            if (Files.exists(this.cacheFilePath, new LinkOption[0])) {
                Files.delete(this.cacheFilePath);
            }
        } else {
            FileUtils.createDirectoriesSafe(this.cacheFilePath.getParent());
            GsonHelper.writeJsonFile((JsonElement)sortedJsonObject, this.cacheFilePath);
        }
    }

    public static class IdExhaustedException
    extends RuntimeException {
        private final String name;
        private final int min;
        private final int max;

        public IdExhaustedException(String name, int min, int max) {
            super("No available auto ID for '" + name + "'. All IDs in range " + min + "-" + max + " are occupied.");
            this.name = name;
            this.min = min;
            this.max = max;
        }

        public String name() {
            return this.name;
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }
    }

    public static class IdConflictException
    extends RuntimeException {
        private final String previousOwner;
        private final int id;

        public IdConflictException(String previousOwner, int id) {
            super("ID " + id + " is already occupied by: " + previousOwner);
            this.previousOwner = previousOwner;
            this.id = id;
        }

        public String previousOwner() {
            return this.previousOwner;
        }

        public int id() {
            return this.id;
        }
    }
}

