/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.allocator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.block.AutoStateGroup;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.pack.allocator.BlockStateCandidate;
import net.momirealms.craftengine.core.util.FileUtils;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Pair;

public class VisualBlockStateAllocator {
    private final Path cacheFilePath;
    private final Map<String, BlockStateWrapper> cachedBlockStates = new HashMap<String, BlockStateWrapper>();
    private final Map<String, Pair<AutoStateGroup, CompletableFuture<BlockStateWrapper>>> pendingAllocations = new LinkedHashMap<String, Pair<AutoStateGroup, CompletableFuture<BlockStateWrapper>>>();
    private final List<Pair<String, CompletableFuture<BlockStateWrapper>>>[] pendingAllocationFutures = new List[AutoStateGroup.values().length];
    private final BlockStateCandidate[] candidates;
    private final Function<String, BlockStateWrapper> factory;
    private final Set<BlockStateWrapper> forcedStates = new HashSet<BlockStateWrapper>();

    public VisualBlockStateAllocator(Path cacheFilePath, BlockStateCandidate[] candidates, Function<String, BlockStateWrapper> factory) {
        this.cacheFilePath = cacheFilePath;
        this.candidates = candidates;
        this.factory = factory;
    }

    public void reset() {
        for (int i = 0; i < this.pendingAllocationFutures.length; ++i) {
            this.pendingAllocationFutures[i] = new ArrayList<Pair<String, CompletableFuture<BlockStateWrapper>>>();
        }
        this.cachedBlockStates.clear();
        this.pendingAllocations.clear();
        this.forcedStates.clear();
    }

    public boolean isForcedState(BlockStateWrapper state) {
        return this.forcedStates.contains(state);
    }

    public CompletableFuture<BlockStateWrapper> assignFixedBlockState(String name, BlockStateWrapper state) {
        this.cachedBlockStates.remove(name);
        this.forcedStates.add(state);
        BlockStateCandidate candidate = this.candidates[state.registryId()];
        if (candidate != null) {
            candidate.setUsed();
        }
        return CompletableFuture.completedFuture(state);
    }

    public CompletableFuture<BlockStateWrapper> requestAutoState(String name, AutoStateGroup group) {
        CompletableFuture<BlockStateWrapper> future = new CompletableFuture<BlockStateWrapper>();
        this.pendingAllocations.put(name, new Pair(group, future));
        this.pendingAllocationFutures[group.ordinal()].add(Pair.of(name, future));
        return future;
    }

    public List<String> cleanupUnusedIds(Predicate<BlockStateWrapper> shouldRemove) {
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (Map.Entry<String, BlockStateWrapper> entry : this.cachedBlockStates.entrySet()) {
            if (!shouldRemove.test(entry.getValue())) continue;
            idsToRemove.add(entry.getKey());
        }
        for (String id : idsToRemove) {
            this.cachedBlockStates.remove(id);
        }
        return idsToRemove;
    }

    public void processPendingAllocations() {
        for (Map.Entry<String, BlockStateWrapper> entry : this.cachedBlockStates.entrySet()) {
            int registryId = entry.getValue().registryId();
            BlockStateCandidate candidate = this.candidates[registryId];
            if (candidate == null || candidate.isUsed()) continue;
            Pair<AutoStateGroup, CompletableFuture<BlockStateWrapper>> pair = this.pendingAllocations.get(entry.getKey());
            if (pair != null) {
                if (!pair.left().test(candidate.blockState())) continue;
                pair.right().complete(candidate.blockState());
                candidate.setUsed();
                continue;
            }
            candidate.setUsed();
        }
        this.pendingAllocations.clear();
        for (AutoStateGroup group : AutoStateGroup.values()) {
            List<Pair<String, CompletableFuture<BlockStateWrapper>>> pendingAllocationFuture = this.pendingAllocationFutures[group.ordinal()];
            for (Pair<String, CompletableFuture<BlockStateWrapper>> pair : pendingAllocationFuture) {
                if (pair.right().isDone()) continue;
                BlockStateCandidate nextCandidate = group.findNextCandidate();
                if (nextCandidate != null) {
                    nextCandidate.setUsed();
                    this.cachedBlockStates.put(pair.left(), nextCandidate.blockState());
                    pair.right().complete(nextCandidate.blockState());
                    continue;
                }
                pair.right().completeExceptionally(new StateExhaustedException(group));
            }
        }
    }

    public void loadFromCache() throws IOException {
        if (!Files.exists(this.cacheFilePath, new LinkOption[0])) {
            return;
        }
        JsonElement element = GsonHelper.readJsonFile(this.cacheFilePath);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonPrimitive primitive;
                String id;
                BlockStateWrapper state;
                Object v = entry.getValue();
                if (!(v instanceof JsonPrimitive) || (state = this.factory.apply(id = (primitive = (JsonPrimitive)v).getAsString())) == null) continue;
                this.cachedBlockStates.put((String)entry.getKey(), state);
            }
        }
    }

    public void saveToCache() throws IOException {
        TreeMap<BlockStateWrapper, String> sortedById = new TreeMap<BlockStateWrapper, String>();
        for (Map.Entry<String, BlockStateWrapper> entry : this.cachedBlockStates.entrySet()) {
            sortedById.put(entry.getValue(), entry.getKey());
        }
        JsonObject sortedJsonObject = new JsonObject();
        for (Map.Entry entry : sortedById.entrySet()) {
            sortedJsonObject.addProperty((String)entry.getValue(), ((BlockStateWrapper)entry.getKey()).getAsString());
        }
        if (sortedJsonObject.asMap().isEmpty()) {
            if (Files.exists(this.cacheFilePath, new LinkOption[0])) {
                Files.delete(this.cacheFilePath);
            }
        } else {
            FileUtils.createDirectoriesSafe(this.cacheFilePath.getParent());
            GsonHelper.writeJsonFile((JsonElement)sortedJsonObject, this.cacheFilePath);
        }
    }

    public static class StateExhaustedException
    extends RuntimeException {
        private final AutoStateGroup group;

        public StateExhaustedException(AutoStateGroup group) {
            this.group = group;
        }

        public AutoStateGroup group() {
            return this.group;
        }
    }
}

