/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.allocator.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.core.pack.allocator.cache.CacheSerializer;
import net.momirealms.craftengine.core.pack.allocator.cache.CacheStorage;

public class AllocationCacheFile<T extends Comparable<T>, A> {
    private final Map<String, T> cache = new HashMap<String, T>();
    private final CacheStorage<A> cacheStorage;
    private final CacheSerializer<T, A> serializer;

    public AllocationCacheFile(CacheStorage<A> cacheStorage, CacheSerializer<T, A> serializer) {
        this.cacheStorage = cacheStorage;
        this.serializer = serializer;
    }

    public Map<String, T> cache() {
        return this.cache;
    }

    public void clear() {
        this.cache.clear();
    }

    public CompletableFuture<Void> load() {
        return this.cacheStorage.load().thenAccept(a -> {
            Map<String, T> deserialized = this.serializer.deserialize(a);
            this.cache.putAll(deserialized);
        });
    }

    public CompletableFuture<Void> save() {
        TreeMap<Comparable, String> sortedById = new TreeMap<Comparable, String>();
        for (Map.Entry<String, T> entry : this.cache.entrySet()) {
            sortedById.put((Comparable)entry.getValue(), entry.getKey());
        }
        return this.cacheStorage.save(this.serializer.serialize(sortedById));
    }

    public Iterable<Map.Entry<String, T>> entrySet() {
        return this.cache.entrySet();
    }

    public Set<String> keySet() {
        return this.cache.keySet();
    }

    public void put(String name, T newId) {
        this.cache.put(name, newId);
    }

    public T remove(String name) {
        return (T)((Comparable)this.cache.remove(name));
    }

    public T get(String name) {
        return (T)((Comparable)this.cache.get(name));
    }
}

