/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.allocator.cache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.core.pack.allocator.cache.CacheFileType;

public interface CacheFileStorage<A> {
    public CompletableFuture<A> load();

    public CompletableFuture<Void> save(A var1);

    public boolean needForceUpdate();

    public static <A> LocalFileCacheStorage<A> local(Path path, CacheFileType<A> type) {
        return new LocalFileCacheStorage<A>(path, type);
    }

    public static class LocalFileCacheStorage<A>
    implements CacheFileStorage<A> {
        private final CacheFileType<A> fileType;
        private final Path filePath;
        private long lastModified = 0L;

        public LocalFileCacheStorage(Path filePath, CacheFileType<A> type) {
            this.filePath = filePath;
            this.fileType = type;
            this.updateLastModified();
        }

        @Override
        public boolean needForceUpdate() {
            try {
                if (!Files.exists(this.filePath, new LinkOption[0])) {
                    return this.lastModified != 0L;
                }
                long currentModified = Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis();
                if (currentModified > this.lastModified) {
                    this.lastModified = currentModified;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }

        @Override
        public CompletableFuture<A> load() {
            if (!Files.exists(this.filePath, new LinkOption[0])) {
                this.lastModified = 0L;
                return CompletableFuture.completedFuture(this.fileType.create());
            }
            try {
                A result = this.fileType.read(this.filePath);
                this.updateLastModified();
                return CompletableFuture.completedFuture(result);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }

        @Override
        public CompletableFuture<Void> save(A value) {
            try {
                this.fileType.write(this.filePath, value);
                this.updateLastModified();
                return CompletableFuture.completedFuture(null);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }

        private void updateLastModified() {
            try {
                this.lastModified = Files.exists(this.filePath, new LinkOption[0]) ? Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis() : 0L;
            }
            catch (IOException e) {
                this.lastModified = 0L;
            }
        }
    }

    public static abstract class AbstractRemoteFileCacheStorage<A>
    implements CacheFileStorage<A> {
        @Override
        public boolean needForceUpdate() {
            return true;
        }
    }
}

