/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.allocator.cache;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.momirealms.craftengine.core.util.GsonHelper;

public interface CacheFileType<T> {
    public static final JsonCacheFileType JSON = new JsonCacheFileType();

    public T read(Path var1) throws IOException;

    public void write(Path var1, T var2) throws IOException;

    public T create();

    public static class JsonCacheFileType
    implements CacheFileType<JsonObject> {
        @Override
        public JsonObject read(Path path) throws IOException {
            if (Files.exists(path, new LinkOption[0])) {
                return GsonHelper.readJsonFile(path).getAsJsonObject();
            }
            return new JsonObject();
        }

        @Override
        public void write(Path path, JsonObject value) throws IOException {
            GsonHelper.writeJsonFile((JsonElement)value, path);
        }

        @Override
        public JsonObject create() {
            return new JsonObject();
        }
    }
}

