/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.allocator.cache;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public interface CacheSerializer<T extends Comparable<T>, A> {
    public A serialize(Map<T, String> var1);

    public Map<String, T> deserialize(A var1);

    public static <T extends Comparable<T>> CacheSerializer<T, JsonObject> json() {
        return new JsonSerializer();
    }

    public static class JsonSerializer<T extends Comparable<T>>
    implements CacheSerializer<T, JsonObject> {
        @Override
        public JsonObject serialize(Map<T, String> obj) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<T, String> entry : obj.entrySet()) {
                T t = entry.getKey();
                if (t instanceof Integer) {
                    Integer i = (Integer)t;
                    jsonObject.addProperty(entry.getValue(), (Number)i);
                    continue;
                }
                t = entry.getKey();
                if (!(t instanceof String)) continue;
                String s = (String)t;
                jsonObject.addProperty(entry.getValue(), s);
            }
            return jsonObject;
        }

        @Override
        public Map<String, T> deserialize(JsonObject obj) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : obj.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof JsonPrimitive)) continue;
                JsonPrimitive primitive = (JsonPrimitive)v;
                if (primitive.isNumber()) {
                    map.put((String)entry.getKey(), primitive.getAsInt());
                    continue;
                }
                if (!primitive.isString()) continue;
                map.put((String)entry.getKey(), primitive.getAsString());
            }
            return map;
        }
    }
}

