/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.conflict.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.conflict.PathContext;
import net.momirealms.craftengine.core.pack.conflict.matcher.PathMatcherContains;
import net.momirealms.craftengine.core.pack.conflict.matcher.PathMatcherExact;
import net.momirealms.craftengine.core.pack.conflict.matcher.PathMatcherFilename;
import net.momirealms.craftengine.core.pack.conflict.matcher.PathMatcherParentPrefix;
import net.momirealms.craftengine.core.pack.conflict.matcher.PathMatcherParentSuffix;
import net.momirealms.craftengine.core.pack.conflict.matcher.PathPatternMatcher;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.condition.AllOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.AnyOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.context.condition.InvertedCondition;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class PathMatchers {
    public static final Key EXACT = Key.of("craftengine:exact");
    public static final Key CONTAINS = Key.of("craftengine:contains");
    public static final Key FILENAME = Key.of("craftengine:filename");
    public static final Key PARENT_PATH_SUFFIX = Key.of("craftengine:parent_path_suffix");
    public static final Key PARENT_PATH_PREFIX = Key.of("craftengine:parent_path_prefix");
    public static final Key PATTERN = Key.of("craftengine:pattern");

    public static void register(Key key, ConditionFactory<PathContext> factory) {
        ((WritableRegistry)BuiltInRegistries.PATH_MATCHER_FACTORY).register(ResourceKey.create(Registries.PATH_MATCHER_FACTORY.location(), key), factory);
    }

    public static List<Condition<PathContext>> fromMapList(List<Map<String, Object>> arguments) {
        ArrayList<Condition<PathContext>> matchers = new ArrayList<Condition<PathContext>>();
        for (Map<String, Object> term : arguments) {
            matchers.add(PathMatchers.fromMap(term));
        }
        return matchers;
    }

    public static Condition<PathContext> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), () -> new LocalizedException("warning.config.conflict_matcher.missing_type", new String[0]));
        Key key = Key.withDefaultNamespace(type, "craftengine");
        if (key.value().charAt(0) == '!') {
            ConditionFactory<PathContext> factory = BuiltInRegistries.PATH_MATCHER_FACTORY.getValue(new Key(key.namespace(), key.value().substring(1)));
            if (factory == null) {
                throw new LocalizedException("warning.config.conflict_matcher.invalid_type", type);
            }
            return new InvertedCondition<PathContext>(factory.create(map));
        }
        ConditionFactory<PathContext> factory = BuiltInRegistries.PATH_MATCHER_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedException("warning.config.conflict_matcher.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        PathMatchers.register(CommonConditions.ANY_OF, new AnyOfCondition.FactoryImpl<PathContext>(PathMatchers::fromMap));
        PathMatchers.register(CommonConditions.ALL_OF, new AllOfCondition.FactoryImpl<PathContext>(PathMatchers::fromMap));
        PathMatchers.register(CommonConditions.INVERTED, new InvertedCondition.FactoryImpl<PathContext>(PathMatchers::fromMap));
        PathMatchers.register(PARENT_PATH_SUFFIX, new PathMatcherParentSuffix.FactoryImpl());
        PathMatchers.register(PARENT_PATH_PREFIX, new PathMatcherParentPrefix.FactoryImpl());
        PathMatchers.register(PATTERN, new PathPatternMatcher.FactoryImpl());
        PathMatchers.register(EXACT, new PathMatcherExact.FactoryImpl());
        PathMatchers.register(FILENAME, new PathMatcherFilename.FactoryImpl());
        PathMatchers.register(CONTAINS, new PathMatcherContains.FactoryImpl());
    }
}

