/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHostFactory;
import net.momirealms.craftengine.core.pack.host.ResourcePackHosts;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.util.HashUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.AwsBasicCredentials;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.AwsCredentials;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.AwsCredentialsProvider;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.StaticCredentialsProvider;
import net.momirealms.craftengine.libraries.awssdk.core.async.AsyncRequestBody;
import net.momirealms.craftengine.libraries.awssdk.http.SdkHttpRequest;
import net.momirealms.craftengine.libraries.awssdk.http.async.SdkAsyncHttpClient;
import net.momirealms.craftengine.libraries.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import net.momirealms.craftengine.libraries.awssdk.http.nio.netty.ProxyConfiguration;
import net.momirealms.craftengine.libraries.awssdk.regions.Region;
import net.momirealms.craftengine.libraries.awssdk.services.s3.S3AsyncClient;
import net.momirealms.craftengine.libraries.awssdk.services.s3.S3AsyncClientBuilder;
import net.momirealms.craftengine.libraries.awssdk.services.s3.model.HeadObjectRequest;
import net.momirealms.craftengine.libraries.awssdk.services.s3.model.NoSuchKeyException;
import net.momirealms.craftengine.libraries.awssdk.services.s3.model.PutObjectRequest;
import net.momirealms.craftengine.libraries.awssdk.services.s3.presigner.S3Presigner;
import net.momirealms.craftengine.libraries.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import net.momirealms.craftengine.libraries.awssdk.utils.http.SdkHttpUtils;
import net.momirealms.craftengine.libraries.caffeine.cache.Cache;
import net.momirealms.craftengine.libraries.caffeine.cache.Caffeine;
import net.momirealms.craftengine.libraries.caffeine.cache.Scheduler;

public class S3Host
implements ResourcePackHost {
    public static final Factory FACTORY = new Factory();
    private final S3AsyncClient s3AsyncClient;
    private final S3Presigner preSigner;
    private final GetObjectPresignRequest presignRequest;
    private final HeadObjectRequest headObjectRequest;
    private final String bucket;
    private final String uploadPath;
    private final boolean forceCalculateSHA256;
    private final String cdnUrl;
    private final int maxRequests;
    private final int resetInterval;
    private final boolean enableRateLimit;
    private final Cache<UUID, UserAccessRecord> userAccessCache = Caffeine.newBuilder().maximumSize(256L).scheduler(Scheduler.systemScheduler()).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public S3Host(S3AsyncClient s3AsyncClient, S3Presigner preSigner, GetObjectPresignRequest presignRequest, HeadObjectRequest headObjectRequest, String bucket, String uploadPath, boolean forceCalculateSHA256, String cdnUrl, int maxRequests, int resetInterval) {
        this.s3AsyncClient = s3AsyncClient;
        this.preSigner = preSigner;
        this.presignRequest = presignRequest;
        this.headObjectRequest = headObjectRequest;
        this.bucket = bucket;
        this.uploadPath = uploadPath;
        this.forceCalculateSHA256 = forceCalculateSHA256;
        this.cdnUrl = cdnUrl;
        this.maxRequests = maxRequests;
        this.resetInterval = resetInterval;
        this.enableRateLimit = maxRequests > 0 && resetInterval > 0;
    }

    @Override
    public boolean canUpload() {
        return true;
    }

    @Override
    public Key type() {
        return ResourcePackHosts.S3;
    }

    @Override
    public CompletableFuture<List<ResourcePackDownloadData>> requestResourcePackDownloadLink(UUID player) {
        if (this.checkRateLimit(player)) {
            Debugger.RESOURCE_PACK.debug(() -> "[S3] Rate limit exceeded for player " + String.valueOf(player) + ". Skipping request.");
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.s3AsyncClient.headObject(this.headObjectRequest).handle((headResponse, exception) -> {
            if (exception != null) {
                Throwable cause = exception.getCause();
                if (cause instanceof NoSuchKeyException) {
                    NoSuchKeyException e2 = (NoSuchKeyException)cause;
                    CraftEngine.instance().logger().warn("[S3] Resource pack not found in bucket '" + this.bucket + "'. Path: " + this.uploadPath, (Throwable)e2);
                } else {
                    CraftEngine.instance().logger().warn("[S3] Failed to retrieve resource pack metadata.", (Throwable)exception);
                }
                return Collections.emptyList();
            }
            String sha1 = (String)headResponse.metadata().get("sha1");
            if (sha1 == null) {
                CraftEngine.instance().logger().warn("[S3] Missing SHA-1 checksum in object metadata. Path: " + this.uploadPath);
                throw new CompletionException(new IllegalStateException("Missing SHA-1 metadata for S3 object: " + this.uploadPath));
            }
            return Collections.singletonList(ResourcePackDownloadData.of(this.replaceWithCdnUrl(this.preSigner.presignGetObject(this.presignRequest).httpRequest()), UUID.nameUUIDFromBytes(sha1.getBytes(StandardCharsets.UTF_8)), sha1));
        });
    }

    @Override
    public CompletableFuture<Void> upload(Path resourcePackPath) {
        PutObjectRequest.Builder build = PutObjectRequest.builder().bucket(this.bucket).key(this.uploadPath).metadata(Map.of("sha1", HashUtils.calculateLocalFileSha1(resourcePackPath)));
        if (this.forceCalculateSHA256) {
            build = build.checksumSHA256(S3Host.calculateSHA256(resourcePackPath));
        }
        long uploadStart = System.currentTimeMillis();
        CraftEngine.instance().logger().info("[S3] Initiating resource pack upload to '" + this.uploadPath + "'");
        return this.s3AsyncClient.putObject((PutObjectRequest)build.build(), AsyncRequestBody.fromFile((Path)resourcePackPath)).handle((response, exception) -> {
            if (exception != null) {
                Throwable cause = exception instanceof CompletionException ? exception.getCause() : exception;
                CraftEngine.instance().logger().warn("[S3] Upload failed for path '" + this.uploadPath + "'. Error: " + cause.getClass().getSimpleName() + " - " + cause.getMessage(), (Throwable)exception);
            } else {
                CraftEngine.instance().logger().info("[S3] Successfully uploaded resource pack to '" + this.uploadPath + "' in " + (System.currentTimeMillis() - uploadStart) + " ms");
            }
            return null;
        });
    }

    private String replaceWithCdnUrl(SdkHttpRequest sdkHttpRequest) {
        String portString;
        String encodedQueryString = sdkHttpRequest.encodedQueryParameters().map(value -> "?" + value).orElse("");
        String string = portString = SdkHttpUtils.isUsingStandardPort((String)sdkHttpRequest.protocol(), (Integer)sdkHttpRequest.port()) ? "" : ":" + sdkHttpRequest.port();
        if (this.cdnUrl == null || this.cdnUrl.isEmpty()) {
            return sdkHttpRequest.protocol() + "://" + sdkHttpRequest.host() + portString + sdkHttpRequest.encodedPath() + encodedQueryString;
        }
        return this.cdnUrl + portString + sdkHttpRequest.encodedPath() + encodedQueryString;
    }

    private static String calculateSHA256(Path filePath) {
        String string;
        block9: {
            InputStream is = Files.newInputStream(filePath, new OpenOption[0]);
            try {
                int len;
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] buffer = new byte[8192];
                while ((len = is.read(buffer)) != -1) {
                    md.update(buffer, 0, len);
                }
                string = Base64.getEncoder().encodeToString(md.digest());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException e2) {
                    throw new RuntimeException("Failed to calculate SHA1", e2);
                }
            }
            is.close();
        }
        return string;
    }

    private boolean checkRateLimit(UUID user) {
        if (!this.enableRateLimit) {
            return false;
        }
        UserAccessRecord record = (UserAccessRecord)this.userAccessCache.getIfPresent((Object)user);
        long now = System.currentTimeMillis();
        if (record == null) {
            record = new UserAccessRecord(now, 1);
            this.userAccessCache.put((Object)user, (Object)record);
            return false;
        }
        if (now - record.lastAccessTime > (long)this.resetInterval) {
            record.lastAccessTime = now;
            record.accessCount = 1;
            return false;
        }
        return ++record.accessCount > this.maxRequests;
    }

    private static class UserAccessRecord {
        long lastAccessTime;
        int accessCount;

        UserAccessRecord(long lastAccessTime, int accessCount) {
            this.lastAccessTime = lastAccessTime;
            this.accessCount = accessCount;
        }
    }

    public static class Factory
    implements ResourcePackHostFactory {
        @Override
        public ResourcePackHost create(Map<String, Object> arguments) {
            boolean useEnv = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("use-environment-variables", false), "use-environment-variables");
            String endpoint = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("endpoint"), "warning.config.host.s3.missing_endpoint");
            String protocol = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.getOrDefault("protocol", "https"), "warning.config.host.s3.missing_protocol");
            URI endpointUri = URI.create(protocol + "://" + endpoint);
            boolean usePathStyle = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("path-style", false), "path-style");
            String bucket = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("bucket"), "warning.config.host.s3.missing_bucket");
            Region region = Region.of((String)ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.getOrDefault("region", "auto"), "warning.config.host.s3.missing_region"));
            String accessKeyId = ResourceConfigUtils.requireNonEmptyStringOrThrow(useEnv ? System.getenv("CE_S3_ACCESS_KEY_ID") : arguments.get("access-key-id"), "warning.config.host.s3.missing_access_key");
            String accessKeySecret = ResourceConfigUtils.requireNonEmptyStringOrThrow(useEnv ? System.getenv("CE_S3_ACCESS_KEY_SECRET") : arguments.get("access-key-secret"), "warning.config.host.s3.missing_secret");
            String uploadPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.getOrDefault("upload-path", "craftengine/resource_pack.zip"), "warning.config.host.s3.missing_upload_path");
            boolean forceCalculateSHA256 = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("force-calculate-sha256", endpoint.endsWith("r2.cloudflarestorage.com")), "force-calculate-sha256");
            Duration validity = Duration.ofSeconds(ResourceConfigUtils.getAsInt(arguments.getOrDefault("validity", 10), "validity"));
            Map<String, Object> cdn = MiscUtils.castToMap(arguments.get("cdn"), true);
            String cdnUrl = null;
            if (cdn != null) {
                String cdnDomain = ResourceConfigUtils.requireNonEmptyStringOrThrow(cdn.get("domain"), "warning.config.host.s3.missing_cdn_domain");
                String cdnProtocol = ResourceConfigUtils.requireNonEmptyStringOrThrow(cdn.getOrDefault("protocol", "https"), "warning.config.host.s3.missing_cdn_protocol");
                cdnUrl = cdnProtocol + "://" + cdnDomain;
            }
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKeyId, (String)accessKeySecret);
            S3AsyncClientBuilder s3AsyncClientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().endpointOverride(endpointUri)).region(region)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).serviceConfiguration(b2 -> b2.pathStyleAccessEnabled(Boolean.valueOf(usePathStyle)));
            Map<String, Object> proxySetting = MiscUtils.castToMap(arguments.get("proxy"), true);
            if (proxySetting != null) {
                String host = ResourceConfigUtils.requireNonEmptyStringOrThrow(proxySetting.get("host"), "warning.config.host.proxy.missing_host");
                int port = ResourceConfigUtils.getAsInt(proxySetting.get("port"), "port");
                if (port <= 0 || port > 65535) {
                    throw new LocalizedException("warning.config.host.proxy.missing_port", new String[0]);
                }
                String scheme = ResourceConfigUtils.requireNonEmptyStringOrThrow(proxySetting.get("scheme"), "warning.config.host.proxy.missing_scheme");
                String username = Optional.ofNullable(proxySetting.get("username")).map(String::valueOf).orElse(null);
                String password = Optional.ofNullable(proxySetting.get("password")).map(String::valueOf).orElse(null);
                ProxyConfiguration.Builder builder = ProxyConfiguration.builder().host(host).port(port).scheme(scheme);
                if (username != null) {
                    builder = builder.username(username);
                }
                if (password != null) {
                    builder = builder.password(password);
                }
                SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().proxyConfiguration((ProxyConfiguration)builder.build()).build();
                s3AsyncClientBuilder = (S3AsyncClientBuilder)s3AsyncClientBuilder.httpClient(httpClient);
            }
            S3AsyncClient s3AsyncClient = (S3AsyncClient)s3AsyncClientBuilder.build();
            S3Presigner preSigner = S3Presigner.builder().endpointOverride(endpointUri).region(region).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials)).build();
            GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().signatureDuration(validity).getObjectRequest(b2 -> b2.bucket(bucket).key(uploadPath)).build();
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(uploadPath).build();
            Map<String, Object> rateMap = MiscUtils.castToMap(arguments.get("rate-map"), true);
            int maxRequests = -1;
            int resetInterval = -1;
            if (rateMap != null) {
                maxRequests = ResourceConfigUtils.getAsInt(rateMap.getOrDefault("max-requests", 5), "max-requests");
                resetInterval = ResourceConfigUtils.getAsInt(rateMap.getOrDefault("reset-interval", 20), "reset-interval") * 1000;
            }
            return new S3Host(s3AsyncClient, preSigner, presignRequest, headObjectRequest, bucket, uploadPath, forceCalculateSHA256, cdnUrl, maxRequests, resetInterval);
        }
    }
}

