/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModelFactory;
import net.momirealms.craftengine.core.pack.model.ItemModelReader;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.revision.Revision;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersion;
import net.momirealms.craftengine.core.util.MiscUtils;

public class CompositeItemModel
implements ItemModel {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final List<ItemModel> models;

    public CompositeItemModel(List<ItemModel> models) {
        this.models = models;
    }

    public List<ItemModel> models() {
        return this.models;
    }

    @Override
    public JsonObject apply(MinecraftVersion version) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type().toString());
        JsonArray array = new JsonArray();
        for (ItemModel model : this.models) {
            array.add((JsonElement)model.apply(version));
        }
        json.add("models", (JsonElement)array);
        return json;
    }

    @Override
    public Key type() {
        return ItemModels.COMPOSITE;
    }

    @Override
    public List<Revision> revisions() {
        ArrayList<Revision> versions = new ArrayList<Revision>();
        for (ItemModel model : this.models) {
            versions.addAll(model.revisions());
        }
        return versions;
    }

    @Override
    public List<ModelGeneration> modelsToGenerate() {
        ArrayList<ModelGeneration> models = new ArrayList<ModelGeneration>(4);
        for (ItemModel model : this.models) {
            models.addAll(model.modelsToGenerate());
        }
        return models;
    }

    public static class Factory
    implements ItemModelFactory {
        @Override
        public ItemModel create(Map<String, Object> arguments) {
            Object m = arguments.get("models");
            if (m instanceof List) {
                List list = (List)m;
                List models = list;
                if (models.isEmpty()) {
                    throw new LocalizedResourceConfigException("warning.config.item.model.composite.missing_models", new String[0]);
                }
                ArrayList<ItemModel> modelList = new ArrayList<ItemModel>();
                for (Map model : models) {
                    modelList.add(ItemModels.fromMap(model));
                }
                return new CompositeItemModel(modelList);
            }
            if (m instanceof Map) {
                Map map = (Map)m;
                return new CompositeItemModel(List.of(ItemModels.fromMap(MiscUtils.castToMap(map, false))));
            }
            throw new LocalizedResourceConfigException("warning.config.item.model.composite.missing_models", new String[0]);
        }
    }

    public static class Reader
    implements ItemModelReader {
        @Override
        public ItemModel read(JsonObject json) {
            JsonArray models = json.getAsJsonArray("models");
            if (models == null) {
                throw new IllegalArgumentException("models is expected to be a JsonArray");
            }
            ArrayList<ItemModel> modelList = new ArrayList<ItemModel>();
            for (JsonElement model : models) {
                if (model instanceof JsonObject) {
                    JsonObject jo = (JsonObject)model;
                    modelList.add(ItemModels.fromJson(jo));
                    continue;
                }
                throw new IllegalArgumentException("model is expected to be a JsonObject");
            }
            return new CompositeItemModel(modelList);
        }
    }
}

