/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class LegacyItemModel {
    private final List<ModelGeneration> modelsToGenerate;
    private final String path;
    private final List<LegacyOverridesModel> overrides;

    public LegacyItemModel(String path, List<LegacyOverridesModel> overrides, List<ModelGeneration> modelsToGenerate) {
        this.modelsToGenerate = modelsToGenerate;
        this.path = path;
        this.overrides = overrides;
    }

    public List<ModelGeneration> modelsToGenerate() {
        return this.modelsToGenerate;
    }

    public List<LegacyOverridesModel> overrides() {
        return this.overrides;
    }

    public String path() {
        return this.path;
    }

    public static LegacyItemModel fromMap(Map<String, Object> legacyModel, int customModelData) {
        List overrides;
        String legacyModelPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(legacyModel.get("path"), "warning.config.item.legacy_model.missing_path");
        Map<String, Object> generation = MiscUtils.castToMap(legacyModel.get("generation"), true);
        ModelGeneration baseModelGeneration = null;
        if (generation != null) {
            baseModelGeneration = ModelGeneration.of(Key.of(legacyModelPath), generation);
        }
        if ((overrides = (List)legacyModel.get("overrides")) != null) {
            ArrayList<ModelGeneration> modelGenerations = new ArrayList<ModelGeneration>();
            ArrayList<LegacyOverridesModel> legacyOverridesModels = new ArrayList<LegacyOverridesModel>();
            if (baseModelGeneration != null) {
                modelGenerations.add(baseModelGeneration);
            }
            legacyOverridesModels.add(new LegacyOverridesModel(new HashMap<String, Object>(), legacyModelPath, customModelData));
            for (Map override : overrides) {
                String overrideModelPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(override.get("path"), () -> new LocalizedResourceConfigException("warning.config.item.legacy_model.overrides.missing_path", new String[0]));
                Map<String, Object> predicate = MiscUtils.castToMap(ResourceConfigUtils.requireNonNullOrThrow(override.get("predicate"), "warning.config.item.legacy_model.overrides.missing_predicate"), false);
                if (predicate.isEmpty()) {
                    throw new LocalizedResourceConfigException("warning.config.item.legacy_model.overrides.missing_predicate", new String[0]);
                }
                Map<String, Object> overrideGeneration = MiscUtils.castToMap(override.get("generation"), true);
                if (overrideGeneration != null) {
                    modelGenerations.add(ModelGeneration.of(Key.of(overrideModelPath), overrideGeneration));
                }
                legacyOverridesModels.add(new LegacyOverridesModel(predicate, overrideModelPath, customModelData));
            }
            return new LegacyItemModel(legacyModelPath, legacyOverridesModels, modelGenerations);
        }
        return new LegacyItemModel(legacyModelPath, List.of(new LegacyOverridesModel(new HashMap<String, Object>(), legacyModelPath, customModelData)), baseModelGeneration == null ? List.of() : List.of(baseModelGeneration));
    }
}

