/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModelFactory;
import net.momirealms.craftengine.core.pack.model.ItemModelReader;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperties;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.revision.Revision;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersion;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeDispatchItemModel
implements ItemModel {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final RangeDispatchProperty property;
    private final float scale;
    private final ItemModel fallBack;
    private final Map<Float, ItemModel> entries;

    public RangeDispatchItemModel(@NotNull RangeDispatchProperty property, float scale, @Nullable ItemModel fallBack, @NotNull Map<Float, ItemModel> entries) {
        this.property = property;
        this.scale = scale;
        this.fallBack = fallBack;
        this.entries = entries;
    }

    public RangeDispatchProperty property() {
        return this.property;
    }

    public float scale() {
        return this.scale;
    }

    @Nullable
    public ItemModel fallBack() {
        return this.fallBack;
    }

    public Map<Float, ItemModel> entries() {
        return this.entries;
    }

    @Override
    public JsonObject apply(MinecraftVersion version) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type().toString());
        this.property.accept(json);
        JsonArray array = new JsonArray();
        for (Map.Entry<Float, ItemModel> entry : this.entries.entrySet()) {
            float threshold = entry.getKey().floatValue();
            ItemModel model = entry.getValue();
            JsonObject jo = new JsonObject();
            jo.addProperty("threshold", (Number)Float.valueOf(threshold));
            jo.add("model", (JsonElement)model.apply(version));
            array.add((JsonElement)jo);
        }
        json.add("entries", (JsonElement)array);
        if (this.scale != 1.0f) {
            json.addProperty("scale", (Number)Float.valueOf(this.scale));
        }
        if (this.fallBack != null) {
            json.add("fallback", (JsonElement)this.fallBack.apply(version));
        }
        return json;
    }

    @Override
    public Key type() {
        return ItemModels.RANGE_DISPATCH;
    }

    @Override
    public List<Revision> revisions() {
        ArrayList<Revision> versions = new ArrayList<Revision>(4);
        if (this.fallBack != null) {
            versions.addAll(this.fallBack.revisions());
        }
        for (ItemModel model : this.entries.values()) {
            versions.addAll(model.revisions());
        }
        return versions;
    }

    @Override
    public List<ModelGeneration> modelsToGenerate() {
        ArrayList<ModelGeneration> models = new ArrayList<ModelGeneration>(4);
        if (this.fallBack != null) {
            models.addAll(this.fallBack.modelsToGenerate());
        }
        for (ItemModel model : this.entries.values()) {
            models.addAll(model.modelsToGenerate());
        }
        return models;
    }

    public static class Factory
    implements ItemModelFactory {
        @Override
        public ItemModel create(Map<String, Object> arguments) {
            RangeDispatchProperty property = RangeDispatchProperties.fromMap(arguments);
            float scale = ResourceConfigUtils.getAsFloat(arguments.getOrDefault("scale", 1.0), "scale");
            Map<String, Object> fallback = MiscUtils.castToMap(arguments.get("fallback"), true);
            Object entriesObj = arguments.get("entries");
            if (entriesObj instanceof List) {
                List list = (List)entriesObj;
                List entries = list;
                if (!entries.isEmpty()) {
                    HashMap<Float, ItemModel> entryMap = new HashMap<Float, ItemModel>();
                    for (Map entry : entries) {
                        float threshold = ResourceConfigUtils.getAsFloat(entry.getOrDefault("threshold", 1), "threshold");
                        Map<String, Object> model = entry.getOrDefault("model", fallback);
                        if (model == null) {
                            throw new LocalizedResourceConfigException("warning.config.item.model.range_dispatch.entry.missing_model", new String[0]);
                        }
                        entryMap.put(Float.valueOf(threshold), ItemModels.fromMap(MiscUtils.castToMap(model, false)));
                    }
                    return new RangeDispatchItemModel(property, scale, fallback == null ? null : ItemModels.fromMap(fallback), entryMap);
                }
                throw new LocalizedResourceConfigException("warning.config.item.model.range_dispatch.missing_entries", new String[0]);
            }
            throw new LocalizedResourceConfigException("warning.config.item.model.range_dispatch.missing_entries", new String[0]);
        }
    }

    public static class Reader
    implements ItemModelReader {
        @Override
        public ItemModel read(JsonObject json) {
            JsonArray entriesObj = json.getAsJsonArray("entries");
            if (entriesObj == null) {
                throw new IllegalArgumentException("entries is expected to be a JsonArray");
            }
            HashMap<Float, ItemModel> entries = new HashMap<Float, ItemModel>();
            for (JsonElement entry : entriesObj) {
                if (!(entry instanceof JsonObject)) continue;
                JsonObject entryObj = (JsonObject)entry;
                float threshold = entryObj.getAsJsonPrimitive("threshold").getAsFloat();
                ItemModel model = ItemModels.fromJson(entryObj.getAsJsonObject("model"));
                entries.put(Float.valueOf(threshold), model);
            }
            return new RangeDispatchItemModel(RangeDispatchProperties.fromJson(json), json.has("scale") ? json.get("scale").getAsFloat() : 1.0f, json.has("fallback") ? ItemModels.fromJson(json.getAsJsonObject("fallback")) : null, entries);
        }
    }
}

