/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.revision;

import java.util.Objects;
import net.momirealms.craftengine.core.util.MinecraftVersion;
import net.momirealms.craftengine.core.util.MinecraftVersions;

public interface Revision {
    public int minPackVersion();

    public int maxPackVersion();

    public String versionString();

    public boolean matches(MinecraftVersion var1, MinecraftVersion var2);

    public MinecraftVersion minVersion();

    public MinecraftVersion maxVersion();

    public static Revision since(MinecraftVersion minecraftVersion) {
        return new Since(minecraftVersion);
    }

    public static Revision fromTo(MinecraftVersion from, MinecraftVersion to) {
        return new FromTo(from, to);
    }

    public static class Since
    implements Revision {
        private final MinecraftVersion minVersion;
        private String versionString;

        public Since(MinecraftVersion minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public MinecraftVersion maxVersion() {
            return MinecraftVersions.FUTURE;
        }

        @Override
        public MinecraftVersion minVersion() {
            return this.minVersion;
        }

        @Override
        public String versionString() {
            if (this.versionString == null) {
                this.versionString = this.minVersion.version().replace(".", "_");
            }
            return this.versionString;
        }

        @Override
        public boolean matches(MinecraftVersion min, MinecraftVersion max) {
            return this.minVersion.isAtOrBelow(max) && min.isBelow(this.minVersion);
        }

        @Override
        public int maxPackVersion() {
            return MinecraftVersions.FUTURE.packFormat();
        }

        @Override
        public int minPackVersion() {
            return this.minVersion.packFormat();
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Since)) {
                return false;
            }
            Since since = (Since)object;
            return this.minVersion.equals(since.minVersion);
        }

        public int hashCode() {
            return this.minVersion.hashCode();
        }
    }

    public static class FromTo
    implements Revision {
        private final MinecraftVersion minVersion;
        private final MinecraftVersion maxVersion;
        private String versionString;

        public FromTo(MinecraftVersion minVersion, MinecraftVersion maxVersion) {
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        }

        @Override
        public MinecraftVersion maxVersion() {
            return this.maxVersion;
        }

        @Override
        public MinecraftVersion minVersion() {
            return this.minVersion;
        }

        @Override
        public boolean matches(MinecraftVersion min, MinecraftVersion max) {
            return !min.isAbove(this.maxVersion) || !max.isBelow(this.minVersion);
        }

        @Override
        public int minPackVersion() {
            return this.minVersion.packFormat();
        }

        @Override
        public int maxPackVersion() {
            return this.maxVersion.packFormat();
        }

        @Override
        public String versionString() {
            if (this.versionString == null) {
                this.versionString = this.minVersion.version().replace(".", "_") + "-" + this.maxVersion.version().replace(".", "_");
            }
            return this.versionString;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof FromTo)) {
                return false;
            }
            FromTo fromTo = (FromTo)object;
            return Objects.equals(this.minVersion, fromTo.minVersion) && Objects.equals(this.maxVersion, fromTo.maxVersion);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.minVersion);
            result = 31 * result + Objects.hashCode(this.maxVersion);
            return result;
        }
    }
}

