/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config;

import java.nio.file.Path;
import java.util.Map;
import net.momirealms.craftengine.core.pack.CachedConfigSection;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.AbstractConfigParser;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public abstract class IdSectionConfigParser
extends AbstractConfigParser {
    @Override
    protected void parseSection(CachedConfigSection cached) {
        for (Map.Entry<String, Object> configEntry : cached.config().entrySet()) {
            String key = configEntry.getKey();
            Key id = Key.withDefaultNamespace(key, cached.pack().namespace());
            Object object = configEntry.getValue();
            if (!(object instanceof Map)) {
                TranslationManager.instance().log("warning.config.structure.not_section", cached.filePath().toString(), cached.prefix() + "." + key, configEntry.getValue().getClass().getSimpleName());
                continue;
            }
            Map section = (Map)object;
            Map<String, Object> config = MiscUtils.castToMap(section, false);
            if (((Boolean)config.getOrDefault("debug", false)).booleanValue()) {
                CraftEngine.instance().logger().info(GsonHelper.get().toJson(CraftEngine.instance().templateManager().applyTemplates(id, config)));
            }
            if (!((Boolean)config.getOrDefault("enable", true)).booleanValue()) continue;
            String node = cached.prefix() + "." + key;
            ResourceConfigUtils.runCatching(cached.filePath(), node, () -> this.parseSection(cached.pack(), cached.filePath(), node, id, MiscUtils.castToMap(CraftEngine.instance().templateManager().applyTemplates(id, config), false)), () -> GsonHelper.get().toJson((Object)section));
        }
    }

    protected abstract void parseSection(Pack var1, Path var2, String var3, Key var4, Map<String, Object> var5) throws LocalizedException;
}

