/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config.template;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.IdObjectConfigParser;
import net.momirealms.craftengine.core.plugin.config.template.ListTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.NullTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.ObjectTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.PlainStringTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArguments;
import net.momirealms.craftengine.core.plugin.config.template.TemplateManager;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import org.jetbrains.annotations.NotNull;

public class TemplateManagerImpl
implements TemplateManager {
    private static final TemplateManager.ArgumentString TEMPLATE = TemplateManager.Literal.literal("template");
    private static final TemplateManager.ArgumentString OVERRIDES = TemplateManager.Literal.literal("overrides");
    private static final TemplateManager.ArgumentString ARGUMENTS = TemplateManager.Literal.literal("arguments");
    private static final TemplateManager.ArgumentString MERGES = TemplateManager.Literal.literal("merges");
    private static final Set<TemplateManager.ArgumentString> NON_TEMPLATE_ARGUMENTS = new HashSet<TemplateManager.ArgumentString>(Set.of(TEMPLATE, ARGUMENTS, OVERRIDES, MERGES));
    private final Map<Key, Object> templates = new HashMap<Key, Object>();
    private final TemplateParser templateParser = new TemplateParser();

    @Override
    public void unload() {
        this.templates.clear();
    }

    @Override
    public ConfigParser parser() {
        return this.templateParser;
    }

    @Override
    public Object applyTemplates(Key id, Object input) {
        Object preprocessedInput = this.preprocessUnknownValue(input);
        return this.processUnknownValue(preprocessedInput, Map.of("__NAMESPACE__", PlainStringTemplateArgument.plain(id.namespace()), "__ID__", PlainStringTemplateArgument.plain(id.value())));
    }

    private Object preprocessUnknownValue(Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, List.class, String.class}, (Object)object, n)) {
            case 0: {
                Map map = (Map)object;
                Map<String, Object> in = MiscUtils.castToMap(map, false);
                LinkedHashMap<TemplateManager.ArgumentString, Object> out = new LinkedHashMap<TemplateManager.ArgumentString, Object>(map.size());
                for (Map.Entry<String, Object> entry : in.entrySet()) {
                    out.put(TemplateManager.preParse(entry.getKey()), this.preprocessUnknownValue(entry.getValue()));
                }
                return out;
            }
            case 1: {
                List list = (List)object;
                ArrayList<Object> objList = new ArrayList<Object>(list.size());
                for (Object o : list) {
                    objList.add(this.preprocessUnknownValue(o));
                }
                return objList;
            }
            case 2: {
                String string = (String)object;
                return TemplateManager.preParse(string);
            }
        }
        return value;
    }

    private Object processMap(Map<TemplateManager.ArgumentString, Object> input, Map<String, TemplateArgument> arguments) {
        if (input.containsKey(TEMPLATE)) {
            Cloneable output;
            TemplateProcessingResult processingResult = this.processTemplates(input, arguments);
            List<Object> processedTemplates = processingResult.templates();
            if (!processedTemplates.isEmpty()) {
                Object firstTemplate = processedTemplates.getFirst();
                if (firstTemplate instanceof Map) {
                    Object processedTemplate2;
                    LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
                    for (Object processedTemplate2 : processedTemplates) {
                        if (!(processedTemplate2 instanceof Map)) continue;
                        Map map = (Map)processedTemplate2;
                        MiscUtils.deepMergeMaps(results, MiscUtils.castToMap(map, false));
                    }
                    processedTemplate2 = processingResult.overrides();
                    if (processedTemplate2 instanceof Map) {
                        Map overrides = (Map)processedTemplate2;
                        results.putAll(MiscUtils.castToMap(overrides, false));
                    }
                    if ((processedTemplate2 = processingResult.merges()) instanceof Map) {
                        Map merges = (Map)processedTemplate2;
                        MiscUtils.deepMergeMaps(results, MiscUtils.castToMap(merges, false));
                    }
                    return results;
                }
                if (firstTemplate instanceof List) {
                    Object processedTemplate3;
                    ArrayList results = new ArrayList();
                    for (Object processedTemplate3 : processedTemplates) {
                        if (!(processedTemplate3 instanceof List)) continue;
                        List anotherList = (List)processedTemplate3;
                        results.addAll(anotherList);
                    }
                    processedTemplate3 = processingResult.overrides();
                    if (processedTemplate3 instanceof List) {
                        List overrides = (List)processedTemplate3;
                        results.clear();
                        results.addAll(overrides);
                    }
                    if ((processedTemplate3 = processingResult.merges()) instanceof List) {
                        List merges = (List)processedTemplate3;
                        results.addAll(merges);
                    }
                    return results;
                }
                if (processingResult.overrides() != null) {
                    return processingResult.overrides();
                }
                if (processingResult.merges() != null) {
                    return processingResult.merges();
                }
                return processedTemplates.getLast();
            }
            Object merges = processingResult.overrides();
            if (merges instanceof Map) {
                Map overrides = (Map)merges;
                output = new LinkedHashMap<String, Object>(MiscUtils.castToMap(overrides, false));
                Object object = processingResult.merges();
                if (object instanceof Map) {
                    Map merges2 = (Map)object;
                    MiscUtils.deepMergeMaps(output, MiscUtils.castToMap(merges2, false));
                }
                return output;
            }
            output = processingResult.overrides();
            if (output instanceof List) {
                List overrides = (List)((Object)output);
                output = new ArrayList(overrides);
                Object object = processingResult.merges();
                if (object instanceof List) {
                    List merges3 = (List)object;
                    output.addAll(merges3);
                }
                return output;
            }
            if (processingResult.overrides() != null) {
                return processingResult.overrides();
            }
            if (processingResult.merges() != null) {
                return processingResult.merges();
            }
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry<TemplateManager.ArgumentString, Object> inputEntry : input.entrySet()) {
            Object key = inputEntry.getKey().get(arguments);
            if (key == null) continue;
            result.put(key.toString(), this.processUnknownValue(inputEntry.getValue(), arguments));
        }
        return result;
    }

    private Object processUnknownValue(Object value, Map<String, TemplateArgument> arguments) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, List.class, TemplateManager.ArgumentString.class}, (Object)object, n)) {
            case 0: {
                Map innerMap = (Map)object;
                return this.processMap(innerMap, arguments);
            }
            case 1: {
                List innerList = (List)object;
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object item : innerList) {
                    result.add(this.processUnknownValue(item, arguments));
                }
                return result;
            }
            case 2: {
                TemplateManager.ArgumentString arg = (TemplateManager.ArgumentString)object;
                return arg.get(arguments);
            }
        }
        return value;
    }

    private TemplateProcessingResult processTemplates(Map<TemplateManager.ArgumentString, Object> input, Map<String, TemplateArgument> parentArguments) {
        Object merge;
        boolean hasMerges;
        boolean hasOverrides;
        boolean hasArgument;
        int knownKeys = 1;
        List<TemplateManager.ArgumentString> templateIds = MiscUtils.getAsList(input.get(TEMPLATE), TemplateManager.ArgumentString.class);
        ArrayList<Object> templateList = new ArrayList<Object>(templateIds.size());
        Object argument = input.get(ARGUMENTS);
        boolean bl = hasArgument = argument != null;
        if (hasArgument) {
            ++knownKeys;
        }
        Map<String, TemplateArgument> arguments = hasArgument ? this.mergeArguments((Map)argument, parentArguments) : parentArguments;
        for (TemplateManager.ArgumentString templateId : templateIds) {
            Object template;
            Object processedTemplate;
            Object actualTemplate = templateId.get(parentArguments);
            if (actualTemplate == null || (processedTemplate = this.processUnknownValue(template = Optional.ofNullable(this.templates.get(Key.of(actualTemplate.toString()))).orElseThrow(() -> new LocalizedResourceConfigException("warning.config.template.invalid", actualTemplate.toString())), arguments)) == null) continue;
            templateList.add(processedTemplate);
        }
        Object override = input.get(OVERRIDES);
        boolean bl2 = hasOverrides = override != null;
        if (hasOverrides) {
            ++knownKeys;
            override = this.processUnknownValue(override, arguments);
        }
        boolean bl3 = hasMerges = (merge = input.get(MERGES)) != null;
        if (hasMerges) {
            ++knownKeys;
            merge = this.processUnknownValue(merge, arguments);
        }
        if (input.size() > knownKeys) {
            LinkedHashMap<String, Object> merges = new LinkedHashMap<String, Object>();
            for (Map.Entry<TemplateManager.ArgumentString, Object> inputEntry : input.entrySet()) {
                Object key;
                TemplateManager.ArgumentString inputKey = inputEntry.getKey();
                if (NON_TEMPLATE_ARGUMENTS.contains(inputKey) || (key = inputKey.get(parentArguments)) == null) continue;
                merges.put(key.toString(), this.processUnknownValue(inputEntry.getValue(), arguments));
            }
            if (hasMerges && merge instanceof Map) {
                Map rawMerges;
                Map mergeMap = rawMerges = (Map)merge;
                for (Map.Entry inputEntry : mergeMap.entrySet()) {
                    TemplateManager.ArgumentString inputKey = (TemplateManager.ArgumentString)inputEntry.getKey();
                    Object key = inputKey.get(parentArguments);
                    if (key == null) continue;
                    merges.put(key.toString(), this.processUnknownValue(inputEntry.getValue(), arguments));
                }
            }
            return new TemplateProcessingResult(templateList, override, merges, arguments);
        }
        return new TemplateProcessingResult(templateList, override, merge, arguments);
    }

    private Map<String, TemplateArgument> mergeArguments(@NotNull Map<TemplateManager.ArgumentString, Object> childArguments, @NotNull Map<String, TemplateArgument> parentArguments) {
        LinkedHashMap<String, TemplateArgument> result = new LinkedHashMap<String, TemplateArgument>(parentArguments);
        block5: for (Map.Entry<TemplateManager.ArgumentString, Object> argumentEntry : childArguments.entrySet()) {
            Object processedPlaceholderValue;
            String placeholder;
            Object placeholderObj = argumentEntry.getKey().get(result);
            if (placeholderObj == null || result.containsKey(placeholder = placeholderObj.toString())) continue;
            Object object = processedPlaceholderValue = this.processUnknownValue(argumentEntry.getValue(), result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, List.class}, (Object)object, n)) {
                case 0: {
                    Map map = (Map)object;
                    result.put(placeholder, TemplateArguments.fromMap(MiscUtils.castToMap(map, false)));
                    continue block5;
                }
                case 1: {
                    List listArgument = (List)object;
                    result.put(placeholder, new ListTemplateArgument(listArgument));
                    continue block5;
                }
                case -1: {
                    result.put(placeholder, NullTemplateArgument.INSTANCE);
                    continue block5;
                }
            }
            result.put(placeholder, new ObjectTemplateArgument(processedPlaceholderValue));
        }
        return result;
    }

    public class TemplateParser
    extends IdObjectConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"templates", "template"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 0;
        }

        @Override
        public void parseObject(Pack pack, Path path, String node, Key id, Object obj) {
            if (TemplateManagerImpl.this.templates.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.template.duplicate", new String[0]);
            }
            TemplateManagerImpl.this.templates.put(id, TemplateManagerImpl.this.preprocessUnknownValue(obj));
        }
    }

    private record TemplateProcessingResult(List<Object> templates, Object overrides, Object merges, Map<String, TemplateArgument> arguments) {
    }
}

