/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import java.util.List;
import java.util.Optional;
import net.momirealms.craftengine.core.plugin.context.AdditionalParameterProvider;
import net.momirealms.craftengine.core.plugin.context.CommonParameterProvider;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.text.minimessage.ExpressionTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.GlobalVariableTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.I18NTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ImageTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.NamedArgumentTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.PlaceholderTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ShiftTag;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommonContext
implements Context {
    protected final ContextHolder contexts;
    protected final List<AdditionalParameterProvider> additionalParameterProviders;
    protected TagResolver[] tagResolvers;

    public AbstractCommonContext(ContextHolder contexts) {
        this.contexts = contexts;
        this.additionalParameterProviders = List.of(new CommonParameterProvider());
    }

    public AbstractCommonContext(ContextHolder contexts, List<AdditionalParameterProvider> additionalParameterProviders) {
        this.contexts = contexts;
        this.additionalParameterProviders = additionalParameterProviders;
    }

    @Override
    public ContextHolder contexts() {
        return this.contexts;
    }

    @Override
    @NotNull
    public TagResolver[] tagResolvers() {
        if (this.tagResolvers == null) {
            this.tagResolvers = new TagResolver[]{ShiftTag.INSTANCE, ImageTag.INSTANCE, new I18NTag(this), new NamedArgumentTag(this), new PlaceholderTag(this), new ExpressionTag(this), new GlobalVariableTag(this)};
        }
        return this.tagResolvers;
    }

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter) {
        if (!this.additionalParameterProviders.isEmpty()) {
            for (AdditionalParameterProvider additionalParameterProvider : this.additionalParameterProviders) {
                Optional<T> optionalValue = additionalParameterProvider.getOptionalParameter(parameter);
                if (!optionalValue.isPresent()) continue;
                return optionalValue;
            }
        }
        return this.contexts.getOptional(parameter);
    }
}

