/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class AllOfCondition<CTX extends Context>
implements Condition<CTX> {
    protected final Predicate<CTX> condition;

    public AllOfCondition(List<? extends Condition<CTX>> conditions) {
        this.condition = MiscUtils.allOf(conditions);
    }

    @Override
    public boolean test(CTX ctx) {
        return this.condition.test(ctx);
    }

    @Override
    public Key type() {
        return CommonConditions.ALL_OF;
    }

    public static class FactoryImpl<CTX extends Context>
    implements ConditionFactory<CTX> {
        private final Function<Map<String, Object>, Condition<CTX>> factory;

        public FactoryImpl(Function<Map<String, Object>, Condition<CTX>> factory) {
            this.factory = factory;
        }

        @Override
        public Condition<CTX> create(Map<String, Object> arguments) {
            Object termsArg = ResourceConfigUtils.requireNonNullOrThrow(ResourceConfigUtils.get(arguments, "terms", "term"), "warning.config.condition.all_of.missing_terms");
            if (termsArg instanceof Map) {
                Map map = (Map)termsArg;
                return new AllOfCondition<CTX>(List.of(this.factory.apply(MiscUtils.castToMap(map, false))));
            }
            if (termsArg instanceof List) {
                List list = (List)termsArg;
                ArrayList<Condition<CTX>> conditions = new ArrayList<Condition<CTX>>();
                for (Map term : list) {
                    conditions.add(this.factory.apply(term));
                }
                return new AllOfCondition(conditions);
            }
            throw new LocalizedResourceConfigException("warning.config.condition.all_of.invalid_terms_type", termsArg.getClass().getSimpleName());
        }
    }
}

