/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.RandomUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class TableBonusCondition<CTX extends Context>
implements Condition<CTX> {
    private final Key enchantmentType;
    private final List<Float> values;

    public TableBonusCondition(Key enchantmentType, List<Float> values) {
        this.enchantmentType = enchantmentType;
        this.values = values;
    }

    @Override
    public Key type() {
        return CommonConditions.TABLE_BONUS;
    }

    @Override
    public boolean test(CTX ctx) {
        Optional<Item<?>> item = ctx.getOptionalParameter(DirectContextParameters.ITEM_IN_HAND);
        int level = item.map(value -> value.getEnchantment(this.enchantmentType).map(Enchantment::level).orElse(0)).orElse(0);
        float f = this.values.get(Math.min(level, this.values.size() - 1)).floatValue();
        return RandomUtils.generateRandomFloat(0.0f, 1.0f) < f;
    }

    public static class FactoryImpl<CTX extends Context>
    implements ConditionFactory<CTX> {
        @Override
        public Condition<CTX> create(Map<String, Object> arguments) {
            Object enchantmentObj = arguments.get("enchantment");
            if (enchantmentObj == null) {
                throw new LocalizedResourceConfigException("warning.config.condition.table_bonus.missing_enchantment", new String[0]);
            }
            Key enchantmentType = Key.of(enchantmentObj.toString());
            Object chances = arguments.get("chances");
            if (chances != null) {
                if (chances instanceof Number) {
                    Number number = (Number)chances;
                    return new TableBonusCondition(enchantmentType, List.of(Float.valueOf(number.floatValue())));
                }
                if (chances instanceof List) {
                    List list = (List)chances;
                    ArrayList<Float> values = new ArrayList<Float>(list.size());
                    for (Object o : list) {
                        values.add(Float.valueOf(ResourceConfigUtils.getAsFloat(o, "chances")));
                    }
                    return new TableBonusCondition(enchantmentType, values);
                }
            }
            throw new LocalizedResourceConfigException("warning.config.condition.table_bonus.missing_chances", new String[0]);
        }
    }
}

