/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.function.FunctionFactory;
import net.momirealms.craftengine.core.util.MiscUtils;

public abstract class AbstractConditionalFunction<CTX extends Context>
implements Function<CTX> {
    protected final List<Condition<CTX>> predicates;
    private final Predicate<CTX> compositePredicates;

    public AbstractConditionalFunction(List<Condition<CTX>> predicates) {
        this.predicates = predicates;
        this.compositePredicates = MiscUtils.allOf(predicates);
    }

    @Override
    public void run(CTX ctx) {
        if (this.compositePredicates.test(ctx)) {
            this.runInternal(ctx);
        }
    }

    protected abstract void runInternal(CTX var1);

    public static abstract class AbstractFactory<CTX extends Context>
    implements FunctionFactory<CTX> {
        private final java.util.function.Function<Map<String, Object>, Condition<CTX>> factory;

        public AbstractFactory(java.util.function.Function<Map<String, Object>, Condition<CTX>> factory) {
            this.factory = factory;
        }

        public java.util.function.Function<Map<String, Object>, Condition<CTX>> conditionFactory() {
            return this.factory;
        }

        protected List<Condition<CTX>> getPredicates(Map<String, Object> arguments) {
            Object predicates = arguments.get("conditions");
            if (predicates == null) {
                return List.of();
            }
            if (predicates instanceof List) {
                List list = (List)predicates;
                ArrayList<Condition<CTX>> conditions = new ArrayList<Condition<CTX>>(list.size());
                for (Object o : list) {
                    conditions.add(this.factory.apply(MiscUtils.castToMap(o, false)));
                }
                return conditions;
            }
            if (predicates instanceof Map) {
                Map map = (Map)predicates;
                return List.of(this.factory.apply(MiscUtils.castToMap(map, false)));
            }
            throw new UnsupportedOperationException("Unsupported conditions argument class type: " + predicates.getClass().getSimpleName());
        }
    }
}

