/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.function;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.Platform;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.ViewerContext;
import net.momirealms.craftengine.core.plugin.context.function.AbstractConditionalFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommonFunctions;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelector;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelectors;
import net.momirealms.craftengine.core.plugin.context.text.TextProvider;
import net.momirealms.craftengine.core.plugin.context.text.TextProviders;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.Nullable;

public class CommandFunction<CTX extends Context>
extends AbstractConditionalFunction<CTX> {
    private final List<TextProvider> command;
    private final PlayerSelector<CTX> selector;
    private final boolean asPlayer;
    private final boolean asEvent;
    private final boolean asOp;

    public CommandFunction(List<Condition<CTX>> predicates, @Nullable PlayerSelector<CTX> selector, List<TextProvider> command, boolean asPlayer, boolean asEvent, boolean asOp) {
        super(predicates);
        this.command = command;
        this.selector = selector;
        this.asPlayer = asPlayer;
        this.asEvent = asEvent;
        this.asOp = asOp;
    }

    @Override
    public void runInternal(CTX ctx) {
        if (this.asPlayer || this.asOp) {
            if (this.selector == null) {
                ctx.getOptionalParameter(DirectContextParameters.PLAYER).ifPresent(player -> this.executeCommands((Context)ctx, this.asEvent ? player::performCommandAsEvent : command1 -> player.performCommand((String)command1, this.asOp)));
            } else {
                for (Player viewer : this.selector.get(ctx)) {
                    ViewerContext relationalContext = ViewerContext.of(ctx, PlayerOptionalContext.of(viewer));
                    this.executeCommands(relationalContext, this.asEvent ? viewer::performCommandAsEvent : command1 -> viewer.performCommand((String)command1, this.asOp));
                }
            }
        } else {
            Platform platform = CraftEngine.instance().platform();
            for (TextProvider c : this.command) {
                platform.dispatchCommand(c.get((Context)ctx));
            }
        }
    }

    private void executeCommands(Context ctx, Consumer<String> executor) {
        for (TextProvider c : this.command) {
            executor.accept(c.get(ctx));
        }
    }

    @Override
    public Key type() {
        return CommonFunctions.COMMAND;
    }

    public static class FactoryImpl<CTX extends Context>
    extends AbstractConditionalFunction.AbstractFactory<CTX> {
        public FactoryImpl(java.util.function.Function<Map<String, Object>, Condition<CTX>> factory) {
            super(factory);
        }

        @Override
        public Function<CTX> create(Map<String, Object> arguments) {
            Object command = ResourceConfigUtils.requireNonNullOrThrow(ResourceConfigUtils.get(arguments, "command", "commands"), "warning.config.function.command.missing_command");
            List<TextProvider> commands = MiscUtils.getAsStringList(command).stream().map(TextProviders::fromString).toList();
            boolean asPlayer = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("as-player", false), "as-player");
            boolean asEvent = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("as-event", false), "as-event");
            boolean asOp = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("as-op", false), "as-op");
            return new CommandFunction(this.getPredicates(arguments), PlayerSelectors.fromObject(arguments.get("target"), this.conditionFactory()), commands, asPlayer, asEvent, asOp);
        }
    }
}

