/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.function;

import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.function.AbstractConditionalFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommonFunctions;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelector;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelectors;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class DamageFunction<CTX extends Context>
extends AbstractConditionalFunction<CTX> {
    private final PlayerSelector<CTX> selector;
    private final Key damageType;
    private final NumberProvider amount;

    public DamageFunction(PlayerSelector<CTX> selector, Key damageType, NumberProvider amount, List<Condition<CTX>> predicates) {
        super(predicates);
        this.selector = selector;
        this.damageType = damageType;
        this.amount = amount;
    }

    @Override
    protected void runInternal(CTX ctx) {
        this.selector.get(ctx).forEach(p -> p.damage(this.amount.getDouble((Context)ctx), this.damageType));
    }

    @Override
    public Key type() {
        return CommonFunctions.DAMAGE;
    }

    public static class FactoryImpl<CTX extends Context>
    extends AbstractConditionalFunction.AbstractFactory<CTX> {
        public FactoryImpl(java.util.function.Function<Map<String, Object>, Condition<CTX>> factory) {
            super(factory);
        }

        @Override
        public Function<CTX> create(Map<String, Object> arguments) {
            PlayerSelector selector = PlayerSelectors.fromObject(arguments.getOrDefault("target", "self"), this.conditionFactory());
            Key damageType = Key.of(ResourceConfigUtils.getAsString(arguments.getOrDefault("damage-type", "generic")));
            NumberProvider amount = NumberProviders.fromObject(arguments.getOrDefault("amount", Float.valueOf(1.0f)));
            return new DamageFunction(selector, damageType, amount, this.getPredicates(arguments));
        }
    }
}

