/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.function;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.function.AbstractConditionalFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommonFunctions;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import net.momirealms.craftengine.core.world.particle.ParticleConfig;

public class ParticleFunction<CTX extends Context>
extends AbstractConditionalFunction<CTX> {
    private final ParticleConfig config;

    public ParticleFunction(ParticleConfig config, List<Condition<CTX>> predicates) {
        super(predicates);
        this.config = config;
    }

    @Override
    public void runInternal(CTX ctx) {
        Optional<WorldPosition> optionalWorldPosition = ctx.getOptionalParameter(DirectContextParameters.POSITION);
        if (optionalWorldPosition.isPresent()) {
            World world = optionalWorldPosition.get().world();
            Vec3d position = new Vec3d(this.config.x.getDouble((Context)ctx), this.config.y.getDouble((Context)ctx), this.config.z.getDouble((Context)ctx));
            world.spawnParticle(position, this.config.particleType, this.config.count.getInt((Context)ctx), this.config.xOffset.getDouble((Context)ctx), this.config.yOffset.getDouble((Context)ctx), this.config.zOffset.getDouble((Context)ctx), this.config.speed.getDouble((Context)ctx), this.config.particleData, (Context)ctx);
        }
    }

    @Override
    public Key type() {
        return CommonFunctions.PARTICLE;
    }

    public static class FactoryImpl<CTX extends Context>
    extends AbstractConditionalFunction.AbstractFactory<CTX> {
        public FactoryImpl(java.util.function.Function<Map<String, Object>, Condition<CTX>> factory) {
            super(factory);
        }

        @Override
        public Function<CTX> create(Map<String, Object> arguments) {
            return new ParticleFunction(ParticleConfig.fromMap$function(arguments), this.getPredicates(arguments));
        }
    }
}

