/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.function;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.ViewerContext;
import net.momirealms.craftengine.core.plugin.context.function.AbstractConditionalFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommonFunctions;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelector;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelectors;
import net.momirealms.craftengine.core.plugin.context.text.TextProvider;
import net.momirealms.craftengine.core.plugin.context.text.TextProviders;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.jetbrains.annotations.Nullable;

public class TeleportFunction<CTX extends Context>
extends AbstractConditionalFunction<CTX> {
    private final PlayerSelector<CTX> selector;
    @Nullable
    private final TextProvider world;
    private final NumberProvider x;
    private final NumberProvider y;
    private final NumberProvider z;
    private final NumberProvider pitch;
    private final NumberProvider yaw;

    public TeleportFunction(List<Condition<CTX>> predicates, @Nullable PlayerSelector<CTX> selector, @Nullable TextProvider world, NumberProvider x, NumberProvider y, NumberProvider z, NumberProvider pitch, NumberProvider yaw) {
        super(predicates);
        this.selector = selector;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    @Override
    public void runInternal(CTX ctx) {
        if (this.selector == null) {
            ctx.getOptionalParameter(DirectContextParameters.PLAYER).ifPresent(it -> it.teleport(new WorldPosition(Optional.ofNullable(this.world).map(w -> w.get((Context)ctx)).map(w -> CraftEngine.instance().platform().getWorld((String)w)).orElse(it.world()), this.x.getDouble((Context)ctx), this.y.getDouble((Context)ctx), this.z.getDouble((Context)ctx), this.pitch.getFloat((Context)ctx), this.yaw.getFloat((Context)ctx))));
        } else {
            for (Player viewer : this.selector.get(ctx)) {
                ViewerContext relationalContext = ViewerContext.of(ctx, PlayerOptionalContext.of(viewer));
                viewer.teleport(new WorldPosition(Optional.ofNullable(this.world).map(w -> w.get(relationalContext)).map(w -> CraftEngine.instance().platform().getWorld((String)w)).orElse(viewer.world()), this.x.getDouble(relationalContext), this.y.getDouble(relationalContext), this.z.getDouble(relationalContext), this.pitch.getFloat(relationalContext), this.yaw.getFloat(relationalContext)));
            }
        }
    }

    @Override
    public Key type() {
        return CommonFunctions.TELEPORT;
    }

    public static class FactoryImpl<CTX extends Context>
    extends AbstractConditionalFunction.AbstractFactory<CTX> {
        public FactoryImpl(java.util.function.Function<Map<String, Object>, Condition<CTX>> factory) {
            super(factory);
        }

        @Override
        public Function<CTX> create(Map<String, Object> arguments) {
            TextProvider world = Optional.ofNullable(arguments.get("world")).map(String::valueOf).map(TextProviders::fromString).orElse(null);
            NumberProvider x = NumberProviders.fromObject(ResourceConfigUtils.requireNonNullOrThrow(arguments.get("x"), "warning.config.function.teleport.missing_x"));
            NumberProvider y = NumberProviders.fromObject(ResourceConfigUtils.requireNonNullOrThrow(arguments.get("y"), "warning.config.function.teleport.missing_y"));
            NumberProvider z = NumberProviders.fromObject(ResourceConfigUtils.requireNonNullOrThrow(arguments.get("z"), "warning.config.function.teleport.missing_z"));
            NumberProvider yaw = NumberProviders.fromObject(arguments.getOrDefault("yaw", 0));
            NumberProvider pitch = NumberProviders.fromObject(arguments.getOrDefault("pitch", 0));
            return new TeleportFunction(this.getPredicates(arguments), PlayerSelectors.fromObject(arguments.get("target"), this.conditionFactory()), world, x, y, z, pitch, yaw);
        }
    }
}

