/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.function;

import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.ViewerContext;
import net.momirealms.craftengine.core.plugin.context.function.AbstractConditionalFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommonFunctions;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelector;
import net.momirealms.craftengine.core.plugin.context.selector.PlayerSelectors;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.Nullable;

public class TitleFunction<CTX extends Context>
extends AbstractConditionalFunction<CTX> {
    private final PlayerSelector<CTX> selector;
    private final String main;
    private final String sub;
    private final NumberProvider fadeIn;
    private final NumberProvider stay;
    private final NumberProvider fadeOut;

    public TitleFunction(List<Condition<CTX>> predicates, @Nullable PlayerSelector<CTX> selector, String main, String sub, NumberProvider fadeIn, NumberProvider stay, NumberProvider fadeOut) {
        super(predicates);
        this.selector = selector;
        this.main = main;
        this.sub = sub;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @Override
    public void runInternal(CTX ctx) {
        if (this.selector == null) {
            ctx.getOptionalParameter(DirectContextParameters.PLAYER).ifPresent(it -> it.sendTitle(AdventureHelper.miniMessage().deserialize(this.main, ctx.tagResolvers()), AdventureHelper.miniMessage().deserialize(this.sub, ctx.tagResolvers()), this.fadeIn.getInt((Context)ctx), this.stay.getInt((Context)ctx), this.fadeOut.getInt((Context)ctx)));
        } else {
            for (Player viewer : this.selector.get(ctx)) {
                ViewerContext relationalContext = ViewerContext.of(ctx, PlayerOptionalContext.of(viewer));
                viewer.sendTitle(AdventureHelper.miniMessage().deserialize(this.main, relationalContext.tagResolvers()), AdventureHelper.miniMessage().deserialize(this.sub, relationalContext.tagResolvers()), this.fadeIn.getInt(relationalContext), this.stay.getInt(relationalContext), this.fadeOut.getInt(relationalContext));
            }
        }
    }

    @Override
    public Key type() {
        return CommonFunctions.TITLE;
    }

    public static class FactoryImpl<CTX extends Context>
    extends AbstractConditionalFunction.AbstractFactory<CTX> {
        public FactoryImpl(java.util.function.Function<Map<String, Object>, Condition<CTX>> factory) {
            super(factory);
        }

        @Override
        public Function<CTX> create(Map<String, Object> arguments) {
            String title = arguments.getOrDefault("title", "").toString();
            String subtitle = arguments.getOrDefault("subtitle", "").toString();
            NumberProvider fadeIn = NumberProviders.fromObject(arguments.getOrDefault("fade-in", 10));
            NumberProvider stay = NumberProviders.fromObject(arguments.getOrDefault("stay", 20));
            NumberProvider fadeOut = NumberProviders.fromObject(arguments.getOrDefault("fade-out", 5));
            return new TitleFunction(this.getPredicates(arguments), PlayerSelectors.fromObject(arguments.get("target"), this.conditionFactory()), title, subtitle, fadeIn, stay, fadeOut);
        }
    }
}

