/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.ChainParameterProvider;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.world.ExistingBlock;

public class BlockParameterProvider
implements ChainParameterProvider<ExistingBlock> {
    private static final Map<ContextKey<?>, Function<ExistingBlock, Object>> CONTEXT_FUNCTIONS = new HashMap();

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter, ExistingBlock block) {
        return Optional.ofNullable(CONTEXT_FUNCTIONS.get(parameter)).map(f -> f.apply(block));
    }

    static {
        CONTEXT_FUNCTIONS.put(DirectContextParameters.X, ExistingBlock::x);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.Y, ExistingBlock::y);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.Z, ExistingBlock::z);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.BLOCK_X, ExistingBlock::x);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.BLOCK_Y, ExistingBlock::y);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.BLOCK_Z, ExistingBlock::z);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.CUSTOM_BLOCK, ExistingBlock::customBlock);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.CUSTOM_BLOCK_STATE, ExistingBlock::customBlockState);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.WORLD, ExistingBlock::world);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.POSITION, ExistingBlock::position);
    }
}

