/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.plugin.gui.Gui;
import net.momirealms.craftengine.core.plugin.gui.GuiElement;
import net.momirealms.craftengine.core.plugin.gui.Ingredient;

public class GuiLayout {
    private final Map<Character, Ingredient> elements = new HashMap<Character, Ingredient>();
    private final int width;
    private final int height;
    private final char[][] layout;

    public GuiLayout(char[][] layout) {
        this.elements.put(Character.valueOf(' '), Ingredient.EMPTY);
        this.layout = layout;
        this.height = layout.length;
        if (this.height == 0) {
            throw new IllegalArgumentException("Layout must have at least one element");
        }
        this.width = layout[0].length;
        if (this.width == 0) {
            throw new IllegalArgumentException("Layout must have at least one element");
        }
    }

    public GuiLayout(String ... layout) {
        this(GuiLayout.createLayout(layout));
    }

    private static char[][] createLayout(String ... layout) {
        ArrayList rows = new ArrayList();
        Collections.addAll(rows, layout);
        int height = rows.size();
        if (height == 0) {
            return new char[0][0];
        }
        int width = layout[0].length();
        char[][] array = new char[height][width];
        for (int i = 0; i < height; ++i) {
            String row = (String)rows.get(i);
            if (row.length() != width) {
                throw new IllegalArgumentException("All rows must have the same length as the first row (" + width + ")");
            }
            array[i] = row.toCharArray();
        }
        return array;
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    public GuiLayout addIngredient(char c, GuiElement supplier) {
        this.elements.put(Character.valueOf(c), Ingredient.simple(supplier));
        return this;
    }

    public GuiLayout addIngredient(char c, Ingredient ingredient) {
        this.elements.put(Character.valueOf(c), ingredient);
        return this;
    }

    public GuiElement[] createElements(Gui gui) {
        ArrayList<GuiElement.AbstractGuiElement> elementsList = new ArrayList<GuiElement.AbstractGuiElement>();
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                char c = this.layout[i][j];
                Ingredient ingredient = this.elements.get(Character.valueOf(c));
                if (ingredient == null) {
                    throw new IllegalStateException("No ingredient registered for character: " + c);
                }
                GuiElement.AbstractGuiElement element = (GuiElement.AbstractGuiElement)ingredient.element(gui);
                element.setGui(gui);
                elementsList.add(element);
            }
        }
        GuiElement[] result = new GuiElement[elementsList.size()];
        return elementsList.toArray(result);
    }
}

